/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.language.Linguistics;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.HasIndexItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.Iterator;
import java.util.ListIterator;

@After(value={"JuniperTagReplacing"})
public class NGramSearcher
extends Searcher {
    private final GramSplitter gramSplitter;
    private final CharacterClasses characterClasses;

    public NGramSearcher(Linguistics linguistics) {
        this.gramSplitter = linguistics.getGramSplitter();
        this.characterClasses = linguistics.getCharacterClasses();
    }

    @Override
    public Result search(Query query, Execution execution) {
        IndexFacts indexFacts = execution.context().getIndexFacts();
        if (!indexFacts.hasNGramIndices()) {
            return execution.search(query);
        }
        IndexFacts.Session session = indexFacts.newSession(query);
        boolean rewritten = this.rewriteToNGramMatching(query.getModel().getQueryTree().getRoot(), 0, session, query);
        if (rewritten) {
            query.trace("Rewritten to n-gram matching", true, 2);
        }
        Result result = execution.search(query);
        this.recombineNGrams(result.hits().deepIterator(), session);
        return result;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        execution.fill(result, summaryClass);
        IndexFacts indexFacts = execution.context().getIndexFacts();
        if (indexFacts.hasNGramIndices()) {
            this.recombineNGrams(result.hits().deepIterator(), indexFacts.newSession(result.getQuery()));
        }
    }

    private boolean rewriteToNGramMatching(Item item, int indexInParent, IndexFacts.Session indexFacts, Query query) {
        TermItem term;
        Index index;
        boolean rewritten = false;
        if (item instanceof SegmentItem) {
            SegmentItem segments = (SegmentItem)item;
            Index index2 = indexFacts.getIndex(segments.getIndexName());
            if (index2.isNGram()) {
                Item grams = this.splitToGrams(segments, LinguisticsCase.toLowerCase((String)segments.getRawWord()), index2.getGramSize(), query);
                this.replaceItemByGrams(item, grams, indexInParent);
                rewritten = true;
            }
        } else if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            for (int i = 0; i < composite.getItemCount(); ++i) {
                rewritten = this.rewriteToNGramMatching(composite.getItem(i), i, indexFacts, query) || rewritten;
            }
        } else if (item instanceof TermItem && (index = indexFacts.getIndex((term = (TermItem)item).getIndexName())).isNGram()) {
            Item grams = this.splitToGrams(term, term.stringValue(), index.getGramSize(), query);
            this.replaceItemByGrams(item, grams, indexInParent);
            rewritten = true;
        }
        return rewritten;
    }

    protected Item splitToGrams(Item term, String text, int gramSize, Query query) {
        String index = ((HasIndexItem)((Object)term)).getIndexName();
        CompositeItem gramsItem = this.createGramRoot((HasIndexItem)((Object)term), query);
        gramsItem.setIndexName(index);
        Substring origin = ((BlockItem)((Object)term)).getOrigin();
        GramSplitter.GramSplitterIterator i = this.getGramSplitter().split(text, gramSize);
        while (i.hasNext()) {
            GramSplitter.Gram gram = (GramSplitter.Gram)i.next();
            WordItem gramWord = new WordItem(gram.extractFrom(text), index, false, origin);
            gramWord.setWeight(term.getWeight());
            gramWord.setProtected(true);
            gramsItem.addItem(gramWord);
        }
        return gramsItem.getItemCount() == 1 ? gramsItem.getItem(0) : gramsItem;
    }

    protected final GramSplitter getGramSplitter() {
        return this.gramSplitter;
    }

    protected CompositeItem createGramRoot(HasIndexItem term, Query query) {
        return this.createGramRoot(query);
    }

    protected CompositeItem createGramRoot(Query query) {
        return new AndItem();
    }

    private void replaceItemByGrams(Item item, Item grams, int indexInParent) {
        if (!(grams instanceof CompositeItem) || !(item.getParent() instanceof PhraseItem)) {
            item.getParent().setItem(indexInParent, grams);
        } else {
            PhraseItem phraseParent = (PhraseItem)item.getParent();
            phraseParent.removeItem(indexInParent);
            int addedTerms = 0;
            ListIterator<Item> i = ((CompositeItem)grams).getItemIterator();
            while (i.hasNext()) {
                phraseParent.addItem(indexInParent + addedTerms++, (Item)i.next());
            }
        }
    }

    private void recombineNGrams(Iterator<Hit> hits, IndexFacts.Session session) {
        while (hits.hasNext()) {
            Hit hit = hits.next();
            if (hit.isMeta()) continue;
            Object sddocname = hit.getField("sddocname");
            if (sddocname == null) {
                return;
            }
            for (Index index : session.getIndexes(sddocname.toString())) {
                Object fieldValue;
                if (!index.isNGram() || !index.getHighlightSummary() && !index.getDynamicSummary() || (fieldValue = hit.getField(index.getName())) == null) continue;
                hit.setField(index.getName(), this.recombineNGramsField(fieldValue, index.getGramSize()));
            }
        }
    }

    private Object recombineNGramsField(Object fieldValue, int gramSize) {
        String recombined = this.recombineNGrams(fieldValue.toString(), gramSize);
        if (fieldValue instanceof JSONString) {
            return new JSONString(recombined);
        }
        if (fieldValue instanceof XMLString) {
            return new XMLString(recombined);
        }
        return recombined;
    }

    private String recombineNGrams(String string, int gramSize) {
        StringBuilder b = new StringBuilder();
        int consecutiveWordChars = 0;
        boolean inBolding = false;
        MatchTokenStrippingCharacterIterator characters = new MatchTokenStrippingCharacterIterator(string);
        while (characters.hasNext()) {
            boolean atBoldingSeparator;
            char c = characters.next();
            boolean bl = atBoldingSeparator = c == '\u001f';
            if (atBoldingSeparator && characters.peek() == '\u001f') {
                characters.next();
                continue;
            }
            if (!this.characterClasses.isLetterOrDigit((int)c)) {
                if (atBoldingSeparator) {
                    boolean bl2 = inBolding = !inBolding;
                }
                if (!atBoldingSeparator || !this.nextIsLetterOrDigit(characters)) {
                    consecutiveWordChars = 0;
                }
                if (inBolding && atBoldingSeparator && this.areWordCharactersBackwards(gramSize - 1, b)) {
                    b.insert(b.length() - (gramSize - 1), c);
                    continue;
                }
                b.append(c);
                continue;
            }
            if (++consecutiveWordChars >= gramSize && consecutiveWordChars % gramSize != 0) continue;
            b.append(c);
        }
        return b.toString();
    }

    private boolean areWordCharactersBackwards(int count, StringBuilder b) {
        for (int i = 0; i < count; ++i) {
            int checkIndex = b.length() - 1 - i;
            if (checkIndex < 0) {
                return false;
            }
            if (this.characterClasses.isLetterOrDigit((int)b.charAt(checkIndex))) continue;
            return false;
        }
        return true;
    }

    private boolean nextIsLetterOrDigit(MatchTokenStrippingCharacterIterator characters) {
        return this.characterClasses.isLetterOrDigit((int)characters.peek());
    }

    private static class MatchTokenStrippingCharacterIterator {
        private final String s;
        private int current = 0;

        public MatchTokenStrippingCharacterIterator(String s) {
            this.s = s;
        }

        public boolean hasNext() {
            this.skipMarkup();
            return this.current < this.s.length();
        }

        public char next() {
            this.skipMarkup();
            return this.s.charAt(this.current++);
        }

        public char peek() {
            this.skipMarkup();
            if (this.s.length() < this.current + 1) {
                return '\uffff';
            }
            return this.s.charAt(this.current);
        }

        private void skipMarkup() {
            if (this.current >= this.s.length()) {
                return;
            }
            char c = this.s.charAt(this.current);
            if (c == '\ufff9') {
                ++this.current;
            } else if (c == '\ufffa') {
                do {
                    ++this.current;
                } while (this.current < this.s.length() && this.s.charAt(this.current) != '\ufffb');
                ++this.current;
                this.skipMarkup();
            }
        }
    }
}

