/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.api.annotations.Beta;
import com.yahoo.prelude.query.textualrepresentation.TextualQueryRepresentation;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.profile.QueryProfileProperties;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public class Trace
implements Cloneable {
    private static final Logger log = Logger.getLogger(Trace.class.getName());
    private static final QueryProfileType argumentType = new QueryProfileType("trace");
    public static final String TRACE = "trace";
    public static final String LEVEL = "level";
    public static final String EXPLAIN_LEVEL = "explainLevel";
    public static final String PROFILE_DEPTH = "profileDepth";
    public static final String TIMESTAMPS = "timestamps";
    public static final String QUERY = "query";
    private Query parent;
    private int level = 0;
    private int explainLevel = 0;
    private int profileDepth = 0;
    private boolean timestamps = false;
    private boolean query = true;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Trace(Query parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isTraceable(int level) {
        return level <= this.level;
    }

    public void setExplainLevel(int explainLevel) {
        this.explainLevel = explainLevel;
    }

    public int getExplainLevel() {
        return this.explainLevel;
    }

    public void setProfileDepth(int profileDepth) {
        this.profileDepth = profileDepth;
    }

    public int getProfileDepth() {
        return this.profileDepth;
    }

    public boolean getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
    }

    public boolean getQuery() {
        return this.query;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    public void trace(String message, int traceLevel) {
        this.trace(message, false, traceLevel);
    }

    public void trace(Object message, int traceLevel) {
        if (!this.isTraceable(traceLevel)) {
            return;
        }
        this.parent.getContext(true).trace(message, 0);
    }

    public void trace(String message, boolean includeQuery, int traceLevel) {
        if (!this.isTraceable(traceLevel)) {
            return;
        }
        if (includeQuery && this.query) {
            message = (String)message + ": [" + this.queryTreeText() + "]";
        }
        log.log(Level.FINE, (String)message);
        this.parent.getContext(true).trace((String)message, 0);
    }

    public void trace(boolean includeQuery, int traceLevel, Object ... messages) {
        if (!this.isTraceable(traceLevel)) {
            return;
        }
        StringBuilder concatenated = new StringBuilder();
        for (Object message : messages) {
            concatenated.append(message);
        }
        this.trace(concatenated.toString(), includeQuery, traceLevel);
    }

    public void traceProperties() {
        if (this.level == 0) {
            return;
        }
        CompiledQueryProfile profile = null;
        QueryProfileProperties profileProperties = (QueryProfileProperties)this.parent.properties().getInstance(QueryProfileProperties.class);
        if (profileProperties != null) {
            profile = profileProperties.getQueryProfile();
        }
        if (profile == null) {
            this.trace("No query profile is used", false, 1);
        } else {
            this.trace("Using " + profile.toString(), false, 1);
        }
        if (this.level < 4) {
            return;
        }
        StringBuilder b = new StringBuilder("Resolved properties:\n");
        HashSet<String> mentioned = new HashSet<String>();
        for (Map.Entry<String, String> requestProperty : this.requestProperties().entrySet()) {
            Object resolvedValue = this.parent.properties().get(requestProperty.getKey(), this.requestProperties());
            if (resolvedValue == null && requestProperty.getKey().equals("queryProfile")) {
                resolvedValue = requestProperty.getValue();
            }
            b.append(requestProperty.getKey());
            b.append(": ");
            b.append(resolvedValue);
            b.append(" (");
            if (profile != null && !profile.isOverridable(new CompoundName(requestProperty.getKey()), this.requestProperties())) {
                b.append("from query profile - unoverridable, ignoring request value");
            } else {
                b.append("from request");
            }
            b.append(")\n");
            mentioned.add(requestProperty.getKey());
        }
        if (profile != null) {
            this.appendQueryProfileProperties(profile, mentioned, b);
        }
        this.trace(b.toString(), false, 4);
    }

    private void appendQueryProfileProperties(CompiledQueryProfile profile, Set<String> mentioned, StringBuilder b) {
        for (Map.Entry<String, ValueWithSource> property : profile.listValuesWithSources(CompoundName.empty, this.requestProperties(), this.parent.properties()).entrySet()) {
            if (mentioned.contains(property.getKey())) continue;
            b.append(property.getKey()).append(": ").append(property.getValue()).append("\n");
        }
    }

    private Map<String, String> requestProperties() {
        return this.parent.getHttpRequest().propertyMap();
    }

    private String queryTreeText() {
        QueryTree root = this.parent.getModel().getQueryTree();
        if (this.level < 2) {
            return root.toString();
        }
        if (this.level < 6) {
            return this.parent.yqlRepresentation();
        }
        return "\n" + this.parent.yqlRepresentation() + "\n" + new TextualQueryRepresentation(root.getRoot()) + "\n";
    }

    public Trace cloneFor(Query parent) {
        Trace trace = this.clone();
        trace.parent = parent;
        return trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)o;
        if (other.level != this.level) {
            return false;
        }
        if (other.explainLevel != this.explainLevel) {
            return false;
        }
        if (other.timestamps != this.timestamps) {
            return false;
        }
        return other.query == this.query;
    }

    public int hashCode() {
        return Objects.hash(this.level, this.explainLevel, this.timestamps, this.query);
    }

    public Trace clone() {
        try {
            return (Trace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "trace [level: " + this.level + ", explainLevel: " + this.explainLevel + ", timestamps: " + this.timestamps + ", query: " + this.query + "]";
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(LEVEL, "integer", "tracelevel traceLevel"));
        argumentType.addField(new FieldDescription(EXPLAIN_LEVEL, "integer", "explainlevel explainLevel"));
        argumentType.addField(new FieldDescription(PROFILE_DEPTH, "integer"));
        argumentType.addField(new FieldDescription(TIMESTAMPS, "boolean"));
        argumentType.addField(new FieldDescription(QUERY, "boolean"));
        argumentType.freeze();
    }
}

