/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.Query;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Sorting
implements Cloneable {
    public static final String STRENGTH_IDENTICAL = "identical";
    public static final String STRENGTH_QUATERNARY = "quaternary";
    public static final String STRENGTH_TERTIARY = "tertiary";
    public static final String STRENGTH_SECONDARY = "secondary";
    public static final String STRENGTH_PRIMARY = "primary";
    public static final String UCA = "uca";
    public static final String RAW = "raw";
    public static final String LOWERCASE = "lowercase";
    private final List<FieldOrder> fieldOrders = new ArrayList<FieldOrder>(2);

    public Sorting() {
    }

    public Sorting(List<FieldOrder> fieldOrders) {
        this.fieldOrders.addAll(fieldOrders);
    }

    public Sorting(String sortSpec) {
        this.setSpec(sortSpec, null);
    }

    public Sorting(String sortSpec, Query query) {
        IndexFacts.Session session = null;
        if (query != null && query.getModel().getExecution().context().getIndexFacts() != null) {
            session = query.getModel().getExecution().context().getIndexFacts().newSession(query);
        }
        this.setSpec(sortSpec, session);
    }

    public static Sorting fromString(String sortSpec) {
        if (sortSpec == null) {
            return null;
        }
        if ("".equals(sortSpec)) {
            return null;
        }
        return new Sorting(sortSpec);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSpec(String rawSortSpec, IndexFacts.Session indexFacts) {
        String[] stringArray = rawSortSpec.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block19: {
                AttributeSorter sorter;
                int funcAttrStart;
                char orderMarker;
                block18: {
                    String sortString;
                    block20: {
                        String functionName;
                        block23: {
                            int endPar;
                            int startPar;
                            block22: {
                                block21: {
                                    if (n2 >= n) {
                                        return;
                                    }
                                    sortString = stringArray[n2];
                                    if (sortString.length() < 1) break block19;
                                    orderMarker = sortString.charAt(0);
                                    funcAttrStart = 0;
                                    if (orderMarker == '+' || orderMarker == '-') {
                                        funcAttrStart = 1;
                                    }
                                    startPar = sortString.indexOf(40, funcAttrStart);
                                    endPar = sortString.lastIndexOf(41);
                                    if (startPar <= 0 || endPar <= startPar) break block20;
                                    functionName = sortString.substring(funcAttrStart, startPar);
                                    if (!LOWERCASE.equalsIgnoreCase(functionName)) break block21;
                                    sorter = new LowerCaseSorter(this.canonic(sortString.substring(startPar + 1, endPar), indexFacts));
                                    break block18;
                                }
                                if (!RAW.equalsIgnoreCase(functionName)) break block22;
                                sorter = new RawSorter(this.canonic(sortString.substring(startPar + 1, endPar), indexFacts));
                                break block18;
                            }
                            if (!UCA.equalsIgnoreCase(functionName)) break block23;
                            int commaPos = sortString.indexOf(44, startPar + 1);
                            if (startPar + 1 < commaPos && commaPos < endPar) {
                                int commaopt = sortString.indexOf(44, commaPos + 1);
                                UcaSorter.Strength strength = UcaSorter.Strength.UNDEFINED;
                                if (commaopt > 0) {
                                    String s = sortString.substring(commaopt + 1, endPar);
                                    if (STRENGTH_PRIMARY.equalsIgnoreCase(s)) {
                                        strength = UcaSorter.Strength.PRIMARY;
                                    } else if (STRENGTH_SECONDARY.equalsIgnoreCase(s)) {
                                        strength = UcaSorter.Strength.SECONDARY;
                                    } else if (STRENGTH_TERTIARY.equalsIgnoreCase(s)) {
                                        strength = UcaSorter.Strength.TERTIARY;
                                    } else if (STRENGTH_QUATERNARY.equalsIgnoreCase(s)) {
                                        strength = UcaSorter.Strength.QUATERNARY;
                                    } else {
                                        if (!STRENGTH_IDENTICAL.equalsIgnoreCase(s)) {
                                            throw new IllegalInputException("Unknown collation strength: '" + s + "'");
                                        }
                                        strength = UcaSorter.Strength.IDENTICAL;
                                    }
                                    sorter = new UcaSorter(this.canonic(sortString.substring(startPar + 1, commaPos), indexFacts), sortString.substring(commaPos + 1, commaopt), strength);
                                    break block18;
                                } else {
                                    sorter = new UcaSorter(this.canonic(sortString.substring(startPar + 1, commaPos), indexFacts), sortString.substring(commaPos + 1, endPar), strength);
                                }
                                break block18;
                            } else {
                                sorter = new UcaSorter(this.canonic(sortString.substring(startPar + 1, endPar), indexFacts));
                            }
                            break block18;
                        }
                        if (functionName.isEmpty()) {
                            throw new IllegalInputException("No sort function specified");
                        }
                        throw new IllegalInputException("Unknown sort function '" + functionName + "'");
                    }
                    sorter = new AttributeSorter(this.canonic(sortString.substring(funcAttrStart), indexFacts));
                }
                Order order = Order.UNDEFINED;
                if (funcAttrStart != 0) {
                    order = orderMarker == '+' ? Order.ASCENDING : Order.DESCENDING;
                }
                this.fieldOrders.add(new FieldOrder(sorter, order));
            }
            ++n2;
        }
    }

    private String canonic(String attributeName, IndexFacts.Session indexFacts) {
        if (indexFacts == null) {
            return attributeName;
        }
        return indexFacts.getCanonicName(attributeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String space = "";
        for (FieldOrder spec : this.fieldOrders) {
            sb.append(space);
            if (spec.getSortOrder() == Order.DESCENDING) {
                sb.append("-");
            } else {
                sb.append("+");
            }
            sb.append(spec.getFieldName());
            space = " ";
        }
        return sb.toString();
    }

    public List<FieldOrder> fieldOrders() {
        return this.fieldOrders;
    }

    public Sorting clone() {
        return new Sorting(this.fieldOrders);
    }

    public int hashCode() {
        return this.fieldOrders.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sorting)) {
            return false;
        }
        Sorting ss = (Sorting)o;
        return this.fieldOrders.equals(ss.fieldOrders);
    }

    public int encode(ByteBuffer buffer) {
        int usedBytes = 0;
        buffer.position();
        int space = 46;
        for (FieldOrder fieldOrder : this.fieldOrders) {
            if (space == 32) {
                buffer.put((byte)space);
                ++usedBytes;
            }
            if (fieldOrder.getSortOrder() == Order.ASCENDING) {
                buffer.put((byte)43);
            } else {
                buffer.put((byte)45);
            }
            ++usedBytes;
            byte[] nameBuffer = Utf8.toBytes((String)fieldOrder.getSorter().toSerialForm());
            buffer.put(nameBuffer);
            usedBytes += nameBuffer.length;
            space = 32;
        }
        return usedBytes;
    }

    public static class LowerCaseSorter
    extends AttributeSorter {
        public LowerCaseSorter(String fieldName) {
            super(fieldName);
        }

        @Override
        public String toSerialForm() {
            return "lowercase(" + this.getName() + ")";
        }

        @Override
        public int hashCode() {
            return 1 + 3 * super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof LowerCaseSorter)) {
                return false;
            }
            return super.equals(other);
        }

        @Override
        public int compare(Comparable a, Comparable b) {
            if (a instanceof String && b instanceof String) {
                return ((String)((Object)a)).compareToIgnoreCase((String)((Object)b));
            }
            return a.compareTo(b);
        }
    }

    public static class RawSorter
    extends AttributeSorter {
        public RawSorter(String fieldName) {
            super(fieldName);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RawSorter)) {
                return false;
            }
            return super.equals(other);
        }
    }

    public static class UcaSorter
    extends AttributeSorter {
        private String locale = null;
        private Strength strength = Strength.UNDEFINED;
        private Collator collator;

        public UcaSorter(String fieldName, String locale, Strength strength) {
            super(fieldName);
            this.setLocale(locale, strength);
        }

        public UcaSorter(String fieldName) {
            super(fieldName);
        }

        private static int strength2Collator(Strength strength) {
            switch (strength) {
                case PRIMARY: {
                    return 0;
                }
                case SECONDARY: {
                    return 1;
                }
                case TERTIARY: {
                    return 2;
                }
                case QUATERNARY: {
                    return 3;
                }
                case IDENTICAL: {
                    return 15;
                }
                case UNDEFINED: {
                    return 0;
                }
            }
            return 0;
        }

        public void setLocale(String locale, Strength strength) {
            ULocale uloc;
            this.locale = locale;
            this.strength = strength;
            try {
                uloc = new ULocale(locale);
            }
            catch (Throwable e) {
                throw new RuntimeException("ULocale(" + locale + ") failed with exception " + e.toString());
            }
            try {
                this.collator = Collator.getInstance((ULocale)uloc);
                if (this.collator == null) {
                    throw new RuntimeException("No collator available for: " + locale);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Collator.getInstance(ULocale(" + locale + ")) failed with exception " + e.toString());
            }
            this.collator.setStrength(UcaSorter.strength2Collator(strength));
        }

        public String getLocale() {
            return this.locale;
        }

        public Strength getStrength() {
            return this.strength;
        }

        Collator getCollator() {
            return this.collator;
        }

        public String getDecomposition() {
            return this.collator.getDecomposition() == 17 ? "CANONICAL_DECOMPOSITION" : "NO_DECOMPOSITION";
        }

        @Override
        public String toSerialForm() {
            return "uca(" + this.getName() + "," + this.locale + "," + (this.strength != Strength.UNDEFINED ? this.strength.toString() : "PRIMARY") + ")";
        }

        @Override
        public int hashCode() {
            return 1 + 3 * this.locale.hashCode() + 5 * this.strength.hashCode() + 7 * super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof UcaSorter)) {
                return false;
            }
            return super.equals(other) && this.locale.equals(((UcaSorter)other).locale) && this.strength == ((UcaSorter)other).strength;
        }

        @Override
        public UcaSorter clone() {
            UcaSorter clone = (UcaSorter)super.clone();
            if (this.locale != null) {
                clone.setLocale(this.locale, this.strength);
            }
            return clone;
        }

        @Override
        public int compare(Comparable a, Comparable b) {
            if (a instanceof String && b instanceof String) {
                return this.collator.compare((String)((Object)a), (String)((Object)b));
            }
            return a.compareTo(b);
        }

        public static enum Strength {
            PRIMARY,
            SECONDARY,
            TERTIARY,
            QUATERNARY,
            IDENTICAL,
            UNDEFINED;

        }
    }

    public static class AttributeSorter
    implements Cloneable {
        private static final Pattern legalAttributeName = Pattern.compile("[\\[]*[a-zA-Z_][\\.a-zA-Z0-9_-]*[\\]]*");
        private String fieldName;

        public AttributeSorter(String fieldName) {
            if (!legalAttributeName.matcher(fieldName).matches()) {
                throw new IllegalInputException("Illegal attribute name '" + fieldName + "' for sorting. Requires '" + legalAttributeName.pattern() + "'");
            }
            this.fieldName = fieldName;
        }

        public String getName() {
            return this.fieldName;
        }

        public void setName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toSerialForm() {
            return this.fieldName;
        }

        public String toString() {
            return this.toSerialForm();
        }

        public int hashCode() {
            return this.fieldName.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof AttributeSorter)) {
                return false;
            }
            return ((AttributeSorter)other).fieldName.equals(this.fieldName);
        }

        public AttributeSorter clone() {
            try {
                return (AttributeSorter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public int compare(Comparable a, Comparable b) {
            return a.compareTo(b);
        }
    }

    public static enum Order {
        ASCENDING,
        DESCENDING,
        UNDEFINED;

    }

    public static class FieldOrder
    implements Cloneable {
        private AttributeSorter fieldSorter;
        private Order sortOrder;

        public FieldOrder(AttributeSorter fieldSorter, Order sortOrder) {
            this.fieldSorter = fieldSorter;
            this.sortOrder = sortOrder;
        }

        public String getFieldName() {
            return this.fieldSorter.getName();
        }

        public AttributeSorter getSorter() {
            return this.fieldSorter;
        }

        public void setSorter(AttributeSorter sorter) {
            this.fieldSorter = sorter;
        }

        public Order getSortOrder() {
            return this.sortOrder;
        }

        public void setAscending(boolean asc) {
            this.sortOrder = asc ? Order.ASCENDING : Order.DESCENDING;
        }

        public String toString() {
            return this.sortOrder.toString() + ":" + this.fieldSorter.toString();
        }

        public int hashCode() {
            return this.sortOrder.hashCode() + 17 * this.fieldSorter.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldOrder)) {
                return false;
            }
            FieldOrder other = (FieldOrder)o;
            return other.sortOrder.equals((Object)this.sortOrder) && other.fieldSorter.equals(this.fieldSorter);
        }

        public FieldOrder clone() {
            return new FieldOrder(this.fieldSorter.clone(), this.sortOrder);
        }
    }
}

