/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.federation.SearchchainForwardConfig;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.SearchChain;

@After(value={"*"})
public class ForwardingSearcher
extends PingableSearcher {
    private final ComponentSpecification target;

    public ForwardingSearcher(SearchchainForwardConfig config) {
        if (config.target() == null) {
            throw new RuntimeException("Configuration value searchchain-forward.target was null.");
        }
        try {
            this.target = new ComponentSpecification(config.target());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed constructing the component specification from searchchain-forward.target: " + config.target(), e);
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        Execution next = this.createForward(execution);
        if (next == null) {
            return this.badResult(query);
        }
        return next.search(query);
    }

    private Result badResult(Query query) {
        return new Result(query, this.noSearchchain());
    }

    @Override
    public Pong ping(Ping ping, Execution execution) {
        Execution next = this.createForward(execution);
        if (next == null) {
            return this.badPong();
        }
        return next.ping(ping);
    }

    private Pong badPong() {
        return new Pong(this.noSearchchain());
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Execution next = this.createForward(execution);
        if (next == null) {
            this.badFill(result.hits());
        } else {
            next.fill(result, summaryClass);
        }
    }

    private void badFill(HitGroup hits) {
        hits.addError(this.noSearchchain());
    }

    private Execution createForward(Execution execution) {
        SearchChain targetChain = execution.context().searchChainRegistry().getComponent(this.target);
        if (targetChain == null) {
            return null;
        }
        return new Execution(targetChain, execution.context());
    }

    private ErrorMessage noSearchchain() {
        return ErrorMessage.createServerIsMisconfigured("Could not get search chain matching component specification: " + this.target);
    }
}

