/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class Node {
    private final int key;
    private int pathIndex;
    private final String hostname;
    private final int group;
    private final AtomicBoolean statusIsKnown = new AtomicBoolean(false);
    private final AtomicBoolean working = new AtomicBoolean(true);
    private final AtomicLong activeDocuments = new AtomicLong(0L);
    private final AtomicLong targetActiveDocuments = new AtomicLong(0L);
    private final AtomicLong pingSequence = new AtomicLong(0L);
    private final AtomicLong lastPong = new AtomicLong(0L);
    private final AtomicBoolean isBlockingWrites = new AtomicBoolean(false);

    public Node(int key, String hostname, int group) {
        this.key = key;
        this.hostname = hostname;
        this.group = group;
    }

    public long createPingSequenceId() {
        return this.pingSequence.incrementAndGet();
    }

    public boolean isLastReceivedPong(long pingId) {
        long last = this.lastPong.get();
        while (pingId > last && !this.lastPong.compareAndSet(last, pingId)) {
            last = this.lastPong.get();
        }
        return last < pingId;
    }

    public long getLastReceivedPongId() {
        return this.lastPong.get();
    }

    public int key() {
        return this.key;
    }

    public int pathIndex() {
        return this.pathIndex;
    }

    void setPathIndex(int index) {
        this.pathIndex = index;
    }

    public String hostname() {
        return this.hostname;
    }

    public int group() {
        return this.group;
    }

    public void setWorking(boolean working) {
        this.statusIsKnown.lazySet(true);
        this.working.lazySet(working);
        if (!working) {
            this.activeDocuments.set(0L);
            this.targetActiveDocuments.set(0L);
        }
    }

    public Boolean isWorking() {
        return this.statusIsKnown.get() ? Boolean.valueOf(this.working.get()) : null;
    }

    public void setActiveDocuments(long documents) {
        this.activeDocuments.set(documents);
    }

    public void setTargetActiveDocuments(long documents) {
        this.targetActiveDocuments.set(documents);
    }

    long getActiveDocuments() {
        return this.activeDocuments.get();
    }

    long getTargetActiveDocuments() {
        return this.targetActiveDocuments.get();
    }

    public void setBlockingWrites(boolean isBlockingWrites) {
        this.isBlockingWrites.set(isBlockingWrites);
    }

    boolean isBlockingWrites() {
        return this.isBlockingWrites.get();
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.key, this.pathIndex, this.group);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!Objects.equals(this.hostname, other.hostname)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        if (!Objects.equals(this.pathIndex, other.pathIndex)) {
            return false;
        }
        return Objects.equals(this.group, other.group);
    }

    public String toString() {
        return "search node key = " + this.key + " hostname = " + this.hostname + " path = " + this.pathIndex + " in group " + this.group + " statusIsKnown = " + this.statusIsKnown.get() + " working = " + this.working.get() + " activeDocs = " + this.getActiveDocuments() + " targetActiveDocs = " + this.getTargetActiveDocuments();
    }
}

