/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.prelude.Pong;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.dispatch.rpc.Client;
import com.yahoo.search.dispatch.rpc.RpcResourcePool;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.Pinger;
import com.yahoo.search.dispatch.searchcluster.PongHandler;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.yolean.Exceptions;
import java.util.logging.Logger;

public class RpcPing
implements Pinger,
Client.ResponseReceiver {
    private static final Logger log = Logger.getLogger(RpcPing.class.getName());
    private static final String RPC_METHOD = "vespa.searchprotocol.ping";
    private static final CompressionType PING_COMPRESSION = CompressionType.NONE;
    private static final boolean triggeredClassLoading = ErrorMessage.createBackendCommunicationError("TriggerClassLoading") instanceof ErrorMessage;
    private final Node node;
    private final RpcResourcePool resourcePool;
    private final ClusterMonitor<Node> clusterMonitor;
    private final long pingSequenceId;
    private final PongHandler pongHandler;

    public RpcPing(Node node, ClusterMonitor<Node> clusterMonitor, RpcResourcePool rpcResourcePool, PongHandler pongHandler) {
        this.node = node;
        this.resourcePool = rpcResourcePool;
        this.clusterMonitor = clusterMonitor;
        this.pingSequenceId = node.createPingSequenceId();
        this.pongHandler = pongHandler;
    }

    @Override
    public void ping() {
        try {
            this.sendPing();
        }
        catch (RuntimeException e) {
            this.pongHandler.handle(new Pong(ErrorMessage.createBackendCommunicationError("Exception when pinging " + this.node + ": " + Exceptions.toMessageString((Throwable)e))));
        }
    }

    private Pong toPong(Client.ResponseOrError<Client.ProtobufResponse> responseOrError) {
        if (responseOrError == null) {
            return new Pong(ErrorMessage.createNoAnswerWhenPingingNode("Timed out waiting for pong from " + this.node));
        }
        if (responseOrError.error().isPresent()) {
            return new Pong(ErrorMessage.createBackendCommunicationError(responseOrError.error().get()));
        }
        try {
            return this.decodeReply(responseOrError.response().get());
        }
        catch (InvalidProtocolBufferException e) {
            return new Pong(ErrorMessage.createBackendCommunicationError(e.getMessage()));
        }
    }

    private void sendPing() {
        Client.NodeConnection connection = this.resourcePool.getConnection(this.node.key());
        byte[] ping = SearchProtocol.MonitorRequest.newBuilder().build().toByteArray();
        double timeoutSeconds = (double)this.clusterMonitor.getConfiguration().getRequestTimeout() / 1000.0;
        Compressor.Compression compressionResult = this.resourcePool.compressor().compress(PING_COMPRESSION, ping);
        connection.request(RPC_METHOD, compressionResult.type(), ping.length, compressionResult.data(), this, timeoutSeconds);
    }

    private Pong decodeReply(Client.ProtobufResponse response) throws InvalidProtocolBufferException {
        CompressionType compression = CompressionType.valueOf((byte)response.compression());
        byte[] responseBytes = this.resourcePool.compressor().decompress(response.compressedPayload(), compression, response.uncompressedSize());
        SearchProtocol.MonitorReply reply = SearchProtocol.MonitorReply.parseFrom((byte[])responseBytes);
        if (reply.getDistributionKey() != this.node.key()) {
            return new Pong(ErrorMessage.createBackendCommunicationError("Expected pong from node id " + this.node.key() + ", response is from id " + reply.getDistributionKey()));
        }
        if (!reply.getOnline()) {
            return new Pong(ErrorMessage.createBackendCommunicationError("Node id " + this.node.key() + " reports being offline"));
        }
        return new Pong(reply.getActiveDocs(), reply.getTargetActiveDocs(), reply.getIsBlockingWrites());
    }

    @Override
    public void receive(Client.ResponseOrError<Client.ProtobufResponse> response) {
        if (this.clusterMonitor.isClosed() && !triggeredClassLoading) {
            return;
        }
        if (this.node.isLastReceivedPong(this.pingSequenceId)) {
            this.pongHandler.handle(this.toPong(response));
        } else {
            log.info("Pong " + this.pingSequenceId + " from node " + this.node.key() + " in group " + this.node.group() + " with hostname " + this.node.hostname() + " received too late, latest is " + this.node.getLastReceivedPongId());
        }
    }
}

