/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.dispatch.TimeoutHandler;
import com.yahoo.search.result.Coverage;

public class CoverageAggregator {
    private final int askedNodes;
    private int answeredNodes = 0;
    private int answeredNodesParticipated = 0;
    private int failedNodes = 0;
    private long answeredDocs = 0L;
    private long answeredActiveDocs = 0L;
    private long answeredTargetActiveDocs = 0L;
    private boolean timedOut = false;
    private boolean degradedByMatchPhase = false;

    CoverageAggregator(int askedNodes) {
        this.askedNodes = askedNodes;
    }

    CoverageAggregator(CoverageAggregator rhs) {
        this.askedNodes = rhs.askedNodes;
        this.answeredNodes = rhs.answeredNodes;
        this.answeredNodesParticipated = rhs.answeredNodesParticipated;
        this.failedNodes = rhs.failedNodes;
        this.answeredDocs = rhs.answeredDocs;
        this.answeredActiveDocs = rhs.answeredActiveDocs;
        this.answeredTargetActiveDocs = rhs.answeredTargetActiveDocs;
        this.timedOut = rhs.timedOut;
        this.degradedByMatchPhase = rhs.degradedByMatchPhase;
    }

    void add(Coverage source) {
        this.answeredDocs += source.getDocs();
        this.answeredActiveDocs += source.getActive();
        this.answeredTargetActiveDocs += source.getTargetActive();
        this.answeredNodesParticipated += source.getNodes();
        ++this.answeredNodes;
        this.degradedByMatchPhase |= source.isDegradedByMatchPhase();
        this.timedOut |= source.isDegradedByTimeout();
    }

    public int getAskedNodes() {
        return this.askedNodes;
    }

    public int getAnsweredNodes() {
        return this.answeredNodes;
    }

    public boolean hasNoAnswers() {
        return this.answeredNodes == 0;
    }

    public void setTimedOut() {
        this.timedOut = true;
    }

    public void setFailedNodes(int failedNodes) {
        this.failedNodes = failedNodes;
    }

    public Coverage createCoverage(TimeoutHandler timeoutHandler) {
        Coverage coverage = new Coverage(this.answeredDocs, this.answeredActiveDocs, this.answeredNodesParticipated, 1);
        coverage.setNodesTried(this.askedNodes);
        coverage.setTargetActive(this.answeredTargetActiveDocs);
        int degradedReason = 0;
        if (this.timedOut) {
            degradedReason |= timeoutHandler.reason();
        }
        if (this.degradedByMatchPhase) {
            degradedReason |= 1;
        }
        coverage.setDegradedReason(degradedReason);
        return coverage;
    }

    public CoverageAggregator adjustedDegradedCoverage(int searchableCopies, TimeoutHandler timeoutHandler) {
        int askedAndFailed = this.askedNodes + this.failedNodes;
        if (askedAndFailed == this.answeredNodesParticipated) {
            return this;
        }
        int notAnswered = askedAndFailed - this.answeredNodesParticipated;
        if (timeoutHandler.reason() == 4 && this.answeredNodesParticipated > 0) {
            CoverageAggregator clone = new CoverageAggregator(this);
            clone.answeredActiveDocs += (long)notAnswered * this.answeredActiveDocs / (long)this.answeredNodesParticipated;
            clone.answeredTargetActiveDocs += (long)notAnswered * this.answeredTargetActiveDocs / (long)this.answeredNodesParticipated;
            return clone;
        }
        if (askedAndFailed > this.answeredNodesParticipated) {
            int missingNodes = notAnswered - (searchableCopies - 1);
            if (this.answeredNodesParticipated > 0) {
                CoverageAggregator clone = new CoverageAggregator(this);
                clone.answeredActiveDocs += (long)missingNodes * this.answeredActiveDocs / (long)this.answeredNodesParticipated;
                clone.answeredTargetActiveDocs += (long)missingNodes * this.answeredTargetActiveDocs / (long)this.answeredNodesParticipated;
                clone.timedOut = true;
                return clone;
            }
        }
        return this;
    }
}

