/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.prelude.hitfield.XmlRenderer;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import com.yahoo.text.Utf8;
import com.yahoo.text.XML;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONString
implements Inspectable {
    private com.yahoo.data.access.Inspector value;
    private String content;
    private boolean didInitContent = false;
    private Object parsedJSON;
    private boolean didInitJSON = false;

    public JSONString(com.yahoo.data.access.Inspector value) {
        if (value == null) {
            throw new IllegalArgumentException("JSONString does not accept null value.");
        }
        this.value = value;
    }

    public com.yahoo.data.access.Inspector inspect() {
        if (this.value == null) {
            JsonDecoder decoder = new JsonDecoder();
            Slime slime = decoder.decode(new Slime(), Utf8.toBytes((String)this.content));
            this.value = slime.get().field("error_message").valid() && slime.get().field("partial_result").valid() && slime.get().field("offending_input").valid() ? new Value.StringValue(this.content) : (slime.get().type() == Type.OBJECT || slime.get().type() == Type.ARRAY ? new SlimeAdapter((Inspector)slime.get()) : new Value.StringValue(this.content));
        }
        return this.value;
    }

    private void initContent() {
        if (this.didInitContent) {
            return;
        }
        this.didInitContent = true;
        this.content = this.value.type() == com.yahoo.data.access.Type.EMPTY ? "" : (this.value.type() == com.yahoo.data.access.Type.STRING ? this.value.asString() : this.value.toString());
    }

    public JSONString(String content) {
        if (content == null) {
            throw new IllegalArgumentException("JSONString does not accept null content.");
        }
        this.content = content;
        this.didInitContent = true;
    }

    public String toString() {
        if (this.value != null) {
            return this.renderFromInspector();
        }
        this.initContent();
        if (this.content.length() == 0) {
            return this.content;
        }
        this.initJSON();
        if (this.parsedJSON == null) {
            return this.content;
        }
        if (this.parsedJSON.getClass() == JSONArray.class) {
            return JSONString.render((JSONArray)this.parsedJSON);
        }
        return this.content;
    }

    public boolean fillWeightedSetItem(WeightedSetItem item) {
        this.initContent();
        this.initJSON();
        try {
            if (this.parsedJSON instanceof JSONArray) {
                JSONArray seq = (JSONArray)this.parsedJSON;
                for (int i = 0; i < seq.length(); ++i) {
                    JSONArray wsi = seq.getJSONArray(i);
                    String name = (String)wsi.get(0);
                    Number weight = (Number)wsi.get(1);
                    item.addToken(name, weight.intValue());
                }
                return true;
            }
        }
        catch (ClassCastException | JSONException throwable) {
            // empty catch block
        }
        return false;
    }

    private void initJSON() {
        this.initContent();
        if (this.didInitJSON) {
            return;
        }
        this.didInitJSON = true;
        if (this.content.charAt(0) == '[') {
            try {
                this.parsedJSON = new JSONArray(this.content);
            }
            catch (JSONException e) {
                return;
            }
        }
        try {
            this.parsedJSON = new JSONObject(this.content);
        }
        catch (JSONException e) {
            return;
        }
    }

    private static String render(JSONArray sequence) {
        return FieldRenderer.renderMapOrArray(new StringBuilder(), sequence, 2).toString();
    }

    public String getContent() {
        this.initContent();
        return this.content;
    }

    public String renderFromInspector() {
        return XmlRenderer.render(new StringBuilder(), this.value).toString();
    }

    private static abstract class FieldRenderer {
        private FieldRenderer() {
        }

        protected static void indent(StringBuilder renderTarget, int nestingLevel) {
            for (int i = 0; i < nestingLevel; ++i) {
                renderTarget.append("  ");
            }
        }

        public static StringBuilder renderMapOrArray(StringBuilder renderTarget, JSONArray sequence, int nestingLevel) {
            if (sequence.length() == 0) {
                return renderTarget;
            }
            if (MapFieldRenderer.isMap(sequence)) {
                MapFieldRenderer.renderMap(renderTarget, sequence, nestingLevel + 1);
            } else {
                ArrayFieldRenderer.renderArray(renderTarget, sequence, nestingLevel + 1);
            }
            FieldRenderer.indent(renderTarget, nestingLevel);
            return renderTarget;
        }

        public abstract void render(StringBuilder var1, Object var2, int var3);

        public abstract void closeTag(StringBuilder var1, int var2, String var3);

        static Object get(String field, JSONObject source) {
            try {
                return source.get(field);
            }
            catch (JSONException e) {
                return null;
            }
        }

        protected static void renderValue(Object value, StringBuilder renderTarget, int nestingLevel) {
            if (value.getClass() == JSONArray.class) {
                FieldRenderer.renderMapOrArray(renderTarget, (JSONArray)value, nestingLevel);
            } else if (value instanceof Number) {
                NumberFieldRenderer.renderNumber(renderTarget, (Number)value);
            } else if (value.getClass() == String.class) {
                StringFieldRenderer.renderString(renderTarget, (String)value);
            } else {
                renderTarget.append(value);
            }
        }
    }

    private static class ArrayFieldRenderer
    extends FieldRenderer {
        protected static FieldRenderer structureFieldRenderer = new StructureFieldRenderer();
        protected static FieldRenderer stringFieldRenderer = new StringFieldRenderer();
        protected static FieldRenderer numberFieldRenderer = new NumberFieldRenderer();

        private ArrayFieldRenderer() {
        }

        @Override
        public void render(StringBuilder renderTarget, Object value, int nestingLevel) {
            ArrayFieldRenderer.renderArray(renderTarget, (JSONArray)value, nestingLevel);
        }

        public static void renderArray(StringBuilder renderTarget, JSONArray seq, int nestingLevel) {
            FieldRenderer renderer;
            Object sniffer;
            int limit = seq.length();
            if (limit == 0) {
                return;
            }
            try {
                sniffer = seq.get(0);
            }
            catch (JSONException e) {
                return;
            }
            if (sniffer.getClass() == JSONArray.class) {
                ArrayFieldRenderer.renderWeightedSet(renderTarget, seq, nestingLevel);
                return;
            }
            if (sniffer.getClass() == JSONObject.class) {
                renderer = structureFieldRenderer;
            } else if (sniffer instanceof Number) {
                renderer = numberFieldRenderer;
            } else if (sniffer.getClass() == String.class) {
                renderer = stringFieldRenderer;
            } else {
                return;
            }
            renderTarget.append('\n');
            for (int i = 0; i < limit; ++i) {
                Object value;
                try {
                    value = seq.get(i);
                }
                catch (JSONException e) {
                    continue;
                }
                ArrayFieldRenderer.indent(renderTarget, nestingLevel);
                renderTarget.append("<item>");
                renderer.render(renderTarget, value, nestingLevel + 1);
                renderer.closeTag(renderTarget, nestingLevel, "</item>\n");
            }
        }

        protected static void renderWeightedSet(StringBuilder renderTarget, JSONArray seq, int nestingLevel) {
            FieldRenderer renderer;
            Object sniffer;
            int limit = seq.length();
            try {
                JSONArray first = seq.getJSONArray(0);
                sniffer = first.get(0);
            }
            catch (JSONException e) {
                return;
            }
            if (sniffer.getClass() == JSONObject.class) {
                renderer = structureFieldRenderer;
            } else if (sniffer instanceof Number) {
                renderer = numberFieldRenderer;
            } else if (sniffer.getClass() == String.class) {
                renderer = stringFieldRenderer;
            } else {
                return;
            }
            renderTarget.append('\n');
            for (int i = 0; i < limit; ++i) {
                Number weight;
                Object name;
                try {
                    JSONArray arrayValue = seq.getJSONArray(i);
                    name = arrayValue.get(0);
                    weight = (Number)arrayValue.get(1);
                }
                catch (JSONException e) {
                    continue;
                }
                ArrayFieldRenderer.indent(renderTarget, nestingLevel);
                renderTarget.append("<item weight=\"").append(weight).append("\">");
                renderer.render(renderTarget, name, nestingLevel + 1);
                renderer.closeTag(renderTarget, nestingLevel, "</item>\n");
            }
        }

        @Override
        public void closeTag(StringBuilder renderTarget, int nestingLevel, String closing) {
            ArrayFieldRenderer.indent(renderTarget, nestingLevel);
            renderTarget.append(closing);
        }
    }

    private static class StringFieldRenderer
    extends FieldRenderer {
        private StringFieldRenderer() {
        }

        @Override
        public void render(StringBuilder renderTarget, Object value, int nestingLevel) {
            StringFieldRenderer.renderString(renderTarget, (String)value);
        }

        public static void renderString(StringBuilder renderTarget, String value) {
            renderTarget.append(XML.xmlEscape((String)value, (boolean)false));
        }

        @Override
        public void closeTag(StringBuilder renderTarget, int nestingLevel, String closing) {
            renderTarget.append(closing);
        }
    }

    private static class NumberFieldRenderer
    extends FieldRenderer {
        private NumberFieldRenderer() {
        }

        @Override
        public void render(StringBuilder renderTarget, Object value, int nestingLevel) {
            NumberFieldRenderer.renderNumber(renderTarget, (Number)value);
        }

        public static void renderNumber(StringBuilder renderTarget, Number number) {
            renderTarget.append(number.toString());
        }

        @Override
        public void closeTag(StringBuilder renderTarget, int nestingLevel, String closing) {
            renderTarget.append(closing);
        }
    }

    private static class StructureFieldRenderer
    extends FieldRenderer {
        private StructureFieldRenderer() {
        }

        @Override
        public void render(StringBuilder renderTarget, Object value, int nestingLevel) {
            StructureFieldRenderer.renderStructure(renderTarget, (JSONObject)value, nestingLevel);
        }

        public static void renderStructure(StringBuilder renderTarget, JSONObject structure, int nestingLevel) {
            Iterator i = structure.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = StructureFieldRenderer.get(key, structure);
                if (value == null) continue;
                renderTarget.append('\n');
                StructureFieldRenderer.indent(renderTarget, nestingLevel);
                renderTarget.append("<struct-field name=\"").append(key).append("\">");
                StructureFieldRenderer.renderValue(value, renderTarget, nestingLevel);
                renderTarget.append("</struct-field>");
            }
            renderTarget.append('\n');
        }

        @Override
        public void closeTag(StringBuilder renderTarget, int nestingLevel, String closing) {
            StructureFieldRenderer.indent(renderTarget, nestingLevel);
            renderTarget.append(closing);
        }
    }

    private static class MapFieldRenderer
    extends FieldRenderer {
        private MapFieldRenderer() {
        }

        @Override
        public void render(StringBuilder renderTarget, Object value, int nestingLevel) {
            MapFieldRenderer.renderMap(renderTarget, (JSONArray)value, nestingLevel);
        }

        private static boolean isMap(JSONArray array) {
            Object firstObject = MapFieldRenderer.get(0, array);
            if (!(firstObject instanceof JSONObject)) {
                return false;
            }
            JSONObject first = (JSONObject)firstObject;
            if (first.length() != 2) {
                return false;
            }
            if (!first.has("key")) {
                return false;
            }
            return first.has("value");
        }

        public static void renderMap(StringBuilder renderTarget, JSONArray sequence, int nestingLevel) {
            int limit = sequence.length();
            if (limit == 0) {
                return;
            }
            for (int i = 0; i < limit; ++i) {
                MapFieldRenderer.renderMapItem(renderTarget, (JSONObject)MapFieldRenderer.get(i, sequence), nestingLevel);
            }
            renderTarget.append("\n");
        }

        public static void renderMapItem(StringBuilder renderTarget, JSONObject object, int nestingLevel) {
            renderTarget.append('\n');
            MapFieldRenderer.indent(renderTarget, nestingLevel);
            renderTarget.append("<item><key>");
            MapFieldRenderer.renderValue(MapFieldRenderer.get("key", object), renderTarget, nestingLevel);
            renderTarget.append("</key><value>");
            MapFieldRenderer.renderValue(MapFieldRenderer.get("value", object), renderTarget, nestingLevel);
            renderTarget.append("</value></item>");
        }

        private static Object get(int index, JSONArray source) {
            try {
                return source.get(index);
            }
            catch (JSONException e) {
                return null;
            }
        }

        @Override
        public void closeTag(StringBuilder renderTarget, int nestingLevel, String closing) {
            MapFieldRenderer.indent(renderTarget, nestingLevel);
            renderTarget.append(closing);
        }
    }
}

