/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.yahoo.prelude.query.NumericInItem;
import com.yahoo.prelude.query.StringInItem;
import com.yahoo.prelude.query.WeightedSetItem;
import java.util.Arrays;

class ParameterListParser {
    ParameterListParser() {
    }

    public static void addItemsFromString(String string, WeightedSetItem out) {
        ParsableString s = new ParsableString(string);
        switch (s.peek()) {
            case '[': {
                ParameterListParser.addArrayItems(s, out);
                break;
            }
            case '{': {
                ParameterListParser.addMapItems(s, out);
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected a string starting by '[' or '{', but was '" + s.peek() + "'");
            }
        }
    }

    private static void addArrayItems(ParsableString s, WeightedSetItem out) {
        s.pass('[');
        while (s.peek() != ']') {
            s.pass('[');
            long key = s.longTo(s.position(','));
            s.pass(',');
            int value = s.intTo(s.position(']'));
            s.pass(']');
            out.addToken(key, value);
            s.passOptional(',');
            if (!s.atEnd()) continue;
            throw new IllegalArgumentException("Expected an array ending by ']'");
        }
        s.pass(']');
    }

    private static void addMapItems(ParsableString s, WeightedSetItem out) {
        s.pass('{');
        while (s.peek() != '}') {
            String key;
            if (s.passOptional('\'')) {
                key = s.stringTo(s.position('\''));
                s.pass('\'');
            } else if (s.passOptional('\"')) {
                key = s.stringTo(s.position('\"'));
                s.pass('\"');
            } else {
                key = s.stringTo(s.position(':')).trim();
            }
            s.pass(':');
            int value = s.intTo(s.position(',', '}'));
            out.addToken(key, value);
            s.passOptional(',');
            if (!s.atEnd()) continue;
            throw new IllegalArgumentException("Expected a map ending by '}'");
        }
        s.pass('}');
    }

    public static void addStringTokensFromString(String string, StringInItem out) {
        if (string == null) {
            return;
        }
        ParsableString s = new ParsableString(string);
        while (!s.atEnd()) {
            String token;
            if (s.passOptional('\'')) {
                token = s.stringTo(s.position('\''));
                s.pass('\'');
            } else if (s.passOptional('\"')) {
                token = s.stringTo(s.position('\"'));
                s.pass('\"');
            } else {
                token = s.stringTo(s.positionOrEnd(',')).trim();
            }
            out.addToken(token);
            s.passOptional(',');
        }
    }

    public static void addNumericTokensFromString(String string, NumericInItem out) {
        if (string == null) {
            return;
        }
        ParsableString s = new ParsableString(string);
        while (!s.atEnd()) {
            long token = s.longTo(s.positionOrEnd(','));
            out.addToken(token);
            s.passOptional(',');
        }
    }

    private static class ParsableString {
        int position = 0;
        String s;

        ParsableString(String s) {
            this.s = s;
        }

        char peek() {
            int localPosition = this.position;
            while (localPosition < this.s.length()) {
                char nextChar;
                if (Character.isSpaceChar(nextChar = this.s.charAt(localPosition++))) continue;
                return nextChar;
            }
            return '\u0000';
        }

        void pass(char character) {
            while (this.position < this.s.length()) {
                char nextChar;
                if (Character.isSpaceChar(nextChar = this.s.charAt(this.position++))) continue;
                if (nextChar == character) {
                    return;
                }
                throw new IllegalArgumentException("Expected '" + character + "' at position " + (this.position - 1) + " but got '" + nextChar + "'");
            }
            throw new IllegalArgumentException("Expected '" + character + "' at position " + (this.position - 1) + " but reached the end");
        }

        boolean passOptional(char character) {
            int localPosition = this.position;
            while (localPosition < this.s.length()) {
                char nextChar;
                if (Character.isSpaceChar(nextChar = this.s.charAt(localPosition++))) continue;
                if (nextChar == character) {
                    this.position = localPosition;
                    return true;
                }
                return false;
            }
            return false;
        }

        int position(char ... characters) {
            for (int localPosition = this.position; localPosition < this.s.length(); ++localPosition) {
                char nextChar = this.s.charAt(localPosition);
                for (char character : characters) {
                    if (nextChar != character) continue;
                    return localPosition;
                }
            }
            throw new IllegalArgumentException("Expected one of " + Arrays.toString(characters) + " after " + this.position);
        }

        int positionOrEnd(char ... characters) {
            int localPosition;
            for (localPosition = this.position; localPosition < this.s.length(); ++localPosition) {
                char nextChar = this.s.charAt(localPosition);
                for (char character : characters) {
                    if (nextChar != character) continue;
                    return localPosition;
                }
            }
            return localPosition;
        }

        boolean atEnd() {
            return this.position >= this.s.length();
        }

        String stringTo(int end) {
            try {
                String value = this.s.substring(this.position, end);
                this.position = end;
                return value;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(end + " is larger than the size of the string,  " + this.s.length());
            }
        }

        int intTo(int end) {
            int start = this.position;
            String value = this.stringTo(end);
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected an integer between positions " + start + " and " + end + ", but got " + value);
            }
        }

        long longTo(int end) {
            int start = this.position;
            String value = this.stringTo(end);
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected an integer between positions " + start + " and " + end + ", but got " + value);
            }
        }
    }
}

