/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.collections.ListenableArrayList;
import com.yahoo.component.provider.ListenableFreezableClass;
import com.yahoo.processing.Request;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.DefaultIncomingData;
import com.yahoo.processing.response.IncomingData;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class EventStream
extends Hit
implements DataList<Data> {
    private final ListenableArrayList<Data> data = new ListenableArrayList(16);
    private final IncomingData<Data> incomingData;
    private final AtomicInteger eventCount = new AtomicInteger(0);
    public static final String EVENT_TYPE_TOKEN = "token";
    public static final String DEFAULT_EVENT_TYPE = "token";

    public EventStream() {
        this.incomingData = new DefaultIncomingData((DataList)this);
    }

    public void add(String data) {
        this.incoming().add((Data)new Event(this.eventCount.incrementAndGet(), data, "token"));
    }

    public void add(String data, String type) {
        this.incoming().add((Data)new Event(this.eventCount.incrementAndGet(), data, type));
    }

    public void error(String source, ErrorMessage message) {
        this.incoming().add((Data)new ErrorEvent(this.eventCount.incrementAndGet(), source, message));
    }

    public void markComplete() {
        this.incoming().markComplete();
    }

    public Data add(Data event) {
        this.data.add((Object)event);
        return event;
    }

    public Data get(int index) {
        return (Data)this.data.get(index);
    }

    public List<Data> asList() {
        return this.data;
    }

    public IncomingData<Data> incoming() {
        return this.incomingData;
    }

    public CompletableFuture<DataList<Data>> completeFuture() {
        return this.incomingData.completedFuture();
    }

    public void addDataListener(Runnable runnable) {
        this.data.addListener(runnable);
    }

    @Override
    public void close() {
    }

    public static class Event
    extends ListenableFreezableClass
    implements Data {
        private final int eventNumber;
        private final String data;
        private final String type;

        public Event(int eventNumber, String data, String type) {
            this.eventNumber = eventNumber;
            this.data = data;
            this.type = type;
        }

        public String toString() {
            return this.data;
        }

        public String type() {
            return this.type;
        }

        public Request request() {
            return null;
        }

        public Hit asHit() {
            Hit hit = new Hit(String.valueOf(this.eventNumber));
            hit.setField(this.type, this.data);
            return hit;
        }
    }

    public static class ErrorEvent
    extends Event {
        private final String source;
        private final ErrorMessage message;

        public ErrorEvent(int eventNumber, String source, ErrorMessage message) {
            super(eventNumber, message.getMessage(), "error");
            this.source = source;
            this.message = message;
        }

        public String source() {
            return this.source;
        }

        public int code() {
            return this.message.getCode();
        }

        public String message() {
            return this.message.getMessage();
        }

        @Override
        public Hit asHit() {
            Hit hit = super.asHit();
            hit.setField("source", this.source);
            hit.setField("code", this.message.getCode());
            return hit;
        }
    }
}

