/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.Result;
import com.yahoo.search.ranking.HitRescorer;
import com.yahoo.search.ranking.RangeAdjuster;
import com.yahoo.search.ranking.WrappedHit;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

class ResultReranker {
    private static final Logger logger = Logger.getLogger(ResultReranker.class.getName());
    private final HitRescorer hitRescorer;
    private final int rerankCount;
    private final List<WrappedHit> hitsToRescore = new ArrayList<WrappedHit>();
    private final RangeAdjuster ranges = new RangeAdjuster();

    ResultReranker(HitRescorer hitRescorer, int rerankCount) {
        this.hitRescorer = hitRescorer;
        this.rerankCount = rerankCount;
    }

    void rerankHits(Result result) {
        this.gatherHits(result);
        this.runPreProcessing();
        this.hitRescorer.runNormalizers();
        this.runProcessing();
        this.runPostProcessing();
        result.hits().sort();
    }

    private void gatherHits(Result result) {
        Iterator<Hit> iterator = result.hits().deepIterator();
        while (iterator.hasNext()) {
            WrappedHit wrapped;
            Hit hit = iterator.next();
            if (hit.isMeta() || hit instanceof HitGroup || (wrapped = WrappedHit.from(hit)) == null) continue;
            this.hitsToRescore.add(wrapped);
        }
    }

    private void runPreProcessing() {
        this.hitsToRescore.sort(Comparator.naturalOrder());
        int count = 0;
        for (WrappedHit hit : this.hitsToRescore) {
            if (count == this.rerankCount) break;
            this.hitRescorer.preprocess(hit);
            ++count;
        }
    }

    private void runProcessing() {
        Iterator<WrappedHit> iterator = this.hitsToRescore.iterator();
        for (int count = 0; count < this.rerankCount && iterator.hasNext(); ++count) {
            WrappedHit wrapped = iterator.next();
            double oldScore = wrapped.getScore();
            double newScore = this.hitRescorer.rescoreHit(wrapped);
            this.ranges.withInitialScore(oldScore);
            this.ranges.withFinalScore(newScore);
            iterator.remove();
        }
    }

    private void runPostProcessing() {
        if (this.ranges.rescaleNeeded() && !this.hitsToRescore.isEmpty()) {
            double scale = this.ranges.scale();
            double bias = this.ranges.bias();
            for (WrappedHit wrapped : this.hitsToRescore) {
                double oldScore = wrapped.getScore();
                wrapped.setScore(oldScore * scale + bias);
            }
        }
    }
}

