/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

abstract class Normalizer {
    protected double[] data;
    protected int size = 0;

    private static int initialCapacity(int hint) {
        for (int capacity = 64; capacity < 4096; capacity *= 2) {
            if (hint > capacity) continue;
            return capacity;
        }
        return 4096;
    }

    Normalizer(int sizeHint) {
        this.data = new double[Normalizer.initialCapacity(sizeHint)];
    }

    int addInput(double value) {
        if (this.size == this.data.length) {
            int newSize = this.size * 2;
            double[] tmp = new double[newSize];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
        this.data[this.size] = value;
        return this.size++;
    }

    double getOutput(int index) {
        return this.data[index];
    }

    abstract void normalize();

    abstract String normalizing();
}

