/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.text.Lowercase;

public class PrimitiveFieldType
extends FieldType {
    private final Class primitiveClass;

    PrimitiveFieldType(Class primitiveClass) {
        this.primitiveClass = primitiveClass;
    }

    @Override
    public Class getValueClass() {
        return this.primitiveClass;
    }

    @Override
    public String stringValue() {
        return Lowercase.toLowerCase((String)this.primitiveClass.getSimpleName());
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return Lowercase.toLowerCase((String)this.primitiveClass.getSimpleName());
    }

    @Override
    public Object convertFrom(Object object, ConversionContext context) {
        return this.convertFrom(object, (QueryProfileRegistry)null);
    }

    @Override
    public Object convertFrom(Object object, QueryProfileRegistry registry) {
        if (this.primitiveClass == object.getClass()) {
            return object;
        }
        if (this.primitiveClass == String.class && object.getClass() == SubstituteString.class) {
            return object;
        }
        if (object.getClass() == String.class) {
            return this.convertFromString((String)object);
        }
        if (object instanceof Number) {
            return this.convertFromNumber((Number)object);
        }
        return null;
    }

    private Object convertFromString(String string) {
        try {
            if (this.primitiveClass == Integer.class) {
                return Integer.valueOf(string);
            }
            if (this.primitiveClass == Double.class) {
                return Double.valueOf(string);
            }
            if (this.primitiveClass == Float.class) {
                return Float.valueOf(string);
            }
            if (this.primitiveClass == Long.class) {
                return Long.valueOf(string);
            }
            if (this.primitiveClass == Boolean.class) {
                return Boolean.valueOf(string);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        throw new RuntimeException("Programming error");
    }

    private Object convertFromNumber(Number number) {
        if (this.primitiveClass == Integer.class) {
            return number.intValue();
        }
        if (this.primitiveClass == Double.class) {
            return number.doubleValue();
        }
        if (this.primitiveClass == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (this.primitiveClass == Long.class) {
            return number.longValue();
        }
        if (this.primitiveClass == String.class) {
            return String.valueOf(number);
        }
        throw new RuntimeException("Programming error: Input type is " + String.valueOf(number.getClass()) + " primitiveClass is " + String.valueOf(this.primitiveClass));
    }

    public int hashCode() {
        return this.primitiveClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveFieldType)) {
            return false;
        }
        PrimitiveFieldType other = (PrimitiveFieldType)o;
        return other.primitiveClass.equals(this.primitiveClass);
    }
}

