/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.grouping.request.AddFunction;
import com.yahoo.search.grouping.request.AggregatorNode;
import com.yahoo.search.grouping.request.AndFunction;
import com.yahoo.search.grouping.request.ArrayAtLookup;
import com.yahoo.search.grouping.request.AttributeFunction;
import com.yahoo.search.grouping.request.AttributeMapLookupValue;
import com.yahoo.search.grouping.request.AttributeValue;
import com.yahoo.search.grouping.request.AvgAggregator;
import com.yahoo.search.grouping.request.BucketValue;
import com.yahoo.search.grouping.request.CatFunction;
import com.yahoo.search.grouping.request.ConstantValue;
import com.yahoo.search.grouping.request.CountAggregator;
import com.yahoo.search.grouping.request.DateFunction;
import com.yahoo.search.grouping.request.DayOfMonthFunction;
import com.yahoo.search.grouping.request.DayOfWeekFunction;
import com.yahoo.search.grouping.request.DayOfYearFunction;
import com.yahoo.search.grouping.request.DebugWaitFunction;
import com.yahoo.search.grouping.request.DivFunction;
import com.yahoo.search.grouping.request.DocIdNsSpecificValue;
import com.yahoo.search.grouping.request.DoubleValue;
import com.yahoo.search.grouping.request.FilterExpression;
import com.yahoo.search.grouping.request.FixedWidthFunction;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.request.HourOfDayFunction;
import com.yahoo.search.grouping.request.InfiniteValue;
import com.yahoo.search.grouping.request.InterpolatedLookup;
import com.yahoo.search.grouping.request.LongValue;
import com.yahoo.search.grouping.request.MathACosFunction;
import com.yahoo.search.grouping.request.MathACosHFunction;
import com.yahoo.search.grouping.request.MathASinFunction;
import com.yahoo.search.grouping.request.MathASinHFunction;
import com.yahoo.search.grouping.request.MathATanFunction;
import com.yahoo.search.grouping.request.MathATanHFunction;
import com.yahoo.search.grouping.request.MathCbrtFunction;
import com.yahoo.search.grouping.request.MathCosFunction;
import com.yahoo.search.grouping.request.MathCosHFunction;
import com.yahoo.search.grouping.request.MathExpFunction;
import com.yahoo.search.grouping.request.MathFloorFunction;
import com.yahoo.search.grouping.request.MathHypotFunction;
import com.yahoo.search.grouping.request.MathLog10Function;
import com.yahoo.search.grouping.request.MathLog1pFunction;
import com.yahoo.search.grouping.request.MathLogFunction;
import com.yahoo.search.grouping.request.MathPowFunction;
import com.yahoo.search.grouping.request.MathSinFunction;
import com.yahoo.search.grouping.request.MathSinHFunction;
import com.yahoo.search.grouping.request.MathSqrtFunction;
import com.yahoo.search.grouping.request.MathTanFunction;
import com.yahoo.search.grouping.request.MathTanHFunction;
import com.yahoo.search.grouping.request.MaxAggregator;
import com.yahoo.search.grouping.request.MaxFunction;
import com.yahoo.search.grouping.request.Md5Function;
import com.yahoo.search.grouping.request.MinAggregator;
import com.yahoo.search.grouping.request.MinFunction;
import com.yahoo.search.grouping.request.MinuteOfHourFunction;
import com.yahoo.search.grouping.request.ModFunction;
import com.yahoo.search.grouping.request.MonthOfYearFunction;
import com.yahoo.search.grouping.request.MulFunction;
import com.yahoo.search.grouping.request.NegFunction;
import com.yahoo.search.grouping.request.NormalizeSubjectFunction;
import com.yahoo.search.grouping.request.NowFunction;
import com.yahoo.search.grouping.request.OrFunction;
import com.yahoo.search.grouping.request.PredefinedFunction;
import com.yahoo.search.grouping.request.RawBuffer;
import com.yahoo.search.grouping.request.RawValue;
import com.yahoo.search.grouping.request.RegexPredicate;
import com.yahoo.search.grouping.request.RelevanceValue;
import com.yahoo.search.grouping.request.ReverseFunction;
import com.yahoo.search.grouping.request.SecondOfMinuteFunction;
import com.yahoo.search.grouping.request.SizeFunction;
import com.yahoo.search.grouping.request.SortFunction;
import com.yahoo.search.grouping.request.StandardDeviationAggregator;
import com.yahoo.search.grouping.request.StrCatFunction;
import com.yahoo.search.grouping.request.StrLenFunction;
import com.yahoo.search.grouping.request.StringValue;
import com.yahoo.search.grouping.request.SubFunction;
import com.yahoo.search.grouping.request.SumAggregator;
import com.yahoo.search.grouping.request.SummaryValue;
import com.yahoo.search.grouping.request.ToDoubleFunction;
import com.yahoo.search.grouping.request.ToLongFunction;
import com.yahoo.search.grouping.request.ToRawFunction;
import com.yahoo.search.grouping.request.ToStringFunction;
import com.yahoo.search.grouping.request.UcaFunction;
import com.yahoo.search.grouping.request.XorAggregator;
import com.yahoo.search.grouping.request.XorBitFunction;
import com.yahoo.search.grouping.request.XorFunction;
import com.yahoo.search.grouping.request.YearFunction;
import com.yahoo.search.grouping.request.ZCurveXFunction;
import com.yahoo.search.grouping.request.ZCurveYFunction;
import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.AverageAggregationResult;
import com.yahoo.searchlib.aggregation.CountAggregationResult;
import com.yahoo.searchlib.aggregation.ExpressionCountAggregationResult;
import com.yahoo.searchlib.aggregation.HitsAggregationResult;
import com.yahoo.searchlib.aggregation.MaxAggregationResult;
import com.yahoo.searchlib.aggregation.MinAggregationResult;
import com.yahoo.searchlib.aggregation.StandardDeviationAggregationResult;
import com.yahoo.searchlib.aggregation.SumAggregationResult;
import com.yahoo.searchlib.aggregation.XorAggregationResult;
import com.yahoo.searchlib.expression.AddFunctionNode;
import com.yahoo.searchlib.expression.AggregationRefNode;
import com.yahoo.searchlib.expression.AndFunctionNode;
import com.yahoo.searchlib.expression.ArrayAtLookupNode;
import com.yahoo.searchlib.expression.AttributeMapLookupNode;
import com.yahoo.searchlib.expression.AttributeNode;
import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.CatFunctionNode;
import com.yahoo.searchlib.expression.ConstantNode;
import com.yahoo.searchlib.expression.DebugWaitFunctionNode;
import com.yahoo.searchlib.expression.DivideFunctionNode;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.searchlib.expression.FixedWidthBucketFunctionNode;
import com.yahoo.searchlib.expression.FloatBucketResultNode;
import com.yahoo.searchlib.expression.FloatBucketResultNodeVector;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.GetDocIdNamespaceSpecificFunctionNode;
import com.yahoo.searchlib.expression.IntegerBucketResultNode;
import com.yahoo.searchlib.expression.IntegerBucketResultNodeVector;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.InterpolatedLookupNode;
import com.yahoo.searchlib.expression.MD5BitFunctionNode;
import com.yahoo.searchlib.expression.MathFunctionNode;
import com.yahoo.searchlib.expression.MaxFunctionNode;
import com.yahoo.searchlib.expression.MinFunctionNode;
import com.yahoo.searchlib.expression.ModuloFunctionNode;
import com.yahoo.searchlib.expression.MultiArgFunctionNode;
import com.yahoo.searchlib.expression.MultiplyFunctionNode;
import com.yahoo.searchlib.expression.NegateFunctionNode;
import com.yahoo.searchlib.expression.NormalizeSubjectFunctionNode;
import com.yahoo.searchlib.expression.NumElemFunctionNode;
import com.yahoo.searchlib.expression.NumericResultNode;
import com.yahoo.searchlib.expression.OrFunctionNode;
import com.yahoo.searchlib.expression.RangeBucketPreDefFunctionNode;
import com.yahoo.searchlib.expression.RawBucketResultNode;
import com.yahoo.searchlib.expression.RawBucketResultNodeVector;
import com.yahoo.searchlib.expression.RawResultNode;
import com.yahoo.searchlib.expression.RegexPredicateNode;
import com.yahoo.searchlib.expression.RelevanceNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.searchlib.expression.ReverseFunctionNode;
import com.yahoo.searchlib.expression.SortFunctionNode;
import com.yahoo.searchlib.expression.StrCatFunctionNode;
import com.yahoo.searchlib.expression.StrLenFunctionNode;
import com.yahoo.searchlib.expression.StringBucketResultNode;
import com.yahoo.searchlib.expression.StringBucketResultNodeVector;
import com.yahoo.searchlib.expression.StringResultNode;
import com.yahoo.searchlib.expression.TimeStampFunctionNode;
import com.yahoo.searchlib.expression.ToFloatFunctionNode;
import com.yahoo.searchlib.expression.ToIntFunctionNode;
import com.yahoo.searchlib.expression.ToRawFunctionNode;
import com.yahoo.searchlib.expression.ToStringFunctionNode;
import com.yahoo.searchlib.expression.UcaFunctionNode;
import com.yahoo.searchlib.expression.XorBitFunctionNode;
import com.yahoo.searchlib.expression.XorFunctionNode;
import com.yahoo.searchlib.expression.ZCurveFunctionNode;

class ExpressionConverter {
    public static final String DEFAULT_SUMMARY_NAME = "";
    public static final int DEFAULT_TIME_OFFSET = 0;
    private String defaultSummaryName = "";
    private int timeOffset = 0;

    ExpressionConverter() {
    }

    public ExpressionConverter setDefaultSummaryName(String summaryName) {
        this.defaultSummaryName = summaryName;
        return this;
    }

    public ExpressionConverter setTimeOffset(int millis) {
        this.timeOffset = millis / 1000;
        return this;
    }

    public AggregationResult toAggregationResult(GroupingExpression exp) {
        int level = exp.getLevel();
        if (level > 1) {
            if (exp instanceof CountAggregator) {
                return new ExpressionCountAggregationResult();
            }
            throw new IllegalInputException("Can not aggregate on " + GroupingOperation.getLevelDesc(level) + ".");
        }
        if (exp instanceof AvgAggregator) {
            AvgAggregator avgAggregator = (AvgAggregator)exp;
            return new AverageAggregationResult().setExpression(this.toExpressionNode(avgAggregator.getExpression()));
        }
        if (exp instanceof CountAggregator) {
            return new CountAggregationResult().setExpression((ExpressionNode)new ConstantNode((ResultNode)new IntegerResultNode(0L)));
        }
        if (exp instanceof MaxAggregator) {
            MaxAggregator aggregator = (MaxAggregator)exp;
            return new MaxAggregationResult().setExpression(this.toExpressionNode(aggregator.getExpression()));
        }
        if (exp instanceof MinAggregator) {
            MinAggregator aggregator = (MinAggregator)exp;
            return new MinAggregationResult().setExpression(this.toExpressionNode(aggregator.getExpression()));
        }
        if (exp instanceof SumAggregator) {
            SumAggregator aggregator = (SumAggregator)exp;
            return new SumAggregationResult().setExpression(this.toExpressionNode(aggregator.getExpression()));
        }
        if (exp instanceof SummaryValue) {
            SummaryValue summaryValue = (SummaryValue)exp;
            String summaryName = summaryValue.getSummaryName();
            return new HitsAggregationResult().setSummaryClass(summaryName != null ? summaryName : this.defaultSummaryName).setExpression((ExpressionNode)new ConstantNode((ResultNode)new IntegerResultNode(0L)));
        }
        if (exp instanceof StandardDeviationAggregator) {
            StandardDeviationAggregator aggregator = (StandardDeviationAggregator)exp;
            return new StandardDeviationAggregationResult().setExpression(this.toExpressionNode(aggregator.getExpression()));
        }
        if (exp instanceof XorAggregator) {
            XorAggregator aggregator = (XorAggregator)exp;
            return new XorAggregationResult().setExpression(this.toExpressionNode(aggregator.getExpression()));
        }
        throw new IllegalInputException("Can not convert '" + String.valueOf(exp) + "' to an aggregator.");
    }

    public FilterExpressionNode toFilterExpressionNode(FilterExpression expression) {
        if (expression instanceof RegexPredicate) {
            RegexPredicate rp = (RegexPredicate)expression;
            return new RegexPredicateNode(rp.getPattern(), this.toExpressionNode(rp.getExpression()));
        }
        throw new IllegalInputException("Can not convert '%s' to a filter expression.".formatted(expression.getClass().getSimpleName()));
    }

    public ExpressionNode toExpressionNode(GroupingExpression exp) {
        if (exp instanceof AddFunction) {
            AddFunction addFunction = (AddFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new AddFunctionNode(), addFunction);
        }
        if (exp instanceof AggregatorNode) {
            return new AggregationRefNode(this.toAggregationResult(exp));
        }
        if (exp instanceof AndFunction) {
            AndFunction andFunction = (AndFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new AndFunctionNode(), andFunction);
        }
        if (exp instanceof AttributeMapLookupValue) {
            AttributeMapLookupValue mapLookup = (AttributeMapLookupValue)exp;
            if (mapLookup.hasKeySourceAttribute()) {
                return AttributeMapLookupNode.fromKeySourceAttribute((String)mapLookup.getAttributeName(), (String)mapLookup.getKeyAttribute(), (String)mapLookup.getValueAttribute(), (String)mapLookup.getKeySourceAttribute());
            }
            return AttributeMapLookupNode.fromKey((String)mapLookup.getAttributeName(), (String)mapLookup.getKeyAttribute(), (String)mapLookup.getValueAttribute(), (String)mapLookup.getKey());
        }
        if (exp instanceof AttributeValue) {
            AttributeValue value = (AttributeValue)exp;
            return new AttributeNode(value.getAttributeName());
        }
        if (exp instanceof AttributeFunction) {
            AttributeFunction function = (AttributeFunction)exp;
            return new AttributeNode(function.getAttributeName());
        }
        if (exp instanceof CatFunction) {
            CatFunction function = (CatFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new CatFunctionNode(), function);
        }
        if (exp instanceof DebugWaitFunction) {
            DebugWaitFunction waitFunction = (DebugWaitFunction)exp;
            return new DebugWaitFunctionNode(this.toExpressionNode(waitFunction.getArg(0)), waitFunction.getWaitTime(), waitFunction.getBusyWait());
        }
        if (exp instanceof DocIdNsSpecificValue) {
            return new GetDocIdNamespaceSpecificFunctionNode();
        }
        if (exp instanceof DoubleValue) {
            DoubleValue value = (DoubleValue)exp;
            return new ConstantNode((ResultNode)new FloatResultNode(((Double)value.getValue()).doubleValue()));
        }
        if (exp instanceof DivFunction) {
            DivFunction divFunction = (DivFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new DivideFunctionNode(), divFunction);
        }
        if (exp instanceof FixedWidthFunction) {
            FixedWidthFunction fixedWidthFunction = (FixedWidthFunction)exp;
            Number w = fixedWidthFunction.getWidth();
            return new FixedWidthBucketFunctionNode((NumericResultNode)(w instanceof Double ? new FloatResultNode(w.doubleValue()) : new IntegerResultNode(w.longValue())), this.toExpressionNode(fixedWidthFunction.getArg(0)));
        }
        if (exp instanceof LongValue) {
            LongValue value = (LongValue)exp;
            return new ConstantNode((ResultNode)new IntegerResultNode(((Long)value.getValue()).longValue()));
        }
        if (exp instanceof MaxFunction) {
            MaxFunction maxFunction = (MaxFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new MaxFunctionNode(), maxFunction);
        }
        if (exp instanceof Md5Function) {
            Md5Function md5Function = (Md5Function)exp;
            return new MD5BitFunctionNode().setNumBits(md5Function.getNumBits()).addArg(this.toExpressionNode(md5Function.getArg(0)));
        }
        if (exp instanceof UcaFunction) {
            UcaFunction uca = (UcaFunction)exp;
            return new UcaFunctionNode(this.toExpressionNode(uca.getArg(0)), uca.getLocale(), uca.getStrength());
        }
        if (exp instanceof MinFunction) {
            MinFunction minFunction = (MinFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new MinFunctionNode(), minFunction);
        }
        if (exp instanceof ModFunction) {
            ModFunction modFunction = (ModFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new ModuloFunctionNode(), modFunction);
        }
        if (exp instanceof MulFunction) {
            MulFunction mulFunction = (MulFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new MultiplyFunctionNode(), mulFunction);
        }
        if (exp instanceof NegFunction) {
            NegFunction negFunction = (NegFunction)exp;
            return new NegateFunctionNode(this.toExpressionNode(negFunction.getArg(0)));
        }
        if (exp instanceof NormalizeSubjectFunction) {
            NormalizeSubjectFunction normalizeSubjectFunction = (NormalizeSubjectFunction)exp;
            return new NormalizeSubjectFunctionNode(this.toExpressionNode(normalizeSubjectFunction.getArg(0)));
        }
        if (exp instanceof NowFunction) {
            return new ConstantNode((ResultNode)new IntegerResultNode(System.currentTimeMillis() / 1000L));
        }
        if (exp instanceof OrFunction) {
            OrFunction orFunction = (OrFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new OrFunctionNode(), orFunction);
        }
        if (exp instanceof PredefinedFunction) {
            PredefinedFunction predefinedFunction = (PredefinedFunction)exp;
            return new RangeBucketPreDefFunctionNode(this.toBucketList(predefinedFunction), this.toExpressionNode(predefinedFunction.getArg(0)));
        }
        if (exp instanceof RelevanceValue) {
            return new RelevanceNode();
        }
        if (exp instanceof ReverseFunction) {
            ReverseFunction reverseFunction = (ReverseFunction)exp;
            return new ReverseFunctionNode(this.toExpressionNode(reverseFunction.getArg(0)));
        }
        if (exp instanceof SizeFunction) {
            SizeFunction sizeFunction = (SizeFunction)exp;
            return new NumElemFunctionNode(this.toExpressionNode(sizeFunction.getArg(0)));
        }
        if (exp instanceof SortFunction) {
            SortFunction sortFunction = (SortFunction)exp;
            return new SortFunctionNode(this.toExpressionNode(sortFunction.getArg(0)));
        }
        if (exp instanceof ArrayAtLookup) {
            ArrayAtLookup lookup = (ArrayAtLookup)exp;
            return new ArrayAtLookupNode(lookup.getAttributeName(), this.toExpressionNode(lookup.getIndexArgument()));
        }
        if (exp instanceof InterpolatedLookup) {
            InterpolatedLookup lookup = (InterpolatedLookup)exp;
            return new InterpolatedLookupNode(lookup.getAttributeName(), this.toExpressionNode(lookup.getLookupArgument()));
        }
        if (exp instanceof StrCatFunction) {
            StrCatFunction strCatFunction = (StrCatFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new StrCatFunctionNode(), strCatFunction);
        }
        if (exp instanceof StringValue) {
            StringValue value = (StringValue)exp;
            return new ConstantNode((ResultNode)new StringResultNode((String)value.getValue()));
        }
        if (exp instanceof StrLenFunction) {
            StrLenFunction strLenFunction = (StrLenFunction)exp;
            return new StrLenFunctionNode(this.toExpressionNode(strLenFunction.getArg(0)));
        }
        if (exp instanceof SubFunction) {
            SubFunction subFunction = (SubFunction)exp;
            return this.toSubNode(subFunction);
        }
        if (exp instanceof ToDoubleFunction) {
            ToDoubleFunction toDoubleFunction = (ToDoubleFunction)exp;
            return new ToFloatFunctionNode(this.toExpressionNode(toDoubleFunction.getArg(0)));
        }
        if (exp instanceof ToLongFunction) {
            ToLongFunction toLongFunction = (ToLongFunction)exp;
            return new ToIntFunctionNode(this.toExpressionNode(toLongFunction.getArg(0)));
        }
        if (exp instanceof ToRawFunction) {
            ToRawFunction toRawFunction = (ToRawFunction)exp;
            return new ToRawFunctionNode(this.toExpressionNode(toRawFunction.getArg(0)));
        }
        if (exp instanceof ToStringFunction) {
            ToStringFunction toStringFunction = (ToStringFunction)exp;
            return new ToStringFunctionNode(this.toExpressionNode(toStringFunction.getArg(0)));
        }
        if (exp instanceof DateFunction) {
            DateFunction dateFunction = (DateFunction)exp;
            StrCatFunctionNode ret = new StrCatFunctionNode();
            GroupingExpression arg = dateFunction.getArg(0);
            ret.addArg((ExpressionNode)new ToStringFunctionNode((ExpressionNode)this.toTime(arg, TimeStampFunctionNode.TimePart.Year)));
            ret.addArg((ExpressionNode)new ConstantNode((ResultNode)new StringResultNode("-")));
            ret.addArg((ExpressionNode)new ToStringFunctionNode((ExpressionNode)this.toTime(arg, TimeStampFunctionNode.TimePart.Month)));
            ret.addArg((ExpressionNode)new ConstantNode((ResultNode)new StringResultNode("-")));
            ret.addArg((ExpressionNode)new ToStringFunctionNode((ExpressionNode)this.toTime(arg, TimeStampFunctionNode.TimePart.MonthDay)));
            return ret;
        }
        if (exp instanceof MathSqrtFunction) {
            MathSqrtFunction mathSqrtFunction = (MathSqrtFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathSqrtFunction.getArg(0)), MathFunctionNode.Function.SQRT);
        }
        if (exp instanceof MathCbrtFunction) {
            MathCbrtFunction mathCbrtFunction = (MathCbrtFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathCbrtFunction.getArg(0)), MathFunctionNode.Function.CBRT);
        }
        if (exp instanceof MathLogFunction) {
            MathLogFunction mathLogFunction = (MathLogFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathLogFunction.getArg(0)), MathFunctionNode.Function.LOG);
        }
        if (exp instanceof MathLog1pFunction) {
            MathLog1pFunction mathLog1pFunction = (MathLog1pFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathLog1pFunction.getArg(0)), MathFunctionNode.Function.LOG1P);
        }
        if (exp instanceof MathLog10Function) {
            MathLog10Function mathLog10Function = (MathLog10Function)exp;
            return new MathFunctionNode(this.toExpressionNode(mathLog10Function.getArg(0)), MathFunctionNode.Function.LOG10);
        }
        if (exp instanceof MathExpFunction) {
            MathExpFunction mathExpFunction = (MathExpFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathExpFunction.getArg(0)), MathFunctionNode.Function.EXP);
        }
        if (exp instanceof MathPowFunction) {
            MathPowFunction mathPowFunction = (MathPowFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathPowFunction.getArg(0)), MathFunctionNode.Function.POW).addArg(this.toExpressionNode(mathPowFunction.getArg(1)));
        }
        if (exp instanceof MathHypotFunction) {
            MathHypotFunction mathHypotFunction = (MathHypotFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathHypotFunction.getArg(0)), MathFunctionNode.Function.HYPOT).addArg(this.toExpressionNode(mathHypotFunction.getArg(1)));
        }
        if (exp instanceof MathSinFunction) {
            MathSinFunction mathSinFunction = (MathSinFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathSinFunction.getArg(0)), MathFunctionNode.Function.SIN);
        }
        if (exp instanceof MathASinFunction) {
            MathASinFunction mathASinFunction = (MathASinFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathASinFunction.getArg(0)), MathFunctionNode.Function.ASIN);
        }
        if (exp instanceof MathCosFunction) {
            MathCosFunction mathCosFunction = (MathCosFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathCosFunction.getArg(0)), MathFunctionNode.Function.COS);
        }
        if (exp instanceof MathACosFunction) {
            MathACosFunction mathACosFunction = (MathACosFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathACosFunction.getArg(0)), MathFunctionNode.Function.ACOS);
        }
        if (exp instanceof MathTanFunction) {
            MathTanFunction mathTanFunction = (MathTanFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathTanFunction.getArg(0)), MathFunctionNode.Function.TAN);
        }
        if (exp instanceof MathATanFunction) {
            MathATanFunction mathATanFunction = (MathATanFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathATanFunction.getArg(0)), MathFunctionNode.Function.ATAN);
        }
        if (exp instanceof MathSinHFunction) {
            MathSinHFunction mathSinHFunction = (MathSinHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathSinHFunction.getArg(0)), MathFunctionNode.Function.SINH);
        }
        if (exp instanceof MathASinHFunction) {
            MathASinHFunction mathASinHFunction = (MathASinHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathASinHFunction.getArg(0)), MathFunctionNode.Function.ASINH);
        }
        if (exp instanceof MathCosHFunction) {
            MathCosHFunction mathCosHFunction = (MathCosHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathCosHFunction.getArg(0)), MathFunctionNode.Function.COSH);
        }
        if (exp instanceof MathACosHFunction) {
            MathACosHFunction mathACosHFunction = (MathACosHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathACosHFunction.getArg(0)), MathFunctionNode.Function.ACOSH);
        }
        if (exp instanceof MathTanHFunction) {
            MathTanHFunction mathTanHFunction = (MathTanHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathTanHFunction.getArg(0)), MathFunctionNode.Function.TANH);
        }
        if (exp instanceof MathATanHFunction) {
            MathATanHFunction mathATanHFunction = (MathATanHFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathATanHFunction.getArg(0)), MathFunctionNode.Function.ATANH);
        }
        if (exp instanceof MathFloorFunction) {
            MathFloorFunction mathFloorFunction = (MathFloorFunction)exp;
            return new MathFunctionNode(this.toExpressionNode(mathFloorFunction.getArg(0)), MathFunctionNode.Function.FLOOR);
        }
        if (exp instanceof ZCurveXFunction) {
            ZCurveXFunction zCurveXFunction = (ZCurveXFunction)exp;
            return new ZCurveFunctionNode(this.toExpressionNode(zCurveXFunction.getArg(0)), ZCurveFunctionNode.Dimension.X);
        }
        if (exp instanceof ZCurveYFunction) {
            ZCurveYFunction zCurveYFunction = (ZCurveYFunction)exp;
            return new ZCurveFunctionNode(this.toExpressionNode(zCurveYFunction.getArg(0)), ZCurveFunctionNode.Dimension.Y);
        }
        if (exp instanceof DayOfMonthFunction) {
            DayOfMonthFunction dayOfMonthFunction = (DayOfMonthFunction)exp;
            return this.toTime(dayOfMonthFunction.getArg(0), TimeStampFunctionNode.TimePart.MonthDay);
        }
        if (exp instanceof DayOfWeekFunction) {
            DayOfWeekFunction dayOfWeekFunction = (DayOfWeekFunction)exp;
            return this.toTime(dayOfWeekFunction.getArg(0), TimeStampFunctionNode.TimePart.WeekDay);
        }
        if (exp instanceof DayOfYearFunction) {
            DayOfYearFunction dayOfYearFunction = (DayOfYearFunction)exp;
            return this.toTime(dayOfYearFunction.getArg(0), TimeStampFunctionNode.TimePart.YearDay);
        }
        if (exp instanceof HourOfDayFunction) {
            HourOfDayFunction hourOfDayFunction = (HourOfDayFunction)exp;
            return this.toTime(hourOfDayFunction.getArg(0), TimeStampFunctionNode.TimePart.Hour);
        }
        if (exp instanceof MinuteOfHourFunction) {
            MinuteOfHourFunction minuteOfHourFunction = (MinuteOfHourFunction)exp;
            return this.toTime(minuteOfHourFunction.getArg(0), TimeStampFunctionNode.TimePart.Minute);
        }
        if (exp instanceof MonthOfYearFunction) {
            MonthOfYearFunction monthOfYearFunction = (MonthOfYearFunction)exp;
            return this.toTime(monthOfYearFunction.getArg(0), TimeStampFunctionNode.TimePart.Month);
        }
        if (exp instanceof SecondOfMinuteFunction) {
            SecondOfMinuteFunction secondOfMinuteFunction = (SecondOfMinuteFunction)exp;
            return this.toTime(secondOfMinuteFunction.getArg(0), TimeStampFunctionNode.TimePart.Second);
        }
        if (exp instanceof YearFunction) {
            YearFunction yearFunction = (YearFunction)exp;
            return this.toTime(yearFunction.getArg(0), TimeStampFunctionNode.TimePart.Year);
        }
        if (exp instanceof XorFunction) {
            XorFunction xorFunction = (XorFunction)exp;
            return this.addArguments((MultiArgFunctionNode)new XorFunctionNode(), xorFunction);
        }
        if (exp instanceof XorBitFunction) {
            XorBitFunction xorBitFunction = (XorBitFunction)exp;
            return new XorBitFunctionNode().setNumBits(xorBitFunction.getNumBits()).addArg(this.toExpressionNode(xorBitFunction.getArg(0)));
        }
        throw new IllegalInputException("Can not convert '" + String.valueOf(exp) + "' of class " + exp.getClass().getName() + " to an expression.");
    }

    private TimeStampFunctionNode toTime(GroupingExpression arg, TimeStampFunctionNode.TimePart timePart) {
        if (this.timeOffset == 0) {
            return new TimeStampFunctionNode(this.toExpressionNode(arg), timePart, true);
        }
        AddFunctionNode exp = new AddFunctionNode();
        exp.addArg(this.toExpressionNode(arg));
        exp.addArg((ExpressionNode)new ConstantNode((ResultNode)new IntegerResultNode((long)this.timeOffset)));
        return new TimeStampFunctionNode((ExpressionNode)exp, timePart, true);
    }

    private MultiArgFunctionNode addArguments(MultiArgFunctionNode ret, Iterable<GroupingExpression> lst) {
        for (GroupingExpression exp : lst) {
            ret.addArg(this.toExpressionNode(exp));
        }
        return ret;
    }

    private MultiArgFunctionNode toSubNode(Iterable<GroupingExpression> lst) {
        AddFunctionNode ret = new AddFunctionNode();
        int i = 0;
        for (GroupingExpression exp : lst) {
            ExpressionNode node = this.toExpressionNode(exp);
            if (++i > 1) {
                node = new NegateFunctionNode(node);
            }
            ret.addArg(node);
        }
        return ret;
    }

    private ResultNodeVector toBucketList(PredefinedFunction fnc) {
        Object ret = null;
        int len = fnc.getNumBuckets();
        for (int i = 0; i < len; ++i) {
            BucketResultNode bucket = this.toBucket(fnc.getBucket(i));
            if (ret == null) {
                ret = bucket instanceof FloatBucketResultNode ? new FloatBucketResultNodeVector() : (bucket instanceof IntegerBucketResultNode ? new IntegerBucketResultNodeVector() : (bucket instanceof RawBucketResultNode ? new RawBucketResultNodeVector() : new StringBucketResultNodeVector()));
            }
            ret.add((ResultNode)bucket);
        }
        return ret;
    }

    private BucketResultNode toBucket(GroupingExpression exp) {
        if (!(exp instanceof BucketValue)) {
            throw new IllegalInputException("Can not convert '" + String.valueOf(exp) + "' to a bucket.");
        }
        BucketValue bucketValue = (BucketValue)exp;
        ConstantValue<?> begin = bucketValue.getFrom();
        ConstantValue<?> end = bucketValue.getTo();
        if (begin instanceof DoubleValue || end instanceof DoubleValue) {
            return new FloatBucketResultNode(begin instanceof InfiniteValue ? FloatResultNode.getNegativeInfinity().getFloat() : Double.valueOf(begin.toString()).doubleValue(), end instanceof InfiniteValue ? FloatResultNode.getPositiveInfinity().getFloat() : Double.valueOf(end.toString()).doubleValue());
        }
        if (begin instanceof LongValue || end instanceof LongValue) {
            return new IntegerBucketResultNode(begin instanceof InfiniteValue ? IntegerResultNode.getNegativeInfinity().getInteger() : Long.valueOf(begin.toString()).longValue(), end instanceof InfiniteValue ? IntegerResultNode.getPositiveInfinity().getInteger() : Long.valueOf(end.toString()).longValue());
        }
        if (begin instanceof StringValue || end instanceof StringValue) {
            return new StringBucketResultNode((ResultNode)(begin instanceof InfiniteValue ? StringResultNode.getNegativeInfinity() : new StringResultNode((String)begin.getValue())), (ResultNode)(end instanceof InfiniteValue ? StringResultNode.getPositiveInfinity() : new StringResultNode((String)end.getValue())));
        }
        return new RawBucketResultNode((ResultNode)(begin instanceof InfiniteValue ? RawResultNode.getNegativeInfinity() : new RawResultNode(((RawBuffer)((RawValue)begin).getValue()).getBytes())), (ResultNode)(end instanceof InfiniteValue ? RawResultNode.getPositiveInfinity() : new RawResultNode(((RawBuffer)((RawValue)end).getValue()).getBytes())));
    }
}

