/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.api.annotations.Beta;
import com.yahoo.search.grouping.request.FilterExpression;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@Beta
public class RegexPredicate
extends FilterExpression {
    private final String pattern;
    private final GroupingExpression expression;

    public RegexPredicate(String pattern, GroupingExpression expression) {
        RegexPredicate.validateRegex(pattern);
        this.pattern = pattern;
        this.expression = expression;
    }

    private static void validateRegex(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex pattern: %s (%s)".formatted(pattern, e.getMessage()), e);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public GroupingExpression getExpression() {
        return this.expression;
    }

    @Override
    public String toString() {
        return "regex(\"%s\", %s)".formatted(this.pattern, this.expression);
    }

    @Override
    public FilterExpression copy() {
        return new RegexPredicate(this.pattern, this.expression.copy());
    }
}

