/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.data.access.Inspector;
import com.yahoo.search.result.FeatureData;
import java.util.Arrays;

public class LeanHit
implements Comparable<LeanHit> {
    private final byte[] gid;
    private final double relevance;
    private final byte[] sortData;
    private final int partId;
    private final int distributionKey;
    private FeatureData matchFeatures;

    public LeanHit(byte[] gid, int partId, int distributionKey, double relevance) {
        this(gid, partId, distributionKey, relevance, null);
    }

    public LeanHit(byte[] gid, int partId, int distributionKey, double relevance, byte[] sortData) {
        this.gid = gid;
        this.relevance = Double.isNaN(relevance) ? Double.NEGATIVE_INFINITY : relevance;
        this.sortData = sortData;
        this.partId = partId;
        this.distributionKey = distributionKey;
        this.matchFeatures = null;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public byte[] getGid() {
        return this.gid;
    }

    public byte[] getSortData() {
        return this.sortData;
    }

    public boolean hasSortData() {
        return this.sortData != null;
    }

    public int getPartId() {
        return this.partId;
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public FeatureData getMatchFeatures() {
        return this.matchFeatures;
    }

    public boolean hasMatchFeatures() {
        return this.matchFeatures != null;
    }

    public void addMatchFeatures(Inspector features) {
        this.matchFeatures = new FeatureData(features);
    }

    @Override
    public int compareTo(LeanHit o) {
        int res = this.sortData != null ? LeanHit.compareData(this.sortData, o.sortData) : Double.compare(o.relevance, this.relevance);
        return res != 0 ? res : LeanHit.compareData(this.gid, o.gid);
    }

    public static int compareData(byte[] left, byte[] right) {
        int i = Arrays.mismatch(left, right);
        if (i < 0) {
            return 0;
        }
        int max = Integer.min(left.length, right.length);
        if (i >= max) {
            return left.length - right.length;
        }
        int vl = left[i] & 0xFF;
        int vr = right[i] & 0xFF;
        return vl - vr;
    }
}

