/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.collections.TinyIdentitySet;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.GeoLocationItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.textualrepresentation.TextualQueryRepresentation;
import com.yahoo.prelude.querytransform.QueryRewrite;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.protect.Validator;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.searchlib.aggregation.Grouping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class VespaBackend {
    public static final String SORTABLE_ATTRIBUTES_SUMMARY_CLASS = "attributeprefetch";
    private final String serverId;
    private final Map<String, DocumentDatabase> documentDbs;
    private final DocumentDatabase defaultDocumentDb;
    private final String defaultDocsumClass;
    private final String name;

    private static Iterator<Hit> hitIterator(Result result) {
        return result.hits().unorderedDeepIterator();
    }

    protected VespaBackend(ClusterParams clusterParams) {
        this.serverId = clusterParams.getServerId();
        this.name = clusterParams.getSearcherName();
        this.defaultDocsumClass = clusterParams.getDefaultSummary();
        Validator.ensureNotNull((String)"Name of Vespa backend integration", (Object)this.name);
        ArrayList<DocumentDatabase> dbs = new ArrayList<DocumentDatabase>();
        if (clusterParams.getDocumentdbInfoConfig() != null) {
            for (DocumentdbInfoConfig.Documentdb docDb : clusterParams.getDocumentdbInfoConfig().documentdb()) {
                DocumentDatabase db2 = new DocumentDatabase(clusterParams.getSchemaInfo().schemas().get(docDb.name()));
                dbs.add(db2);
            }
        }
        this.defaultDocumentDb = dbs.isEmpty() ? null : (DocumentDatabase)dbs.get(0);
        this.documentDbs = dbs.stream().collect(Collectors.toMap(db -> db.schema().name(), db -> db));
    }

    public final String getName() {
        return this.name;
    }

    protected final String getDefaultDocsumClass() {
        return this.defaultDocsumClass;
    }

    protected abstract Result doSearch2(String var1, Query var2);

    protected abstract void doPartialFill(Result var1, String var2);

    private boolean hasLocation(Item tree) {
        if (tree instanceof GeoLocationItem) {
            return true;
        }
        if (tree instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)tree;
            for (Item child : composite.items()) {
                if (!this.hasLocation(child)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean summaryNeedsQuery(Query query) {
        if (query.getRanking().getQueryCache()) {
            return false;
        }
        DocumentDatabase documentDb = this.getDocumentDatabase(query);
        DocsumDefinition docsumDefinition = documentDb.getDocsumDefinitionSet().getDocsum(query.getPresentation().getSummary());
        if (docsumDefinition.isDynamic()) {
            return true;
        }
        if (this.hasLocation(query.getModel().getQueryTree())) {
            return true;
        }
        RankProfile rankProfile = documentDb.schema().rankProfiles().get(query.getRanking().getProfile());
        if (rankProfile == null) {
            return true;
        }
        if (rankProfile.hasSummaryFeatures()) {
            return true;
        }
        return query.getRanking().getListFeatures();
    }

    public String getServerId() {
        return this.serverId;
    }

    public DocumentDatabase getDocumentDatabase(Query query) {
        String docTypeName;
        DocumentDatabase db;
        if (query.getModel().getRestrict().size() == 1 && (db = this.documentDbs.get(docTypeName = (String)query.getModel().getRestrict().toArray()[0])) != null) {
            return db;
        }
        return this.defaultDocumentDb;
    }

    private void resolveDocumentDatabase(Query query) {
        DocumentDatabase docDb = this.getDocumentDatabase(query);
        if (docDb != null) {
            query.getModel().setDocumentDb(docDb.schema().name());
        }
    }

    protected void transformQuery(Query query) {
    }

    public Result search(String schema, Query query) {
        Item root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query, ErrorMessage.createNullQuery(query.getUri().toString()));
        }
        if (!this.getDocumentDatabase(query).schema().rankProfiles().containsKey(query.getRanking().getProfile())) {
            return new Result(query, ErrorMessage.createInvalidQueryParameter(String.valueOf(this.getDocumentDatabase(query).schema()) + " does not contain requested rank profile '" + query.getRanking().getProfile() + "'"));
        }
        QueryRewrite.optimizeByRestrict(query);
        QueryRewrite.optimizeAndNot(query);
        QueryRewrite.collapseSingleComposites(query);
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        this.resolveDocumentDatabase(query);
        this.transformQuery(query);
        this.traceQuery(this.name, DispatchPhase.SEARCH, query, query.getOffset(), query.getHits(), 1, Optional.empty());
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        Result result = this.doSearch2(schema, query);
        if (query.getTrace().getLevel() >= 1) {
            query.trace(this.getName() + " dispatch response: " + String.valueOf(result), false, 1);
        }
        result.trace(this.getName());
        return result;
    }

    private static List<Result> partitionHits(Result result, String summaryClass) {
        ArrayList<Result> parts = new ArrayList<Result>();
        TinyIdentitySet queryMap = new TinyIdentitySet(4);
        Iterator<Hit> i = VespaBackend.hitIterator(result);
        while (i.hasNext()) {
            int idx;
            FastHit fastHit;
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || (fastHit = (FastHit)hit).isFilled(summaryClass)) continue;
            Query q = fastHit.getQuery();
            if (q == null) {
                q = result.hits().getQuery();
            }
            if ((idx = queryMap.indexOf((Object)q)) < 0) {
                idx = queryMap.size();
                Result r = new Result(q);
                parts.add(r);
                queryMap.add((Object)q);
            }
            ((Result)parts.get(idx)).hits().add(fastHit);
        }
        return parts;
    }

    public void fill(Result result, String summaryClass) {
        if (result.isFilled(summaryClass)) {
            return;
        }
        List<Result> parts = VespaBackend.partitionHits(result, summaryClass);
        if (!parts.isEmpty()) {
            for (Result r : parts) {
                this.doPartialFill(r, this.ensureLegalSummaryClass(r.getQuery(), summaryClass));
                this.mergeErrorsInto(result, r);
            }
            result.hits().setSorted(false);
            result.analyzeHits();
        }
    }

    protected String ensureLegalSummaryClass(Query query, String summaryClass) {
        if (summaryClass != null) {
            if (summaryClass.isEmpty()) {
                return null;
            }
            DocumentDatabase db = this.getDocumentDatabase(query);
            if (db != null && !db.getDocsumDefinitionSet().hasDocsum(summaryClass)) {
                throw new IllegalInputException("invalid presentation.summary=" + summaryClass);
            }
        }
        return summaryClass;
    }

    private void mergeErrorsInto(Result destination, Result source) {
        destination.hits().addErrorsFrom(source.hits());
    }

    void traceQuery(String sourceName, DispatchPhase phase, Query query, int offset, int hits, int level, Optional<String> quotedSummaryClass) {
        if (query.getTrace().getLevel() < level || !query.getTrace().getQuery()) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(sourceName).append(" ").append(phase.name().toLowerCase()).append(" to dispatch: ").append("query=[").append(query.getModel().getQueryTree().getRoot().toString()).append("]");
        s.append(" timeout=").append(query.getTimeout()).append("ms");
        s.append(" offset=").append(offset).append(" hits=").append(hits);
        if (query.getRanking().hasRankProfile()) {
            s.append(" rankprofile[").append(query.getRanking().getProfile()).append("]");
        }
        if (query.getRanking().getFreshness() != null) {
            s.append(" freshness=").append(query.getRanking().getFreshness().getRefTime());
        }
        if (query.getRanking().getSorting() != null) {
            s.append(" sortspec=").append(query.getRanking().getSorting().fieldOrders().toString());
        }
        if (query.getRanking().getLocation() != null) {
            s.append(" location=").append(query.getRanking().getLocation().backendString());
        }
        if (query.getGroupingSessionCache()) {
            s.append(" groupingSessionCache=true");
        }
        if (query.getRanking().getQueryCache()) {
            s.append(" ranking.queryCache=true");
        }
        if (query.getGroupingSessionCache() || query.getRanking().getQueryCache()) {
            s.append(" sessionId=").append(query.getSessionId(this.getServerId()));
        }
        if (query.getTrace().getLevel() >= level + 3) {
            List<Grouping> grouping = GroupingExecutor.getGroupingList(query);
            s.append(" grouping=").append(grouping.size()).append(" : ");
            for (Grouping g : grouping) {
                s.append(g.toString());
            }
        }
        if (!query.getRanking().getProperties().isEmpty()) {
            s.append(" rankproperties=").append(query.getRanking().getProperties().toString());
        }
        if (!query.getRanking().getFeatures().isEmpty()) {
            s.append(" rankfeatures=").append(query.getRanking().getFeatures().toString());
        }
        if (query.getModel().getRestrict() != null) {
            s.append(" restrict=").append(query.getModel().getRestrict().toString());
        }
        quotedSummaryClass.ifPresent(summaryClass -> s.append(" summary=").append((String)summaryClass));
        query.trace(s.toString(), false, level);
        if (query.getTrace().isTraceable(level + 1) && query.getTrace().getQuery()) {
            query.trace("Current state of query tree: " + String.valueOf(new TextualQueryRepresentation(query.getModel().getQueryTree().getRoot())), false, level + 1);
        }
        if (query.getTrace().isTraceable(level + 2) && query.getTrace().getQuery()) {
            query.trace("YQL+ representation: " + query.yqlRepresentation(), level + 2);
        }
    }

    private FillHitResult fillHit(FastHit hit, DocsumPacket packet, String summaryClass) {
        byte[] docsumdata;
        if (packet != null && (docsumdata = packet.getData()).length > 0) {
            return new FillHitResult(true, this.decodeSummary(summaryClass, hit, docsumdata));
        }
        return new FillHitResult(false);
    }

    protected FillHitsResult fillHits(Result result, DocsumPacket[] packets, String summaryClass) {
        int skippedHits = 0;
        String lastError = null;
        int packetIndex = 0;
        Iterator<Hit> i = VespaBackend.hitIterator(result);
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit)) continue;
            FastHit fastHit = (FastHit)hit;
            if (hit.isFilled(summaryClass)) continue;
            DocsumPacket docsum = packets[packetIndex];
            ++packetIndex;
            FillHitResult fr = this.fillHit(fastHit, docsum, summaryClass);
            if (!fr.ok) {
                ++skippedHits;
            }
            if (fr.error == null) continue;
            result.hits().addError(ErrorMessage.createTimeout(fr.error));
            ++skippedHits;
            lastError = fr.error;
        }
        result.hits().setSorted(false);
        return new FillHitsResult(skippedHits, lastError);
    }

    private String decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata) {
        DocumentDatabase db = this.getDocumentDatabase(hit.getQuery());
        hit.setField("sddocname", db.schema().name());
        return VespaBackend.decodeSummary(summaryClass, hit, docsumdata, db.getDocsumDefinitionSet());
    }

    private static String decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata, DocsumDefinitionSet docsumSet) {
        String error = docsumSet.lazyDecode(summaryClass, docsumdata, hit);
        if (error == null) {
            hit.setFilled(summaryClass);
        }
        return error;
    }

    public void shutDown() {
    }

    protected static enum DispatchPhase {
        SEARCH,
        FILL;

    }

    static class FillHitResult {
        final boolean ok;
        final String error;

        FillHitResult(boolean ok) {
            this(ok, null);
        }

        FillHitResult(boolean ok, String error) {
            this.ok = ok;
            this.error = error;
        }
    }

    protected static class FillHitsResult {
        public final int skippedHits;
        public final String error;

        FillHitsResult(int skippedHits, String error) {
            this.skippedHits = skippedHits;
            this.error = error;
        }
    }
}

