/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.Optional;

public class Pong {
    private final ElapsedTime elapsed = new ElapsedTime();
    private final Long activeDocuments;
    private final Long targetActiveDocuments;
    private final boolean isBlockingWrites;
    private final ErrorMessage error;

    public Pong() {
        this(null, null, false, null);
    }

    public Pong(ErrorMessage error) {
        this(null, null, false, error);
    }

    public Pong(long activeDocuments, long targetActiveDocuments) {
        this(activeDocuments, targetActiveDocuments, false, null);
    }

    public Pong(long activeDocuments, long targetActiveDocuments, boolean isBlockingWrites) {
        this(activeDocuments, targetActiveDocuments, isBlockingWrites, null);
    }

    private Pong(Long activeDocuments, Long targetActiveDocuments, boolean isBlockingWrites, ErrorMessage error) {
        this.activeDocuments = activeDocuments;
        this.targetActiveDocuments = targetActiveDocuments;
        this.isBlockingWrites = isBlockingWrites;
        this.error = error;
    }

    public Optional<ErrorMessage> error() {
        return Optional.ofNullable(this.error);
    }

    public Optional<Long> activeDocuments() {
        return Optional.ofNullable(this.activeDocuments);
    }

    public Optional<Long> targetActiveDocuments() {
        return Optional.ofNullable(this.targetActiveDocuments);
    }

    public boolean isBlockingWrites() {
        return this.isBlockingWrites;
    }

    public boolean badResponse() {
        return this.error != null;
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsed;
    }

    public String toString() {
        StringBuilder m = new StringBuilder("Ping result");
        this.activeDocuments().ifPresent(docCount -> m.append(" active docs: ").append(docCount));
        this.targetActiveDocuments().ifPresent(docCount -> m.append(" target active docs: ").append(docCount));
        if (this.isBlockingWrites) {
            m.append(" blocking writes: true");
        }
        this.error().ifPresent(e -> m.append(" error: ").append((Object)this.error));
        return m.toString();
    }
}

