/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.api.annotations.Beta;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;

@After(value={"replace-or-with-weakand"})
@Beta
public class OpportunisticWeakAndSearcher
extends Searcher {
    private static final CompoundName OPPORTUNISTIC_AND = CompoundName.from((String)"weakAnd.opportunistic.and");
    private static final CompoundName OPPORTUNISTIC_FACTOR = CompoundName.from((String)"weakAnd.opportunistic.factor");

    @Override
    public Result search(Query query, Execution execution) {
        if (query.getHits() > 100) {
            OpportunisticWeakAndSearcher.adjustWeakAndHeap(query.getModel().getQueryTree().getRoot(), query.getHits());
        }
        if (!query.properties().getBoolean(OPPORTUNISTIC_AND)) {
            return execution.search(query);
        }
        Item originalRoot = query.getModel().getQueryTree().getRoot();
        int targetHits = (int)((double)OpportunisticWeakAndSearcher.targetHits(originalRoot) * query.properties().getDouble(OPPORTUNISTIC_FACTOR, 1.0));
        if (targetHits >= 0) {
            query.getModel().getQueryTree().setRoot(OpportunisticWeakAndSearcher.weakAnd2AndRecurse(originalRoot.clone()));
            query.trace("WeakAND(" + targetHits + ") => AND", true, 2);
            Result result = execution.search(query);
            if (result.getTotalHitCount() >= (long)targetHits) {
                return result;
            }
            query.getModel().getQueryTree().setRoot(originalRoot);
            query.trace("Fallback to WeakAND(" + targetHits + ") as AND => " + result, true, 2);
            return execution.search(query);
        }
        return execution.search(query);
    }

    static Item adjustWeakAndHeap(Item item, int hits) {
        WeakAndItem weakAnd;
        if (item instanceof WeakAndItem && hits > (weakAnd = (WeakAndItem)item).getN() && !weakAnd.nIsExplicit()) {
            weakAnd.setN(hits);
        }
        if (item instanceof CompositeItem) {
            CompositeItem compositeItem = (CompositeItem)item;
            for (int i = 0; i < compositeItem.getItemCount(); ++i) {
                OpportunisticWeakAndSearcher.adjustWeakAndHeap(compositeItem.getItem(i), hits);
            }
        }
        return item;
    }

    static int targetHits(Item item) {
        if (!(item instanceof CompositeItem)) {
            return -1;
        }
        CompositeItem compositeItem = (CompositeItem)item;
        if (item instanceof WeakAndItem) {
            WeakAndItem weakAndItem = (WeakAndItem)item;
            return weakAndItem.getItemCount() >= 2 ? weakAndItem.getN() : -1;
        }
        for (int i = 0; i < compositeItem.getItemCount(); ++i) {
            int targetHits = OpportunisticWeakAndSearcher.targetHits(compositeItem.getItem(i));
            if (targetHits < 0) continue;
            return targetHits;
        }
        return -1;
    }

    static Item weakAnd2AndRecurse(Item item) {
        if (!(item instanceof CompositeItem)) {
            return item;
        }
        CompositeItem compositeItem = (CompositeItem)item;
        compositeItem = OpportunisticWeakAndSearcher.weakAnd2And(compositeItem);
        for (int i = 0; i < compositeItem.getItemCount(); ++i) {
            Item subItem = compositeItem.getItem(i);
            Item replacedItem = OpportunisticWeakAndSearcher.weakAnd2AndRecurse(subItem);
            if (replacedItem == subItem) continue;
            compositeItem.setItem(i, replacedItem);
        }
        return compositeItem;
    }

    private static CompositeItem weakAnd2And(CompositeItem item) {
        if (item instanceof WeakAndItem) {
            WeakAndItem weakAndItem = (WeakAndItem)item;
            AndItem andItem = new AndItem();
            andItem.setWeight(weakAndItem.getWeight());
            item.items().forEach(andItem::addItem);
            return andItem;
        }
        return item;
    }
}

