/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain.model.federation;

import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.prelude.cluster.ClusterSearcher;
import com.yahoo.prelude.querytransform.CJKSearcher;
import com.yahoo.prelude.querytransform.LiteralBoostSearcher;
import com.yahoo.prelude.querytransform.NormalizingSearcher;
import com.yahoo.prelude.querytransform.RecallSearcher;
import com.yahoo.prelude.querytransform.StemmingSearcher;
import com.yahoo.prelude.searcher.ValidatePredicateSearcher;
import com.yahoo.prelude.searcher.ValidateSortingSearcher;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.GroupingValidator;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.querytransform.BooleanSearcher;
import com.yahoo.search.querytransform.DefaultPositionSearcher;
import com.yahoo.search.querytransform.NGramSearcher;
import com.yahoo.search.querytransform.RangeQueryOptimizer;
import com.yahoo.search.querytransform.SortingDegrader;
import com.yahoo.search.querytransform.VespaLowercasingSearcher;
import com.yahoo.search.querytransform.WandSearcher;
import com.yahoo.search.searchers.ContainerLatencySearcher;
import com.yahoo.search.searchers.InputCheckingSearcher;
import com.yahoo.search.searchers.QueryValidator;
import com.yahoo.search.searchers.ValidateFuzzySearcher;
import com.yahoo.search.searchers.ValidateMatchPhaseSearcher;
import com.yahoo.search.searchers.ValidateNearestNeighborSearcher;
import com.yahoo.search.significance.SignificanceSearcher;
import com.yahoo.search.yql.FieldFiller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LocalProviderSpec {
    public static final Collection<ChainedComponentModel> searcherModels = LocalProviderSpec.toSearcherModels(CJKSearcher.class, NGramSearcher.class, LiteralBoostSearcher.class, NormalizingSearcher.class, StemmingSearcher.class, VespaLowercasingSearcher.class, DefaultPositionSearcher.class, RangeQueryOptimizer.class, SortingDegrader.class, ValidateSortingSearcher.class, QueryValidator.class, ClusterSearcher.class, GroupingValidator.class, GroupingExecutor.class, RecallSearcher.class, WandSearcher.class, BooleanSearcher.class, ValidatePredicateSearcher.class, ValidateNearestNeighborSearcher.class, ValidateMatchPhaseSearcher.class, ValidateFuzzySearcher.class, FieldFiller.class, InputCheckingSearcher.class, ContainerLatencySearcher.class, SignificanceSearcher.class);
    public final String clusterName;

    public LocalProviderSpec(String clusterName) {
        this.clusterName = Objects.requireNonNull(clusterName, "Cluster name cannot be null");
    }

    public static boolean includesType(String type) {
        return "local".equals(type);
    }

    @SafeVarargs
    private static Collection<ChainedComponentModel> toSearcherModels(Class<? extends Searcher> ... searchers) {
        ArrayList<ChainedComponentModel> searcherModels = new ArrayList<ChainedComponentModel>();
        for (Class<? extends Searcher> c : searchers) {
            searcherModels.add(new ChainedComponentModel(BundleInstantiationSpecification.fromSearchAndDocproc((String)c.getName()), Dependencies.emptyDependencies()));
        }
        return List.copyOf(searcherModels);
    }
}

