/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.api.annotations.Beta;
import com.yahoo.search.schema.Schema;
import com.yahoo.tensor.TensorType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public class RankProfile {
    private final String name;
    private final boolean hasSummaryFeatures;
    private final boolean hasRankFeatures;
    private final boolean useSignificanceModel;
    private final Map<String, InputType> inputs;
    private Schema schema = null;

    private RankProfile(Builder builder) {
        this.name = builder.name;
        this.hasSummaryFeatures = builder.hasSummaryFeatures;
        this.hasRankFeatures = builder.hasRankFeatures;
        this.useSignificanceModel = builder.useSignificanceModel;
        this.inputs = Collections.unmodifiableMap(builder.inputs);
    }

    public String name() {
        return this.name;
    }

    public Schema schema() {
        return this.schema;
    }

    void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalStateException("Cannot add rank profile '" + this.name + "' to schema '" + schema.name() + "' as it is already added to schema '" + this.schema.name() + "'");
        }
        this.schema = schema;
    }

    public boolean hasSummaryFeatures() {
        return this.hasSummaryFeatures;
    }

    public boolean hasRankFeatures() {
        return this.hasRankFeatures;
    }

    public boolean useSignificanceModel() {
        return this.useSignificanceModel;
    }

    public Map<String, InputType> inputs() {
        return this.inputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RankProfile)) {
            return false;
        }
        RankProfile other = (RankProfile)o;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (other.hasSummaryFeatures != this.hasSummaryFeatures) {
            return false;
        }
        if (other.hasRankFeatures != this.hasRankFeatures) {
            return false;
        }
        if (other.useSignificanceModel != this.useSignificanceModel) {
            return false;
        }
        return other.inputs.equals(this.inputs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hasSummaryFeatures, this.hasRankFeatures, this.useSignificanceModel, this.inputs);
    }

    public String toString() {
        return "rank profile '" + this.name + "'" + (String)(this.schema == null ? "" : " in " + this.schema);
    }

    public static class Builder {
        private final String name;
        private boolean hasSummaryFeatures = true;
        private boolean hasRankFeatures = true;
        private boolean useSignificanceModel = false;
        private final Map<String, InputType> inputs = new LinkedHashMap<String, InputType>();

        public Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder setHasSummaryFeatures(boolean hasSummaryFeatures) {
            this.hasSummaryFeatures = hasSummaryFeatures;
            return this;
        }

        public Builder setHasRankFeatures(boolean hasRankFeatures) {
            this.hasRankFeatures = hasRankFeatures;
            return this;
        }

        public Builder addInput(String name, InputType type) {
            this.inputs.put(name, type);
            return this;
        }

        public Builder setUseSignificanceModel(boolean use) {
            this.useSignificanceModel = use;
            return this;
        }

        public RankProfile build() {
            return new RankProfile(this);
        }
    }

    public record InputType(TensorType tensorType, boolean declaredString) {
        @Override
        public String toString() {
            return this.declaredString ? "string" : this.tensorType.toString();
        }

        public static InputType fromSpec(String spec) {
            if ("string".equals(spec)) {
                return new InputType(TensorType.empty, true);
            }
            if ("double".equals(spec)) {
                return new InputType(TensorType.empty, false);
            }
            return new InputType(TensorType.fromSpec((String)spec), false);
        }
    }
}

