/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

class RangeAdjuster {
    private double initialScores_high = -1.7976931348623157E308;
    private double initialScores_low = Double.MAX_VALUE;
    private double finalScores_high = -1.7976931348623157E308;
    private double finalScores_low = Double.MAX_VALUE;

    RangeAdjuster() {
    }

    boolean rescaleNeeded() {
        return this.initialScores_low > this.finalScores_low && this.initialScores_high >= this.initialScores_low && this.finalScores_high >= this.finalScores_low;
    }

    void withInitialScore(double score) {
        if (score < this.initialScores_low) {
            this.initialScores_low = score;
        }
        if (score > this.initialScores_high) {
            this.initialScores_high = score;
        }
    }

    void withFinalScore(double score) {
        if (score < this.finalScores_low) {
            this.finalScores_low = score;
        }
        if (score > this.finalScores_high) {
            this.finalScores_high = score;
        }
    }

    private double initialRange() {
        double r = this.initialScores_high - this.initialScores_low;
        if (r < 1.0) {
            r = 1.0;
        }
        return r;
    }

    private double finalRange() {
        double r = this.finalScores_high - this.finalScores_low;
        if (r < 1.0) {
            r = 1.0;
        }
        return r;
    }

    double scale() {
        return this.finalRange() / this.initialRange();
    }

    double bias() {
        return this.finalScores_low - this.initialScores_low * this.scale();
    }
}

