/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.chain.After;
import com.yahoo.yolean.chain.Provides;

@Provides(value={"replace-or-with-weakand"})
@After(value={"ExternalYql"})
public class WeakAndReplacementSearcher
extends Searcher {
    public static final String REPLACE_OR_WITH_WEAKAND = "replace-or-with-weakand";
    static final CompoundName WEAKAND_REPLACE = CompoundName.from((String)"weakAnd.replace");
    public static final CompoundName WAND_HITS = CompoundName.from((String)"wand.hits");

    @Override
    public Result search(Query query, Execution execution) {
        if (!query.properties().getBoolean(WEAKAND_REPLACE)) {
            return execution.search(query);
        }
        this.replaceOrItems(query);
        return execution.search(query);
    }

    private void replaceOrItems(Query query) {
        Item root = query.getModel().getQueryTree().getRoot();
        int hits = query.getHits();
        Integer wandHits = query.properties().getInteger(WAND_HITS);
        if (wandHits != null) {
            hits = wandHits;
        }
        query.getModel().getQueryTree().setRoot(this.replaceOrItems(root, hits));
        if (root != query.getModel().getQueryTree().getRoot()) {
            query.trace("Replaced OR by WeakAnd", true, 2);
        }
    }

    private Item replaceOrItems(Item item, int hits) {
        if (!(item instanceof CompositeItem)) {
            return item;
        }
        CompositeItem compositeItem = (CompositeItem)item;
        if (compositeItem instanceof OrItem) {
            WeakAndItem newItem = new WeakAndItem(hits);
            newItem.setWeight(compositeItem.getWeight());
            compositeItem.items().forEach(newItem::addItem);
            compositeItem = newItem;
        }
        for (int i = 0; i < compositeItem.getItemCount(); ++i) {
            Item subItem = compositeItem.getItem(i);
            Item replacedItem = this.replaceOrItems(subItem, hits);
            if (replacedItem == subItem) continue;
            compositeItem.setItem(i, replacedItem);
        }
        return compositeItem;
    }
}

