/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClusterConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "79bbef68dd4ead98136666457eb9e678";
    public static final String CONFIG_DEF_NAME = "cluster";
    public static final String CONFIG_DEF_NAMESPACE = "search.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.config", "cacheTimeout double default=0", "clusterName string", "maxQueryTimeout double default=600", "maxQueryCacheTimeout double default=10", "configid string default=\"\"", "storageRoute string default=\"\"", "indexMode enum {INDEX, STREAMING, STORE_ONLY} default = INDEX"};
    private final DoubleNode cacheTimeout;
    private final StringNode clusterName;
    private final DoubleNode maxQueryTimeout;
    private final DoubleNode maxQueryCacheTimeout;
    private final StringNode configid;
    private final StringNode storageRoute;
    private final IndexMode indexMode;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ClusterConfig(Builder builder) {
        this(builder, true);
    }

    private ClusterConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cluster must be initialized: " + builder.__uninitialized);
        }
        this.cacheTimeout = builder.cacheTimeout == null ? new DoubleNode(0.0) : new DoubleNode(builder.cacheTimeout.doubleValue());
        this.clusterName = builder.clusterName == null ? new StringNode() : new StringNode(builder.clusterName);
        this.maxQueryTimeout = builder.maxQueryTimeout == null ? new DoubleNode(600.0) : new DoubleNode(builder.maxQueryTimeout.doubleValue());
        this.maxQueryCacheTimeout = builder.maxQueryCacheTimeout == null ? new DoubleNode(10.0) : new DoubleNode(builder.maxQueryCacheTimeout.doubleValue());
        this.configid = builder.configid == null ? new StringNode("") : new StringNode(builder.configid);
        this.storageRoute = builder.storageRoute == null ? new StringNode("") : new StringNode(builder.storageRoute);
        this.indexMode = builder.indexMode == null ? new IndexMode(IndexMode.INDEX) : new IndexMode(builder.indexMode);
    }

    public double cacheTimeout() {
        return this.cacheTimeout.value();
    }

    public String clusterName() {
        return this.clusterName.value();
    }

    public double maxQueryTimeout() {
        return this.maxQueryTimeout.value();
    }

    public double maxQueryCacheTimeout() {
        return this.maxQueryCacheTimeout.value();
    }

    public String configid() {
        return this.configid.value();
    }

    public String storageRoute() {
        return this.storageRoute.value();
    }

    public IndexMode.Enum indexMode() {
        return (IndexMode.Enum)((Object)this.indexMode.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ClusterConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("clusterName"));
        private Double cacheTimeout = null;
        private String clusterName = null;
        private Double maxQueryTimeout = null;
        private Double maxQueryCacheTimeout = null;
        private String configid = null;
        private String storageRoute = null;
        private IndexMode.Enum indexMode = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ClusterConfig config) {
            this.cacheTimeout(config.cacheTimeout());
            this.clusterName(config.clusterName());
            this.maxQueryTimeout(config.maxQueryTimeout());
            this.maxQueryCacheTimeout(config.maxQueryCacheTimeout());
            this.configid(config.configid());
            this.storageRoute(config.storageRoute());
            this.indexMode(config.indexMode());
        }

        private Builder override(Builder __superior) {
            if (__superior.cacheTimeout != null) {
                this.cacheTimeout(__superior.cacheTimeout);
            }
            if (__superior.clusterName != null) {
                this.clusterName(__superior.clusterName);
            }
            if (__superior.maxQueryTimeout != null) {
                this.maxQueryTimeout(__superior.maxQueryTimeout);
            }
            if (__superior.maxQueryCacheTimeout != null) {
                this.maxQueryCacheTimeout(__superior.maxQueryCacheTimeout);
            }
            if (__superior.configid != null) {
                this.configid(__superior.configid);
            }
            if (__superior.storageRoute != null) {
                this.storageRoute(__superior.storageRoute);
            }
            if (__superior.indexMode != null) {
                this.indexMode(__superior.indexMode);
            }
            return this;
        }

        public Builder cacheTimeout(double __value) {
            this.cacheTimeout = __value;
            return this;
        }

        private Builder cacheTimeout(String __value) {
            return this.cacheTimeout(Double.valueOf(__value));
        }

        public Builder clusterName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clusterName = __value;
            this.__uninitialized.remove("clusterName");
            return this;
        }

        public Builder maxQueryTimeout(double __value) {
            this.maxQueryTimeout = __value;
            return this;
        }

        private Builder maxQueryTimeout(String __value) {
            return this.maxQueryTimeout(Double.valueOf(__value));
        }

        public Builder maxQueryCacheTimeout(double __value) {
            this.maxQueryCacheTimeout = __value;
            return this;
        }

        private Builder maxQueryCacheTimeout(String __value) {
            return this.maxQueryCacheTimeout(Double.valueOf(__value));
        }

        public Builder configid(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.configid = __value;
            return this;
        }

        public Builder storageRoute(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.storageRoute = __value;
            return this;
        }

        public Builder indexMode(IndexMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.indexMode = __value;
            return this;
        }

        private Builder indexMode(String __value) {
            return this.indexMode(IndexMode.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ClusterConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ClusterConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ClusterConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ClusterConfig build() {
            return new ClusterConfig(this);
        }
    }

    public static final class IndexMode
    extends EnumNode<Enum> {
        public static final Enum INDEX = Enum.INDEX;
        public static final Enum STREAMING = Enum.STREAMING;
        public static final Enum STORE_ONLY = Enum.STORE_ONLY;

        public IndexMode() {
            this.value = null;
        }

        public IndexMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            INDEX,
            STREAMING,
            STORE_ONLY;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

