/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.CompositeCondition;
import com.yahoo.prelude.semantics.rule.Condition;
import com.yahoo.prelude.semantics.rule.EllipsisCondition;
import com.yahoo.prelude.semantics.rule.ProductionList;
import com.yahoo.prelude.semantics.rule.ReferenceTermProduction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ProductionRule {
    private Condition condition;
    private ProductionList production = new ProductionList();
    private final Set<String> matchReferences = new LinkedHashSet<String>();

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setProduction(ProductionList production) {
        this.production = production;
    }

    public ProductionList getProduction() {
        return this.production;
    }

    public boolean matches(RuleEvaluation e) {
        e.setMatchReferences(this.matchReferences);
        return this.condition.matches(e);
    }

    public Set<String> matchReferences() {
        return Collections.unmodifiableSet(this.matchReferences);
    }

    public void makeReferences(RuleBase rules) {
        this.condition.makeReferences(rules);
        this.production.addMatchReferences(this.matchReferences);
    }

    public void produce(RuleEvaluation e) {
        this.production.produce(e);
    }

    public String toString() {
        return this.condition.toString() + " " + this.getSymbol() + " " + this.production.toString();
    }

    protected abstract String getSymbol();

    public boolean isLoop() {
        if (this.conditionIsEllipsAndOtherNameSpacesOnly(this.getCondition())) {
            return true;
        }
        return this.producesItself();
    }

    private boolean conditionIsEllipsAndOtherNameSpacesOnly(Condition condition) {
        if (condition instanceof EllipsisCondition) {
            return true;
        }
        if (!(condition instanceof CompositeCondition)) {
            return false;
        }
        Iterator<Condition> i = ((CompositeCondition)condition).conditionIterator();
        while (i.hasNext()) {
            Condition child = i.next();
            if (child.getNameSpace() != null || !this.conditionIsEllipsAndOtherNameSpacesOnly(child)) continue;
            return true;
        }
        return false;
    }

    private boolean producesItself() {
        return this.production.productionList().stream().anyMatch(p -> p instanceof ReferenceTermProduction && ((ReferenceTermProduction)p).producesAll());
    }
}

