/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.semantics.engine.Choicepoint;
import com.yahoo.prelude.semantics.engine.Evaluation;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.ReferencedMatches;
import com.yahoo.prelude.semantics.rule.Condition;
import com.yahoo.prelude.semantics.rule.ProductionRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuleEvaluation {
    private List<FlattenedItem> items;
    private int position;
    private int startPosition;
    private Set<String> matchReferences;
    private String currentContext;
    private final List<ReferencedMatches> referencedMatchesList = new ArrayList<ReferencedMatches>();
    private final List<Match> nonreferencedMatches = new ArrayList<Match>();
    private final Evaluation evaluation;
    private Deque<Choicepoint> choicepoints = null;
    private Object value = null;
    private boolean inNegation = false;
    private String currentLabel = null;

    public RuleEvaluation(Evaluation owner) {
        this.evaluation = owner;
    }

    public void initialize(List<FlattenedItem> list, int startPosition) {
        this.startPosition = startPosition;
        this.items = list;
        this.reinitialize();
    }

    void reinitialize() {
        this.position = this.startPosition;
        this.currentContext = null;
        this.referencedMatchesList.clear();
        this.nonreferencedMatches.clear();
        if (this.choicepoints != null) {
            this.choicepoints.clear();
        }
    }

    public void setMatchReferences(Set<String> matchReferences) {
        this.matchReferences = matchReferences;
    }

    int calculateMatchDigest(ProductionRule rule) {
        int matchDigest = rule.hashCode();
        int matchCounter = 1;
        for (ReferencedMatches matches : this.referencedMatchesList) {
            int termCounter = 0;
            Iterator<Match> j = matches.matchIterator();
            while (j.hasNext()) {
                Match match = j.next();
                matchDigest = 7 * matchDigest * matchCounter + 71 * termCounter + match.hashCode();
                ++termCounter;
            }
            ++matchCounter;
        }
        for (Match match : this.nonreferencedMatches) {
            matchDigest = 7 * matchDigest * matchCounter + match.hashCode();
            ++matchCounter;
        }
        return matchDigest;
    }

    public FlattenedItem currentItem() {
        if (this.position >= this.items.size()) {
            return null;
        }
        return this.items.get(this.position);
    }

    public FlattenedItem previousItem() {
        if (this.position - 1 < 0) {
            return null;
        }
        return this.items.get(this.position - 1);
    }

    public int currentPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int itemCount() {
        return this.items.size() - this.startPosition;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isInNegation() {
        return this.inNegation;
    }

    public void setInNegation(boolean inNegation) {
        this.inNegation = inNegation;
    }

    public int getPosition() {
        return this.position;
    }

    public void setCurrentLabel(String currentLabel) {
        this.currentLabel = currentLabel;
    }

    public String getCurrentLabel() {
        return this.currentLabel;
    }

    public FlattenedItem next() {
        ++this.position;
        if (this.position >= this.items.size()) {
            this.position = this.items.size();
            return null;
        }
        return this.items.get(this.position);
    }

    public void entering(String context) {
        if (context == null) {
            return;
        }
        if (this.matchReferences != null && this.matchReferences.contains(context)) {
            this.currentContext = context;
        }
    }

    public void leaving(String context) {
        if (context == null) {
            return;
        }
        if (this.currentContext == null) {
            return;
        }
        if (this.currentContext.equals(context)) {
            this.currentContext = null;
        }
    }

    public void addMatch(FlattenedItem item, String replaceString) {
        this.evaluation.makeParentMutable(item.getItem());
        Match match = new Match(item, replaceString);
        if (this.currentContext != null) {
            ReferencedMatches matches = this.getReferencedMatches(this.currentContext);
            if (matches == null) {
                matches = new ReferencedMatches(this.currentContext);
                this.referencedMatchesList.add(matches);
            }
            matches.addMatch(match);
        } else {
            this.nonreferencedMatches.add(match);
        }
    }

    public ReferencedMatches getReferencedMatches(String name) {
        for (ReferencedMatches matches : this.referencedMatchesList) {
            if (!name.equals(matches.getContextName())) continue;
            return matches;
        }
        return null;
    }

    public int getReferencedMatchCount() {
        return this.referencedMatchesList.size();
    }

    public int getNonreferencedMatchCount() {
        return this.nonreferencedMatches.size();
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    public void addItems(List<Item> items, TermType termType) {
        items.forEach(item -> this.evaluation.addItem((Item)item, termType));
    }

    public void removeItem(Item item) {
        this.evaluation.removeItem(item);
    }

    public void removeItemByIdentity(Item item) {
        this.evaluation.removeItemByIdentity(item);
    }

    public void removeItem(int position, Item item) {
        this.evaluation.removeItem(position, item);
    }

    public void insertItems(List<Item> items, CompositeItem parent, int index, TermType termType, boolean replacing) {
        this.evaluation.insertItems(items, parent, index, termType, replacing);
    }

    public List<FlattenedItem> items() {
        return Collections.unmodifiableList(this.items);
    }

    public Match getNonreferencedMatch(int index) {
        return this.nonreferencedMatches.get(index);
    }

    public void trace(int level, String string) {
        this.evaluation.trace(level, string);
    }

    public int getTraceLevel() {
        return this.evaluation.getTraceLevel();
    }

    public void indentTrace() {
        this.evaluation.indentTrace();
    }

    public void unindentTrace() {
        this.evaluation.unindentTrace();
    }

    public Choicepoint getChoicepoint(Condition condition, boolean create) {
        Choicepoint choicepoint;
        if (this.choicepoints == null) {
            if (!create) {
                return null;
            }
            this.choicepoints = new ArrayDeque<Choicepoint>();
        }
        if ((choicepoint = this.lookupChoicepoint(condition)) == null) {
            if (!create) {
                return null;
            }
            choicepoint = new Choicepoint(this, condition);
            this.choicepoints.push(choicepoint);
        }
        return choicepoint;
    }

    private Choicepoint lookupChoicepoint(Condition condition) {
        for (Choicepoint choicepoint : this.choicepoints) {
            if (condition != choicepoint.getCondition()) continue;
            return choicepoint;
        }
        return null;
    }

    List<ReferencedMatches> referencedMatches() {
        return this.referencedMatchesList;
    }

    List<Match> nonreferencedMatches() {
        return this.nonreferencedMatches;
    }

    public void removeMatches(ReferencedMatches matches) {
        Iterator<Match> i = matches.matchIterator();
        while (i.hasNext()) {
            Match match = i.next();
            this.removeItemByIdentity(match.getItem());
        }
    }
}

