/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.InItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class StringInItem
extends InItem {
    private Set<String> tokens;

    public StringInItem(String indexName) {
        super(indexName);
        this.tokens = new HashSet<String>(1000);
    }

    public StringInItem(String indexName, Set<String> tokens) {
        super(indexName);
        this.tokens = new HashSet<String>(tokens);
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.STRING_IN;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        return 1;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.tokens.size(), (ByteBuffer)buffer);
        StringInItem.putString(this.getIndexName(), buffer);
        for (String entry : this.tokens) {
            StringInItem.putString(entry, buffer);
        }
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.getIndexName());
        buffer.append("{");
        for (String entry : this.tokens) {
            buffer.append("\"");
            buffer.append(entry);
            buffer.append("\",");
        }
        if (!this.tokens.isEmpty()) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
    }

    public void addToken(String token) {
        Objects.requireNonNull(token, "Token string must not be null");
        this.tokens.add(token);
    }

    public void removeToken(String token) {
        this.tokens.remove(token);
    }

    public Collection<String> getTokens() {
        return Set.copyOf(this.tokens);
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        for (String token : this.tokens) {
            discloser.addChild(new WordItem(token));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringInItem other = (StringInItem)o;
        return Objects.equals(this.tokens, other.tokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokens);
    }

    @Override
    public StringInItem clone() {
        StringInItem clone = (StringInItem)super.clone();
        clone.tokens = new HashSet<String>(this.tokens);
        return clone;
    }
}

