/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.SearchDefinition;
import com.yahoo.search.config.IndexInfoConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class IndexModel {
    private static final Logger log = Logger.getLogger(IndexModel.class.getName());
    private final Map<String, List<String>> masterClusters;
    private final Map<String, SearchDefinition> searchDefinitions;
    private final SearchDefinition unionSearchDefinition;

    public IndexModel(SearchDefinition searchDefinition) {
        this(Map.of(), List.of(searchDefinition));
    }

    public IndexModel(Map<String, List<String>> masterClusters, Collection<SearchDefinition> searchDefinitions) {
        this.masterClusters = masterClusters;
        this.searchDefinitions = new LinkedHashMap<String, SearchDefinition>();
        this.unionSearchDefinition = this.unionOf(searchDefinitions);
        for (SearchDefinition sd : searchDefinitions) {
            this.searchDefinitions.put(sd.getName(), sd);
        }
    }

    public IndexModel(IndexInfoConfig indexInfo, QrSearchersConfig clusters) {
        this(indexInfo, IndexModel.toClusters(clusters));
    }

    public IndexModel(IndexInfoConfig indexInfo, Map<String, List<String>> clusters) {
        if (indexInfo != null) {
            this.searchDefinitions = IndexModel.toSearchDefinitions(indexInfo);
            this.unionSearchDefinition = this.unionOf(this.searchDefinitions.values());
        } else {
            this.searchDefinitions = Map.of();
            this.unionSearchDefinition = null;
        }
        this.masterClusters = clusters;
    }

    private static Map<String, List<String>> toClusters(QrSearchersConfig config) {
        if (config == null) {
            return Map.of();
        }
        HashMap<String, List<String>> clusters = new HashMap<String, List<String>>();
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            clusters.put(searchCluster.name(), searchCluster.searchdef());
        }
        return clusters;
    }

    private static Map<String, SearchDefinition> toSearchDefinitions(IndexInfoConfig c) {
        SearchDefinition sd;
        HashMap<String, SearchDefinition> searchDefinitions = new HashMap<String, SearchDefinition>();
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = new SearchDefinition(info.name());
            for (IndexInfoConfig.Indexinfo.Command command : info.command()) {
                sd.addCommand(command.indexname(), command.command());
            }
            searchDefinitions.put(info.name(), sd);
        }
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = (SearchDefinition)searchDefinitions.get(info.name());
            for (IndexInfoConfig.Indexinfo.Alias alias : info.alias()) {
                String aliasString = alias.alias();
                String indexString = alias.indexname();
                sd.addAlias(aliasString, indexString);
            }
        }
        return searchDefinitions;
    }

    private SearchDefinition unionOf(Collection<SearchDefinition> searchDefinitions) {
        SearchDefinition union = new SearchDefinition("unionOfAllKnown");
        for (SearchDefinition sd : searchDefinitions) {
            for (Index index : sd.indices().values()) {
                union.getOrCreateIndex(index.getName());
                for (String command : index.allCommands()) {
                    union.addCommand(index.getName(), command);
                }
                for (String alias : index.aliases()) {
                    try {
                        union.addAlias(alias, index.getName());
                    }
                    catch (IllegalArgumentException e) {
                        log.fine("Conflicting alias '" + alias + " of " + index + " in " + sd + " will not take effect for queries which does not specify that search definition");
                    }
                }
            }
        }
        return union;
    }

    public Map<String, List<String>> getMasterClusters() {
        return this.masterClusters;
    }

    public Map<String, SearchDefinition> getSearchDefinitions() {
        return this.searchDefinitions;
    }

    SearchDefinition getUnionSearchDefinition() {
        return this.unionSearchDefinition;
    }
}

