/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexModel;
import com.yahoo.prelude.SearchDefinition;
import com.yahoo.search.Query;
import com.yahoo.text.Lowercase;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IndexFacts {
    private final Map<String, SearchDefinition> searchDefinitions;
    private final Map<String, List<String>> clusters;
    static final String unionName = "unionOfAllKnown";
    private SearchDefinition unionSearchDefinition = new SearchDefinition("unionOfAllKnown");
    private boolean frozen;
    private boolean hasNGramIndices;

    public IndexFacts() {
        this.searchDefinitions = Map.of();
        this.clusters = Map.of();
    }

    public IndexFacts(IndexModel indexModel) {
        this.searchDefinitions = indexModel.getSearchDefinitions();
        if (indexModel.getUnionSearchDefinition() != null) {
            this.unionSearchDefinition = indexModel.getUnionSearchDefinition();
        }
        this.clusters = indexModel.getMasterClusters();
    }

    private boolean notInitialized() {
        return this.searchDefinitions.isEmpty();
    }

    private boolean isIndexFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (this.notInitialized()) {
            return true;
        }
        if (documentTypes.isEmpty()) {
            return this.unionSearchDefinition.getIndex(indexName) != null;
        }
        DocumentTypeListOffset sd = this.chooseSearchDefinition(documentTypes, 0);
        while (sd != null) {
            Index index = sd.searchDefinition.getIndex(indexName);
            if (index != null) {
                return true;
            }
            sd = this.chooseSearchDefinition(documentTypes, sd.offset);
        }
        return false;
    }

    private String getCanonicNameFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (documentTypes.isEmpty()) {
            Index index = this.unionSearchDefinition.getIndex(indexName);
            if (index == null) {
                index = this.unionSearchDefinition.getIndexByLowerCase(Lowercase.toLowerCase((String)indexName));
            }
            return index == null ? indexName : index.getName();
        }
        TreeSet<String> gotNames = new TreeSet<String>();
        for (String dt : documentTypes) {
            SearchDefinition sd = this.searchDefinitions.get(dt);
            if (sd == null) continue;
            Index index = sd.getIndex(indexName);
            if (index == null) {
                index = sd.getIndexByLowerCase(Lowercase.toLowerCase((String)indexName));
            }
            if (index == null) continue;
            gotNames.add(index.getName());
        }
        if (gotNames.size() == 1) {
            return (String)gotNames.iterator().next();
        }
        return indexName;
    }

    private Index getIndexFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (indexName == null || indexName.isEmpty()) {
            indexName = "default";
        }
        return this.getIndexByCanonicNameFromDocumentTypes(indexName, documentTypes);
    }

    private Index getIndexByCanonicNameFromDocumentTypes(String canonicName, List<String> documentTypes) {
        if (documentTypes.isEmpty()) {
            Index index = this.unionSearchDefinition.getIndex(canonicName);
            return index != null ? index : Index.nullIndex;
        }
        DocumentTypeListOffset sd = this.chooseSearchDefinition(documentTypes, 0);
        while (sd != null) {
            Index index = sd.searchDefinition.getIndex(canonicName);
            if (index != null) {
                return index;
            }
            sd = this.chooseSearchDefinition(documentTypes, sd.offset);
        }
        return Index.nullIndex;
    }

    private Collection<Index> getIndexes(String documentType) {
        SearchDefinition sd = this.searchDefinitions.get(documentType);
        return sd != null ? sd.indices().values() : List.of();
    }

    private Set<String> resolveDocumentTypes(Query query) {
        return this.resolveDocumentTypes(query.getModel().getSources(), query.getModel().getRestrict(), this.searchDefinitions.keySet());
    }

    private Set<String> resolveDocumentTypes(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
        sources = this.emptyCollectionIfNull(sources);
        restrict = this.emptyCollectionIfNull(restrict);
        if (sources.isEmpty()) {
            if (!restrict.isEmpty()) {
                return new TreeSet<String>(restrict);
            }
            return candidateDocumentTypes;
        }
        TreeSet<String> toSearch = new TreeSet<String>();
        for (String source : sources) {
            List<String> clusterDocTypes = this.clusters.get(source);
            if (clusterDocTypes == null) {
                if (!candidateDocumentTypes.contains(source)) continue;
                toSearch.add(source);
                continue;
            }
            for (String documentType : clusterDocTypes) {
                if (!candidateDocumentTypes.contains(documentType)) continue;
                toSearch.add(documentType);
            }
        }
        if (!restrict.isEmpty()) {
            toSearch.retainAll(restrict);
        }
        return toSearch;
    }

    private Collection<String> emptyCollectionIfNull(Collection<String> collection) {
        return collection == null ? List.of() : collection;
    }

    private DocumentTypeListOffset chooseSearchDefinition(List<String> documentTypes, int index) {
        while (index < documentTypes.size()) {
            String docName;
            SearchDefinition sd;
            if ((sd = this.searchDefinitions.get(docName = documentTypes.get(index++))) == null) continue;
            return new DocumentTypeListOffset(index, sd);
        }
        return null;
    }

    public IndexFacts freeze() {
        this.hasNGramIndices = this.hasNGramIndices();
        this.frozen = true;
        return this;
    }

    public boolean hasNGramIndices() {
        if (this.frozen) {
            return this.hasNGramIndices;
        }
        for (Map.Entry<String, SearchDefinition> searchDefinition : this.searchDefinitions.entrySet()) {
            for (Index index : searchDefinition.getValue().indices().values()) {
                if (!index.isNGram()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String getDefaultPosition(String sdName) {
        SearchDefinition sd;
        if (sdName == null) {
            sd = this.unionSearchDefinition;
        } else if (this.searchDefinitions.containsKey(sdName)) {
            sd = this.searchDefinitions.get(sdName);
        } else {
            return null;
        }
        return sd.getDefaultPosition();
    }

    public Session newSession(Query query) {
        return new Session(query);
    }

    public Session newSession(Collection<String> sources, Collection<String> restrict) {
        return new Session(sources, restrict);
    }

    public Session newSession(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
        return new Session(sources, restrict, candidateDocumentTypes);
    }

    private record DocumentTypeListOffset(int offset, SearchDefinition searchDefinition) {
    }

    public class Session {
        private final List<String> documentTypes;

        private Session(Query query) {
            this.documentTypes = List.copyOf(IndexFacts.this.resolveDocumentTypes(query));
        }

        private Session(Collection<String> sources, Collection<String> restrict) {
            this.documentTypes = List.copyOf(IndexFacts.this.resolveDocumentTypes(sources, restrict, IndexFacts.this.searchDefinitions.keySet()));
        }

        private Session(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
            this.documentTypes = List.copyOf(IndexFacts.this.resolveDocumentTypes(sources, restrict, candidateDocumentTypes));
        }

        public Index getIndex(String indexName) {
            return IndexFacts.this.getIndexFromDocumentTypes(indexName, this.documentTypes);
        }

        public Index getIndex(String indexName, String documentType) {
            return IndexFacts.this.getIndexFromDocumentTypes(indexName, List.of(documentType));
        }

        public Collection<Index> getIndexes(String documentType) {
            return IndexFacts.this.getIndexes(documentType);
        }

        public String getCanonicName(String indexName) {
            return IndexFacts.this.getCanonicNameFromDocumentTypes(indexName, this.documentTypes);
        }

        public boolean isIndex(String indexName) {
            return IndexFacts.this.isIndexFromDocumentTypes(indexName, this.documentTypes);
        }

        public List<String> documentTypes() {
            return this.documentTypes;
        }

        public String toString() {
            return "index facts for search definitions " + this.documentTypes;
        }
    }
}

