/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.OperatorTypeChecker;
import java.util.List;
import java.util.Set;

class OperatorNodeListTypeChecker
extends OperatorTypeChecker {
    private final Class<? extends Operator> operatorType;
    private final Set<? extends Operator> operators;

    public OperatorNodeListTypeChecker(Operator parent, int idx, Class<? extends Operator> operatorType, Set<? extends Operator> operators) {
        super(parent, idx);
        this.operatorType = operatorType;
        this.operators = operators;
    }

    @Override
    public void check(Object argument) {
        Preconditions.checkNotNull((Object)argument, (String)"Argument %s of %s must not be null", (int)this.idx, (Object)this.parent);
        Preconditions.checkArgument((boolean)(argument instanceof List), (String)"Argument %s of %s must be a List<OperatorNode<%s>>", (Object)this.idx, (Object)this.parent, (Object)this.operatorType.getName(), argument.getClass());
        List lst = (List)argument;
        for (OperatorNode node : lst) {
            Object op = node.getOperator();
            Preconditions.checkArgument((boolean)this.operatorType.isInstance(op), (String)"Argument %s of %s must contain only OperatorNode<%s> (is: %s).", (Object)this.idx, (Object)this.parent, (Object)this.operatorType.getName(), op.getClass());
            if (this.operators.isEmpty()) continue;
            Preconditions.checkArgument((boolean)this.operators.contains(op), (String)"Argument %s of %s must contain only %s (is %s).", (Object)this.idx, (Object)this.parent, (Object)Joiner.on((String)"|").join(this.operators), op);
        }
    }
}

