/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.request.parser.TokenMgrException;
import com.yahoo.search.querytransform.BooleanAttributeParser;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.math.BigInteger;

@After(value={"Stemming", "AccentRemoval"})
@Provides(value={"predicate"})
public class BooleanSearcher
extends Searcher {
    private static final CompoundName FIELD = new CompoundName("boolean.field");
    private static final CompoundName ATTRIBUTES = new CompoundName("boolean.attributes");
    private static final CompoundName RANGE_ATTRIBUTES = new CompoundName("boolean.rangeAttributes");
    public static final String PREDICATE = "predicate";

    @Override
    public Result search(Query query, Execution execution) {
        String fieldName = query.properties().getString(FIELD);
        if (fieldName != null) {
            return this.search(query, execution, fieldName);
        }
        if (query.getTrace().isTraceable(5)) {
            query.trace("BooleanSearcher: Nothing added to query", false, 5);
        }
        return execution.search(query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result search(Query query, Execution execution, String fieldName) {
        String attributes = query.properties().getString(ATTRIBUTES);
        String rangeAttributes = query.properties().getString(RANGE_ATTRIBUTES);
        if (query.getTrace().isTraceable(5)) {
            query.trace("BooleanSearcher: fieldName(" + fieldName + "), attributes(" + attributes + "), rangeAttributes(" + rangeAttributes + ")", false, 5);
        }
        if (attributes != null || rangeAttributes != null) {
            try {
                this.addPredicateTerm(query, fieldName, attributes, rangeAttributes);
                if (!query.getTrace().isTraceable(4)) return execution.search(query);
                query.trace("BooleanSearcher: Added boolean operator", true, 4);
                return execution.search(query);
            }
            catch (TokenMgrException e) {
                return new Result(query, ErrorMessage.createInvalidQueryParameter(Exceptions.toMessageString((Throwable)e)));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalInputException("Failed boolean search on field '" + fieldName + "'", (Throwable)e);
            }
        } else {
            if (!query.getTrace().isTraceable(5)) return execution.search(query);
            query.trace("BooleanSearcher: Nothing added to query", false, 5);
        }
        return execution.search(query);
    }

    private void addPredicateTerm(Query query, String fieldName, String attributes, String rangeAttributes) {
        PredicateQueryItem item = new PredicateQueryItem();
        item.setIndexName(fieldName);
        new PredicateValueAttributeParser(item).parse(attributes);
        new PredicateRangeAttributeParser(item).parse(rangeAttributes);
        query.getModel().getQueryTree().and(item);
    }

    public static class PredicateValueAttributeParser
    extends BooleanAttributeParser {
        private final PredicateQueryItem item;

        public PredicateValueAttributeParser(PredicateQueryItem item) {
            this.item = item;
        }

        @Override
        protected void addAttribute(String attribute, String value) {
            this.item.addFeature(attribute, value);
        }

        @Override
        protected void addAttribute(String attribute, String value, BigInteger subQueryMask) {
            this.item.addFeature(attribute, value, subQueryMask.longValue());
        }
    }

    private static class PredicateRangeAttributeParser
    extends BooleanAttributeParser {
        private final PredicateQueryItem item;

        public PredicateRangeAttributeParser(PredicateQueryItem item) {
            this.item = item;
        }

        @Override
        protected void addAttribute(String attribute, String value) {
            this.item.addRangeFeature(attribute, Long.parseLong(value));
        }

        @Override
        protected void addAttribute(String attribute, String value, BigInteger subQueryMask) {
            this.item.addRangeFeature(attribute, Long.parseLong(value), subQueryMask.longValue());
        }
    }
}

