/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.google.common.collect.ImmutableList;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.types.FieldType;
import java.util.Arrays;
import java.util.List;

public class FieldDescription
implements Comparable<FieldDescription> {
    private final CompoundName name;
    private final FieldType type;
    private final List<String> aliases;
    private final boolean mandatory;
    private final boolean overridable;

    public FieldDescription(String name, FieldType type) {
        this(name, type, false);
    }

    public FieldDescription(String name, String type) {
        this(name, FieldType.fromString(type, null));
    }

    public FieldDescription(String name, FieldType type, boolean mandatory) {
        this(name, type, mandatory, true);
    }

    public FieldDescription(String name, String type, String aliases) {
        this(name, type, aliases, false, true);
    }

    public FieldDescription(String name, FieldType type, String aliases) {
        this(name, type, aliases, false, true);
    }

    public FieldDescription(String name, String typeString, String aliases, boolean mandatory, boolean overridable) {
        this(name, FieldType.fromString(typeString, null), aliases, mandatory, overridable);
    }

    public FieldDescription(String name, FieldType type, boolean mandatory, boolean overridable) {
        this(name, type, null, mandatory, overridable);
    }

    public FieldDescription(String name, FieldType type, String aliases, boolean mandatory, boolean overridable) {
        this(new CompoundName(name), type, aliases, mandatory, overridable);
    }

    public FieldDescription(CompoundName name, FieldType type, String aliases, boolean mandatory, boolean overridable) {
        this(name, type, FieldDescription.toList(aliases), mandatory, overridable);
    }

    public FieldDescription(CompoundName name, FieldType type, List<String> aliases, boolean mandatory, boolean overridable) {
        for (String nameComponent : name.asList()) {
            QueryProfile.validateName(nameComponent);
        }
        this.name = name;
        this.type = type;
        if (name.isCompound() && !aliases.isEmpty()) {
            throw new IllegalArgumentException("Aliases are not allowed with compound names");
        }
        this.aliases = ImmutableList.copyOf(aliases);
        this.mandatory = mandatory;
        this.overridable = overridable;
    }

    private static List<String> toList(String string) {
        if (string == null || string.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(Arrays.asList(string.split(" ")));
    }

    public String getName() {
        return this.name.toString();
    }

    public CompoundName getCompoundName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    @Override
    public int compareTo(FieldDescription other) {
        return this.name.toString().compareTo(other.name.toString());
    }

    public FieldDescription withName(CompoundName name) {
        return new FieldDescription(name, this.type, this.aliases, this.mandatory, this.overridable);
    }

    public FieldDescription withType(FieldType type) {
        return new FieldDescription(this.name, type, this.aliases, this.mandatory, this.overridable);
    }

    public String toString() {
        return "field '" + this.name + "' type " + this.type.stringValue() + (this.mandatory ? " (mandatory)" : "") + (!this.overridable ? " (not overridable)" : "");
    }
}

