/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.AttributeValue;

public class AttributeMapLookupValue
extends AttributeValue {
    private final String prefix;
    private final String suffix;
    private final String key;
    private final String keySourceAttribute;

    private AttributeMapLookupValue(String attributeValue, String prefix, String suffix, String key, String keySourceAttribute) {
        super(attributeValue);
        this.prefix = prefix;
        this.suffix = suffix;
        this.key = key;
        this.keySourceAttribute = keySourceAttribute;
    }

    public static AttributeMapLookupValue fromKey(String prefix, String key, String suffix) {
        return new AttributeMapLookupValue(prefix + "{\"" + key + "\"}" + suffix, prefix, suffix, key, "");
    }

    public static AttributeMapLookupValue fromKeySourceAttribute(String prefix, String keySourceAttribute, String suffix) {
        return new AttributeMapLookupValue(prefix + "{attribute(" + keySourceAttribute + ")}" + suffix, prefix, suffix, "", keySourceAttribute);
    }

    @Override
    public AttributeMapLookupValue copy() {
        return new AttributeMapLookupValue(this.getAttributeName(), this.prefix, this.suffix, this.key, this.keySourceAttribute);
    }

    public String getKeyAttribute() {
        return this.prefix + ".key";
    }

    public String getValueAttribute() {
        return this.prefix + ".value" + this.suffix;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasKeySourceAttribute() {
        return !this.keySourceAttribute.isEmpty();
    }

    public String getKeySourceAttribute() {
        return this.keySourceAttribute;
    }
}

