/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InvokerFactory;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.rpc.RpcProtobufFillInvoker;
import com.yahoo.search.dispatch.rpc.RpcResourcePool;
import com.yahoo.search.dispatch.rpc.RpcSearchInvoker;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import java.util.Optional;

public class RpcInvokerFactory
extends InvokerFactory {
    private static final CompoundName dispatchSummaries = new CompoundName("dispatch.summaries");
    private final RpcResourcePool rpcResourcePool;

    public RpcInvokerFactory(RpcResourcePool rpcResourcePool, SearchCluster searchCluster) {
        super(searchCluster);
        this.rpcResourcePool = rpcResourcePool;
    }

    @Override
    protected Optional<SearchInvoker> createNodeSearchInvoker(VespaBackEndSearcher searcher, Query query, int maxHits, Node node) {
        return Optional.of(new RpcSearchInvoker(searcher, node, this.rpcResourcePool, maxHits));
    }

    @Override
    public FillInvoker createFillInvoker(VespaBackEndSearcher searcher, Result result) {
        Query query = result.getQuery();
        boolean summaryNeedsQuery = searcher.summaryNeedsQuery(query);
        return new RpcProtobufFillInvoker(this.rpcResourcePool, searcher.getDocumentDatabase(query), searcher.getServerId(), summaryNeedsQuery);
    }
}

