/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.compress.CompressionType;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.search.dispatch.rpc.Client;

class RpcClient
implements Client {
    private final Supervisor supervisor;

    public RpcClient(String name, int transportThreads) {
        this.supervisor = new Supervisor(new Transport(name, transportThreads));
    }

    @Override
    public void close() {
        this.supervisor.transport().shutdown().join();
    }

    @Override
    public Client.NodeConnection createConnection(String hostname, int port) {
        return new RpcNodeConnection(hostname, port, this.supervisor);
    }

    private static class RpcNodeConnection
    implements Client.NodeConnection {
        private final Supervisor supervisor;
        private final String hostname;
        private final int port;
        private final String description;
        private Target target;

        public RpcNodeConnection(String hostname, int port, Supervisor supervisor) {
            this.supervisor = supervisor;
            this.hostname = hostname;
            this.port = port;
            this.description = "rpc node connection to " + hostname + ":" + port;
            this.target = supervisor.connect(new Spec(hostname, port));
        }

        @Override
        public void request(String rpcMethod, CompressionType compression, int uncompressedLength, byte[] compressedPayload, Client.ResponseReceiver responseReceiver, double timeoutSeconds) {
            Request request = new Request(rpcMethod);
            request.parameters().add((Value)new Int8Value(compression.getCode()));
            request.parameters().add((Value)new Int32Value(uncompressedLength));
            request.parameters().add((Value)new DataValue(compressedPayload));
            this.invokeAsync(request, timeoutSeconds, new RpcProtobufResponseWaiter(this, responseReceiver));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeAsync(Request req, double timeout, RequestWaiter waiter) {
            RpcNodeConnection rpcNodeConnection = this;
            synchronized (rpcNodeConnection) {
                if (!this.target.isValid()) {
                    this.target = this.supervisor.connect(new Spec(this.hostname, this.port));
                }
            }
            this.target.invokeAsync(req, timeout, waiter);
        }

        @Override
        public void close() {
            this.target.close();
        }

        public String toString() {
            return this.description;
        }
    }

    private static class RpcProtobufResponseWaiter
    implements RequestWaiter {
        private final RpcNodeConnection node;
        private final Client.ResponseReceiver handler;

        public RpcProtobufResponseWaiter(RpcNodeConnection node, Client.ResponseReceiver handler) {
            this.node = node;
            this.handler = handler;
        }

        public void handleRequestDone(Request requestWithResponse) {
            if (requestWithResponse.isError()) {
                this.handler.receive(Client.ResponseOrError.fromError("Error response from " + this.node + ": " + requestWithResponse.errorMessage()));
                return;
            }
            Values returnValues = requestWithResponse.returnValues();
            if (returnValues.size() < 3) {
                this.handler.receive(Client.ResponseOrError.fromError("Invalid getDocsums response from " + this.node + ": Expected 3 return arguments, got " + returnValues.size()));
                return;
            }
            byte compression = returnValues.get(0).asInt8();
            int uncompressedSize = returnValues.get(1).asInt32();
            byte[] compressedPayload = returnValues.get(2).asData();
            this.handler.receive(Client.ResponseOrError.fromResponse(new Client.ProtobufResponse(compression, uncompressedSize, compressedPayload)));
        }
    }
}

