/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class QrStartConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "613417f1b0dfbabea1e583cd090b1f60";
    public static final String CONFIG_DEF_NAME = "qr-start";
    public static final String CONFIG_DEF_NAMESPACE = "search.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.config", "jvm.server bool default=true restart", "jvm.verbosegc bool default=true restart", "jvm.gcopts string default=\"-XX:+UseG1GC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1\" restart", "jvm.heapsize int default=1536 restart", "jvm.minHeapsize int default=1536 restart", "jvm.stacksize int default=512 restart", "jvm.compressedClassSpaceSize int default=32 restart", "jvm.baseMaxDirectMemorySize int default=16 restart", "jvm.directMemorySizeCache int default=0 restart", "jvm.heapSizeAsPercentageOfPhysicalMemory int default=0 restart", "jvm.availableProcessors int default=0 restart", "qrs.env string default=\"\" restart", "ulimitv string default=\"\" restart", "jdisc.classpath_extra string default=\"\" restart", "jdisc.export_packages string default=\"\" restart"};
    private final Jvm jvm;
    private final Qrs qrs;
    private final StringNode ulimitv;
    private final Jdisc jdisc;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public QrStartConfig(Builder builder) {
        this(builder, true);
    }

    private QrStartConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-start must be initialized: " + builder.__uninitialized);
        }
        this.jvm = new Jvm(builder.jvm, throwIfUninitialized);
        this.qrs = new Qrs(builder.qrs, throwIfUninitialized);
        this.ulimitv = builder.ulimitv == null ? new StringNode("") : new StringNode(builder.ulimitv);
        this.jdisc = new Jdisc(builder.jdisc, throwIfUninitialized);
    }

    public Jvm jvm() {
        return this.jvm;
    }

    public Qrs qrs() {
        return this.qrs;
    }

    public String ulimitv() {
        return this.ulimitv.value();
    }

    public Jdisc jdisc() {
        return this.jdisc;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrStartConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.mergeChanges("jvm", this.jvm.getChangesRequiringRestart(newConfig.jvm));
        changes.mergeChanges("qrs", this.qrs.getChangesRequiringRestart(newConfig.qrs));
        changes.compare((Node)this.ulimitv, (Node)newConfig.ulimitv, "ulimitv", "Set ulimit -v in start script? this is mainly a safeguard against JNI stuff leaking memory.");
        changes.mergeChanges("jdisc", this.jdisc.getChangesRequiringRestart(newConfig.jdisc));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Jvm.Builder jvm = new Jvm.Builder();
        public Qrs.Builder qrs = new Qrs.Builder();
        private String ulimitv = null;
        public Jdisc.Builder jdisc = new Jdisc.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(QrStartConfig config) {
            this.jvm(new Jvm.Builder(config.jvm()));
            this.qrs(new Qrs.Builder(config.qrs()));
            this.ulimitv(config.ulimitv());
            this.jdisc(new Jdisc.Builder(config.jdisc()));
        }

        private Builder override(Builder __superior) {
            this.jvm(this.jvm.override(__superior.jvm));
            this.qrs(this.qrs.override(__superior.qrs));
            if (__superior.ulimitv != null) {
                this.ulimitv(__superior.ulimitv);
            }
            this.jdisc(this.jdisc.override(__superior.jdisc));
            return this;
        }

        public Builder jvm(Jvm.Builder __builder) {
            this.jvm = __builder;
            return this;
        }

        public Builder jvm(Consumer<Jvm.Builder> __func) {
            Jvm.Builder __inner = new Jvm.Builder();
            __func.accept(__inner);
            this.jvm = __inner;
            return this;
        }

        public Builder qrs(Qrs.Builder __builder) {
            this.qrs = __builder;
            return this;
        }

        public Builder qrs(Consumer<Qrs.Builder> __func) {
            Qrs.Builder __inner = new Qrs.Builder();
            __func.accept(__inner);
            this.qrs = __inner;
            return this;
        }

        public Builder ulimitv(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.ulimitv = __value;
            return this;
        }

        public Builder jdisc(Jdisc.Builder __builder) {
            this.jdisc = __builder;
            return this;
        }

        public Builder jdisc(Consumer<Jdisc.Builder> __func) {
            Jdisc.Builder __inner = new Jdisc.Builder();
            __func.accept(__inner);
            this.jdisc = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrStartConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrStartConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrStartConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public QrStartConfig build() {
            return new QrStartConfig(this);
        }
    }

    public static final class Jvm
    extends InnerNode {
        private final BooleanNode server;
        private final BooleanNode verbosegc;
        private final StringNode gcopts;
        private final IntegerNode heapsize;
        private final IntegerNode minHeapsize;
        private final IntegerNode stacksize;
        private final IntegerNode compressedClassSpaceSize;
        private final IntegerNode baseMaxDirectMemorySize;
        private final IntegerNode directMemorySizeCache;
        private final IntegerNode heapSizeAsPercentageOfPhysicalMemory;
        private final IntegerNode availableProcessors;

        public Jvm(Builder builder) {
            this(builder, true);
        }

        private Jvm(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-start.jvm must be initialized: " + builder.__uninitialized);
            }
            this.server = builder.server == null ? new BooleanNode(true) : new BooleanNode(builder.server.booleanValue());
            this.verbosegc = builder.verbosegc == null ? new BooleanNode(true) : new BooleanNode(builder.verbosegc.booleanValue());
            this.gcopts = builder.gcopts == null ? new StringNode("-XX:+UseG1GC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1") : new StringNode(builder.gcopts);
            this.heapsize = builder.heapsize == null ? new IntegerNode(1536) : new IntegerNode(builder.heapsize.intValue());
            this.minHeapsize = builder.minHeapsize == null ? new IntegerNode(1536) : new IntegerNode(builder.minHeapsize.intValue());
            this.stacksize = builder.stacksize == null ? new IntegerNode(512) : new IntegerNode(builder.stacksize.intValue());
            this.compressedClassSpaceSize = builder.compressedClassSpaceSize == null ? new IntegerNode(32) : new IntegerNode(builder.compressedClassSpaceSize.intValue());
            this.baseMaxDirectMemorySize = builder.baseMaxDirectMemorySize == null ? new IntegerNode(16) : new IntegerNode(builder.baseMaxDirectMemorySize.intValue());
            this.directMemorySizeCache = builder.directMemorySizeCache == null ? new IntegerNode(0) : new IntegerNode(builder.directMemorySizeCache.intValue());
            this.heapSizeAsPercentageOfPhysicalMemory = builder.heapSizeAsPercentageOfPhysicalMemory == null ? new IntegerNode(0) : new IntegerNode(builder.heapSizeAsPercentageOfPhysicalMemory.intValue());
            this.availableProcessors = builder.availableProcessors == null ? new IntegerNode(0) : new IntegerNode(builder.availableProcessors.intValue());
        }

        public boolean server() {
            return this.server.value();
        }

        public boolean verbosegc() {
            return this.verbosegc.value();
        }

        public String gcopts() {
            return this.gcopts.value();
        }

        public int heapsize() {
            return this.heapsize.value();
        }

        public int minHeapsize() {
            return this.minHeapsize.value();
        }

        public int stacksize() {
            return this.stacksize.value();
        }

        public int compressedClassSpaceSize() {
            return this.compressedClassSpaceSize.value();
        }

        public int baseMaxDirectMemorySize() {
            return this.baseMaxDirectMemorySize.value();
        }

        public int directMemorySizeCache() {
            return this.directMemorySizeCache.value();
        }

        public int heapSizeAsPercentageOfPhysicalMemory() {
            return this.heapSizeAsPercentageOfPhysicalMemory.value();
        }

        public int availableProcessors() {
            return this.availableProcessors.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Jvm newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("jvm");
            changes.compare((Node)this.server, (Node)newConfig.server, "server", "Server or client VM");
            changes.compare((Node)this.verbosegc, (Node)newConfig.verbosegc, "verbosegc", "Debug logging of Garbage Collection");
            changes.compare((Node)this.gcopts, (Node)newConfig.gcopts, "gcopts", "Garbage Collection tuning parameters");
            changes.compare((Node)this.heapsize, (Node)newConfig.heapsize, "heapsize", "Heap size (in megabytes) for the Java VM");
            changes.compare((Node)this.minHeapsize, (Node)newConfig.minHeapsize, "minHeapsize", "Min heapsize (in megabytes) for the Java VM");
            changes.compare((Node)this.stacksize, (Node)newConfig.stacksize, "stacksize", "Stack size (in kilobytes)");
            changes.compare((Node)this.compressedClassSpaceSize, (Node)newConfig.compressedClassSpaceSize, "compressedClassSpaceSize", "CompressedOOps size in megabytes");
            changes.compare((Node)this.baseMaxDirectMemorySize, (Node)newConfig.baseMaxDirectMemorySize, "baseMaxDirectMemorySize", "Base value of maximum direct memory size (in megabytes)");
            changes.compare((Node)this.directMemorySizeCache, (Node)newConfig.directMemorySizeCache, "directMemorySizeCache", "Amount of direct memory used for caching. (in megabytes)");
            changes.compare((Node)this.heapSizeAsPercentageOfPhysicalMemory, (Node)newConfig.heapSizeAsPercentageOfPhysicalMemory, "heapSizeAsPercentageOfPhysicalMemory", "Set heap size as this percentage of available RAM, instead of absolute\nvalue above. Setting outside [1, 99] disables this setting.");
            changes.compare((Node)this.availableProcessors, (Node)newConfig.availableProcessors, "availableProcessors", "Number of processors available, can be used to set -XX:ActiveProcessorCount if set to non-zero.\nIn that case will be the number returned by the JVM when calling Runtime.getRuntime().availableProcessors()");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean server = null;
            private Boolean verbosegc = null;
            private String gcopts = null;
            private Integer heapsize = null;
            private Integer minHeapsize = null;
            private Integer stacksize = null;
            private Integer compressedClassSpaceSize = null;
            private Integer baseMaxDirectMemorySize = null;
            private Integer directMemorySizeCache = null;
            private Integer heapSizeAsPercentageOfPhysicalMemory = null;
            private Integer availableProcessors = null;

            public Builder() {
            }

            public Builder(Jvm config) {
                this.server(config.server());
                this.verbosegc(config.verbosegc());
                this.gcopts(config.gcopts());
                this.heapsize(config.heapsize());
                this.minHeapsize(config.minHeapsize());
                this.stacksize(config.stacksize());
                this.compressedClassSpaceSize(config.compressedClassSpaceSize());
                this.baseMaxDirectMemorySize(config.baseMaxDirectMemorySize());
                this.directMemorySizeCache(config.directMemorySizeCache());
                this.heapSizeAsPercentageOfPhysicalMemory(config.heapSizeAsPercentageOfPhysicalMemory());
                this.availableProcessors(config.availableProcessors());
            }

            private Builder override(Builder __superior) {
                if (__superior.server != null) {
                    this.server(__superior.server);
                }
                if (__superior.verbosegc != null) {
                    this.verbosegc(__superior.verbosegc);
                }
                if (__superior.gcopts != null) {
                    this.gcopts(__superior.gcopts);
                }
                if (__superior.heapsize != null) {
                    this.heapsize(__superior.heapsize);
                }
                if (__superior.minHeapsize != null) {
                    this.minHeapsize(__superior.minHeapsize);
                }
                if (__superior.stacksize != null) {
                    this.stacksize(__superior.stacksize);
                }
                if (__superior.compressedClassSpaceSize != null) {
                    this.compressedClassSpaceSize(__superior.compressedClassSpaceSize);
                }
                if (__superior.baseMaxDirectMemorySize != null) {
                    this.baseMaxDirectMemorySize(__superior.baseMaxDirectMemorySize);
                }
                if (__superior.directMemorySizeCache != null) {
                    this.directMemorySizeCache(__superior.directMemorySizeCache);
                }
                if (__superior.heapSizeAsPercentageOfPhysicalMemory != null) {
                    this.heapSizeAsPercentageOfPhysicalMemory(__superior.heapSizeAsPercentageOfPhysicalMemory);
                }
                if (__superior.availableProcessors != null) {
                    this.availableProcessors(__superior.availableProcessors);
                }
                return this;
            }

            public Builder server(boolean __value) {
                this.server = __value;
                return this;
            }

            private Builder server(String __value) {
                return this.server(Boolean.valueOf(__value));
            }

            public Builder verbosegc(boolean __value) {
                this.verbosegc = __value;
                return this;
            }

            private Builder verbosegc(String __value) {
                return this.verbosegc(Boolean.valueOf(__value));
            }

            public Builder gcopts(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.gcopts = __value;
                return this;
            }

            public Builder heapsize(int __value) {
                this.heapsize = __value;
                return this;
            }

            private Builder heapsize(String __value) {
                return this.heapsize(Integer.valueOf(__value));
            }

            public Builder minHeapsize(int __value) {
                this.minHeapsize = __value;
                return this;
            }

            private Builder minHeapsize(String __value) {
                return this.minHeapsize(Integer.valueOf(__value));
            }

            public Builder stacksize(int __value) {
                this.stacksize = __value;
                return this;
            }

            private Builder stacksize(String __value) {
                return this.stacksize(Integer.valueOf(__value));
            }

            public Builder compressedClassSpaceSize(int __value) {
                this.compressedClassSpaceSize = __value;
                return this;
            }

            private Builder compressedClassSpaceSize(String __value) {
                return this.compressedClassSpaceSize(Integer.valueOf(__value));
            }

            public Builder baseMaxDirectMemorySize(int __value) {
                this.baseMaxDirectMemorySize = __value;
                return this;
            }

            private Builder baseMaxDirectMemorySize(String __value) {
                return this.baseMaxDirectMemorySize(Integer.valueOf(__value));
            }

            public Builder directMemorySizeCache(int __value) {
                this.directMemorySizeCache = __value;
                return this;
            }

            private Builder directMemorySizeCache(String __value) {
                return this.directMemorySizeCache(Integer.valueOf(__value));
            }

            public Builder heapSizeAsPercentageOfPhysicalMemory(int __value) {
                this.heapSizeAsPercentageOfPhysicalMemory = __value;
                return this;
            }

            private Builder heapSizeAsPercentageOfPhysicalMemory(String __value) {
                return this.heapSizeAsPercentageOfPhysicalMemory(Integer.valueOf(__value));
            }

            public Builder availableProcessors(int __value) {
                this.availableProcessors = __value;
                return this;
            }

            private Builder availableProcessors(String __value) {
                return this.availableProcessors(Integer.valueOf(__value));
            }

            public Jvm build() {
                return new Jvm(this);
            }
        }
    }

    public static final class Qrs
    extends InnerNode {
        private final StringNode env;

        public Qrs(Builder builder) {
            this(builder, true);
        }

        private Qrs(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-start.qrs must be initialized: " + builder.__uninitialized);
            }
            this.env = builder.env == null ? new StringNode("") : new StringNode(builder.env);
        }

        public String env() {
            return this.env.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Qrs newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("qrs");
            changes.compare((Node)this.env, (Node)newConfig.env, "env", "Extra environment variables");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String env = null;

            public Builder() {
            }

            public Builder(Qrs config) {
                this.env(config.env());
            }

            private Builder override(Builder __superior) {
                if (__superior.env != null) {
                    this.env(__superior.env);
                }
                return this;
            }

            public Builder env(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.env = __value;
                return this;
            }

            public Qrs build() {
                return new Qrs(this);
            }
        }
    }

    public static final class Jdisc
    extends InnerNode {
        private final StringNode classpath_extra;
        private final StringNode export_packages;

        public Jdisc(Builder builder) {
            this(builder, true);
        }

        private Jdisc(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-start.jdisc must be initialized: " + builder.__uninitialized);
            }
            this.classpath_extra = builder.classpath_extra == null ? new StringNode("") : new StringNode(builder.classpath_extra);
            this.export_packages = builder.export_packages == null ? new StringNode("") : new StringNode(builder.export_packages);
        }

        public String classpath_extra() {
            return this.classpath_extra.value();
        }

        public String export_packages() {
            return this.export_packages.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Jdisc newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("jdisc");
            changes.compare((Node)this.classpath_extra, (Node)newConfig.classpath_extra, "classpath_extra", "Extra class path entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.");
            changes.compare((Node)this.export_packages, (Node)newConfig.export_packages, "export_packages", "Extra export packages entries, forwarded to vespa-start-container_daemon. Overrides the corresponding env setting.");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String classpath_extra = null;
            private String export_packages = null;

            public Builder() {
            }

            public Builder(Jdisc config) {
                this.classpath_extra(config.classpath_extra());
                this.export_packages(config.export_packages());
            }

            private Builder override(Builder __superior) {
                if (__superior.classpath_extra != null) {
                    this.classpath_extra(__superior.classpath_extra);
                }
                if (__superior.export_packages != null) {
                    this.export_packages(__superior.export_packages);
                }
                return this;
            }

            public Builder classpath_extra(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.classpath_extra = __value;
                return this;
            }

            public Builder export_packages(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.export_packages = __value;
                return this;
            }

            public Jdisc build() {
                return new Jdisc(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

