/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ClusterConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "a27c283f585f5ed32b75543651809a31";
    public static final String CONFIG_DEF_NAME = "cluster";
    public static final String CONFIG_DEF_NAMESPACE = "search.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.config", "clusterId int default=0", "cacheSize int default=1", "cacheTimeout double default=0", "failoverToRemote bool default=false", "clusterName string", "maxQueryTimeout double default=600", "maxQueryCacheTimeout double default=10"};
    private final IntegerNode clusterId;
    private final IntegerNode cacheSize;
    private final DoubleNode cacheTimeout;
    private final BooleanNode failoverToRemote;
    private final StringNode clusterName;
    private final DoubleNode maxQueryTimeout;
    private final DoubleNode maxQueryCacheTimeout;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ClusterConfig(Builder builder) {
        this(builder, true);
    }

    private ClusterConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cluster must be initialized: " + builder.__uninitialized);
        }
        this.clusterId = builder.clusterId == null ? new IntegerNode(0) : new IntegerNode(builder.clusterId.intValue());
        this.cacheSize = builder.cacheSize == null ? new IntegerNode(1) : new IntegerNode(builder.cacheSize.intValue());
        this.cacheTimeout = builder.cacheTimeout == null ? new DoubleNode(0.0) : new DoubleNode(builder.cacheTimeout.doubleValue());
        this.failoverToRemote = builder.failoverToRemote == null ? new BooleanNode(false) : new BooleanNode(builder.failoverToRemote.booleanValue());
        this.clusterName = builder.clusterName == null ? new StringNode() : new StringNode(builder.clusterName);
        this.maxQueryTimeout = builder.maxQueryTimeout == null ? new DoubleNode(600.0) : new DoubleNode(builder.maxQueryTimeout.doubleValue());
        this.maxQueryCacheTimeout = builder.maxQueryCacheTimeout == null ? new DoubleNode(10.0) : new DoubleNode(builder.maxQueryCacheTimeout.doubleValue());
    }

    public int clusterId() {
        return this.clusterId.value();
    }

    public int cacheSize() {
        return this.cacheSize.value();
    }

    public double cacheTimeout() {
        return this.cacheTimeout.value();
    }

    public boolean failoverToRemote() {
        return this.failoverToRemote.value();
    }

    public String clusterName() {
        return this.clusterName.value();
    }

    public double maxQueryTimeout() {
        return this.maxQueryTimeout.value();
    }

    public double maxQueryCacheTimeout() {
        return this.maxQueryCacheTimeout.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ClusterConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("clusterName"));
        private Integer clusterId = null;
        private Integer cacheSize = null;
        private Double cacheTimeout = null;
        private Boolean failoverToRemote = null;
        private String clusterName = null;
        private Double maxQueryTimeout = null;
        private Double maxQueryCacheTimeout = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ClusterConfig config) {
            this.clusterId(config.clusterId());
            this.cacheSize(config.cacheSize());
            this.cacheTimeout(config.cacheTimeout());
            this.failoverToRemote(config.failoverToRemote());
            this.clusterName(config.clusterName());
            this.maxQueryTimeout(config.maxQueryTimeout());
            this.maxQueryCacheTimeout(config.maxQueryCacheTimeout());
        }

        private Builder override(Builder __superior) {
            if (__superior.clusterId != null) {
                this.clusterId(__superior.clusterId);
            }
            if (__superior.cacheSize != null) {
                this.cacheSize(__superior.cacheSize);
            }
            if (__superior.cacheTimeout != null) {
                this.cacheTimeout(__superior.cacheTimeout);
            }
            if (__superior.failoverToRemote != null) {
                this.failoverToRemote(__superior.failoverToRemote);
            }
            if (__superior.clusterName != null) {
                this.clusterName(__superior.clusterName);
            }
            if (__superior.maxQueryTimeout != null) {
                this.maxQueryTimeout(__superior.maxQueryTimeout);
            }
            if (__superior.maxQueryCacheTimeout != null) {
                this.maxQueryCacheTimeout(__superior.maxQueryCacheTimeout);
            }
            return this;
        }

        public Builder clusterId(int __value) {
            this.clusterId = __value;
            return this;
        }

        private Builder clusterId(String __value) {
            return this.clusterId(Integer.valueOf(__value));
        }

        public Builder cacheSize(int __value) {
            this.cacheSize = __value;
            return this;
        }

        private Builder cacheSize(String __value) {
            return this.cacheSize(Integer.valueOf(__value));
        }

        public Builder cacheTimeout(double __value) {
            this.cacheTimeout = __value;
            return this;
        }

        private Builder cacheTimeout(String __value) {
            return this.cacheTimeout(Double.valueOf(__value));
        }

        public Builder failoverToRemote(boolean __value) {
            this.failoverToRemote = __value;
            return this;
        }

        private Builder failoverToRemote(String __value) {
            return this.failoverToRemote(Boolean.valueOf(__value));
        }

        public Builder clusterName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clusterName = __value;
            this.__uninitialized.remove("clusterName");
            return this;
        }

        public Builder maxQueryTimeout(double __value) {
            this.maxQueryTimeout = __value;
            return this;
        }

        private Builder maxQueryTimeout(String __value) {
            return this.maxQueryTimeout(Double.valueOf(__value));
        }

        public Builder maxQueryCacheTimeout(double __value) {
            this.maxQueryCacheTimeout = __value;
            return this;
        }

        private Builder maxQueryCacheTimeout(String __value) {
            return this.maxQueryCacheTimeout(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ClusterConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ClusterConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ClusterConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ClusterConfig build() {
            return new ClusterConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

