/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import com.yahoo.prelude.semantics.engine.NameSpace;
import com.yahoo.prelude.semantics.engine.ParameterNameSpace;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class Evaluation {
    private ParameterNameSpace parameterNameSpace = null;
    private final Query query;
    private int currentIndex = 0;
    private List<FlattenedItem> flattenedItems;
    private final RuleEvaluation ruleEvaluation;
    private final RuleBase ruleBase;
    private final int traceLevel;
    private String traceIndentation = "";
    private final Set<Integer> matchDigests = new HashSet<Integer>();
    private int previousQuerySize = 0;
    private boolean stemming = true;

    public Evaluation(Query query, RuleBase ruleBase) {
        this(query, ruleBase, 0);
    }

    public Evaluation(Query query, RuleBase ruleBase, int traceLevel) {
        this.query = query;
        this.ruleBase = ruleBase;
        this.traceLevel = traceLevel;
        this.reset();
        this.ruleEvaluation = new RuleEvaluation(this);
    }

    public RuleBase ruleBase() {
        return this.ruleBase;
    }

    public void reset() {
        if (this.flattenedItems != null) {
            this.previousQuerySize = this.flattenedItems.size();
        }
        this.currentIndex = 0;
        this.traceIndentation = "";
        this.flattenedItems = new ArrayList<FlattenedItem>();
        this.flatten(this.query.getModel().getQueryTree().getRoot(), 0, this.flattenedItems);
    }

    public void setToLast() {
        this.currentIndex = this.flattenedItems != null ? this.flattenedItems.size() - 1 : -1;
    }

    public void resetToLast() {
        if (this.flattenedItems != null) {
            this.previousQuerySize = this.flattenedItems.size();
        }
        this.traceIndentation = "";
        this.flattenedItems = new ArrayList<FlattenedItem>();
        this.flatten(this.query.getModel().getQueryTree().getRoot(), 0, this.flattenedItems);
        this.currentIndex = this.flattenedItems.size() - 1;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setStemming(boolean stemming) {
        this.stemming = stemming;
    }

    public boolean getStemming() {
        return this.stemming;
    }

    void addMatchDigest(int digest) {
        this.matchDigests.add(digest);
    }

    boolean hasMatchDigest(int matchDigest) {
        return this.matchDigests.contains(matchDigest);
    }

    int getPreviousQuerySize() {
        return this.previousQuerySize;
    }

    public int getQuerySize() {
        return this.flattenedItems.size();
    }

    public void next() {
        ++this.currentIndex;
    }

    public void previous() {
        --this.currentIndex;
    }

    public FlattenedItem currentItem() {
        if (this.currentIndex >= this.flattenedItems.size() || this.currentIndex < 0) {
            return null;
        }
        return this.flattenedItems.get(this.currentIndex);
    }

    public RuleEvaluation freshRuleEvaluation() {
        this.ruleEvaluation.initialize(this.flattenedItems, this.currentIndex);
        return this.ruleEvaluation;
    }

    public void addItem(Item item, TermType termType) {
        Item root = this.query.getModel().getQueryTree().getRoot();
        if (root == null) {
            this.query.getModel().getQueryTree().setRoot(item);
        } else {
            this.query.getModel().getQueryTree().setRoot(this.combineItems(root, item, termType));
        }
    }

    public void removeItem(Item item) {
        item.getParent().removeItem(item);
    }

    public void removeItemByIdentity(Item item) {
        int position = this.findIndexByIdentity(item);
        if (position >= 0) {
            item.getParent().removeItem(position);
        } else {
            item.getParent().removeItem(item);
        }
    }

    private int findIndexByIdentity(Item item) {
        int position = 0;
        ListIterator<Item> i = item.getParent().getItemIterator();
        while (i.hasNext()) {
            Item child = (Item)i.next();
            if (item == child) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public void removeItem(int position, Item item) {
        Item removeCandidate = item.getParent().getItem(position);
        if (removeCandidate.equals(item)) {
            item.getParent().removeItem(position);
        } else {
            item.getParent().removeItem(item);
        }
    }

    private CompositeItem convertSegmentItem(CompositeItem item) {
        CompositeItem converted;
        if (!(item instanceof SegmentItem)) {
            return item;
        }
        if (item instanceof AndSegmentItem) {
            converted = new AndItem();
        } else if (item instanceof PhraseSegmentItem) {
            PhraseItem p = new PhraseItem();
            PhraseSegmentItem old = (PhraseSegmentItem)item;
            p.setIndexName(old.getIndexName());
            converted = p;
        } else {
            return item;
        }
        ListIterator<Item> i = item.getItemIterator();
        while (i.hasNext()) {
            converted.addItem((Item)i.next());
        }
        return converted;
    }

    private void insertMutableInTree(CompositeItem mutable, CompositeItem original, CompositeItem parent) {
        if (parent == null) {
            this.query.getModel().getQueryTree().setRoot(mutable);
        } else {
            int parentsIndex = parent.getItemIndex(original);
            parent.setItem(parentsIndex, mutable);
        }
    }

    public void makeParentMutable(TermItem item) {
        CompositeItem mutable;
        CompositeItem parent = item.getParent();
        if (parent != (mutable = this.convertSegmentItem(parent))) {
            CompositeItem parentsParent = parent.getParent();
            this.insertMutableInTree(mutable, parent, parentsParent);
        }
    }

    public void insertItems(List<Item> items, CompositeItem parent, int index, TermType desiredParentType) {
        if (this.isEmpty(parent)) {
            if (items.size() == 1 && desiredParentType.hasItemClass(items.get(0).getClass())) {
                this.query.getModel().getQueryTree().setRoot(items.get(0));
            } else {
                CompositeItem newParent = (CompositeItem)desiredParentType.createItemClass();
                items.forEach(item -> newParent.addItem((Item)item));
                this.query.getModel().getQueryTree().setRoot(newParent);
            }
            return;
        }
        if (parent.getItemCount() > 0 && parent instanceof QueryTree && parent.getItem(0) instanceof CompositeItem) {
            parent = (CompositeItem)parent.getItem(0);
            if (index == 1) {
                index = parent.getItemCount();
            }
        }
        if ((desiredParentType == TermType.DEFAULT || desiredParentType.hasItemClass(parent.getClass())) && this.equalIndexNameIfParentIsPhrase(items, parent)) {
            for (Item item2 : items) {
                this.addItem(parent, index, item2, desiredParentType);
            }
        } else if (parent.items().isEmpty()) {
            CompositeItem parentsParent = parent.getParent();
            CompositeItem newParent = this.newParent(desiredParentType);
            items.forEach(item -> newParent.addItem((Item)item));
            parentsParent.setItem(parentsParent.getItemIndex(parent), newParent);
        } else if (items.size() == 1 && desiredParentType.hasItemClass(items.get(0).getClass())) {
            this.addItem(parent, index, items.get(0), desiredParentType);
        } else {
            this.insertWithDesiredParentType(items, parent, desiredParentType);
        }
    }

    private boolean isEmpty(Item item) {
        if (item == null) {
            return true;
        }
        return item instanceof QueryTree && ((QueryTree)item).isEmpty();
    }

    private void addItem(CompositeItem parent, int index, Item item, TermType desiredParentType) {
        if (parent instanceof NotItem) {
            if (index == 0 && parent.getItem(0) == null) {
                parent.setItem(0, item);
            } else if (index <= 1 && !(parent.getItem(0) instanceof CompositeItem)) {
                CompositeItem positiveComposite = (CompositeItem)desiredParentType.createItemClass();
                positiveComposite.addItem(parent.getItem(0));
                positiveComposite.addItem(index, item);
                parent.setItem(0, positiveComposite);
            } else if (parent.getItem(0) != null && parent.getItem(0) instanceof CompositeItem && index <= ((CompositeItem)parent.getItem(0)).getItemCount()) {
                ((CompositeItem)parent.getItem(0)).addItem(index, item);
            } else {
                parent.addItem(index, item);
            }
        } else if (parent.getItemCount() > 0 && parent instanceof QueryTree) {
            CompositeItem composite = (CompositeItem)desiredParentType.createItemClass();
            composite.addItem(parent.getItem(0));
            composite.addItem(index, item);
            parent.setItem(0, composite);
        } else {
            parent.addItem(index, item);
        }
    }

    private boolean equalIndexNameIfParentIsPhrase(List<Item> items, CompositeItem parent) {
        if (!(parent instanceof PhraseItem)) {
            return true;
        }
        PhraseItem phrase = (PhraseItem)parent;
        for (Item item : items) {
            IndexedItem indexedItem;
            if (!(item instanceof IndexedItem) || (indexedItem = (IndexedItem)((Object)item)).getIndexName().equals(phrase.getIndexName())) continue;
            return false;
        }
        return true;
    }

    private void insertWithDesiredParentType(List<Item> items, CompositeItem parent, TermType desiredParentType) {
        CompositeItem parentsParent = parent.getParent();
        CompositeItem newParent = this.newParent(desiredParentType);
        if (!(parentsParent instanceof QueryTree) && parentsParent.getItemType() == newParent.getItemType()) {
            newParent = parentsParent;
        }
        for (Item item : items) {
            newParent.addItem(item);
        }
        if (desiredParentType == TermType.EQUIV || desiredParentType == TermType.PHRASE) {
            parent.addItem(newParent);
        } else {
            newParent.addItem(parent);
            if (newParent != parentsParent) {
                parentsParent.setItem(parentsParent.getItemIndex(parent), newParent);
            }
        }
    }

    private CompositeItem newParent(TermType desiredParentType) {
        return desiredParentType == TermType.DEFAULT ? new AndItem() : (CompositeItem)desiredParentType.createItemClass();
    }

    private Item combineItems(Item first, Item second, TermType termType) {
        if (first instanceof NullItem) {
            return second;
        }
        if (first instanceof NotItem) {
            NotItem notItem = (NotItem)first;
            if (termType == TermType.NOT) {
                notItem.addNegativeItem(second);
            } else {
                Item newPositive = this.combineItems(notItem.getPositiveItem(), second, termType);
                notItem.setPositiveItem(newPositive);
            }
            return notItem;
        }
        if (first instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)first;
            CompositeItem combined = this.createType(termType);
            if (combined.getClass().equals(composite.getClass())) {
                composite.addItem(second);
                return composite;
            }
            if (combined instanceof EquivItem) {
                first = this.makeEquivCompatible(first);
                second = this.makeEquivCompatible(second);
            }
            combined.addItem(first);
            combined.addItem(second);
            return combined;
        }
        if (first instanceof TermItem) {
            CompositeItem combined = this.createType(termType);
            combined.addItem(first);
            combined.addItem(second);
            return combined;
        }
        throw new RuntimeException("Don't know how to add an item to type " + first.getClass());
    }

    private Item makeEquivCompatible(Item item) {
        if (item instanceof AndItem || item instanceof WeakAndItem) {
            PhraseItem phrase = new PhraseItem();
            List<Item> children = ((CompositeItem)item).items();
            if (children.isEmpty()) {
                return phrase;
            }
            String index = ((IndexedItem)((Object)children.get(0))).getIndexName();
            for (Item child : ((CompositeItem)item).items()) {
                phrase.addItem(child);
            }
            phrase.setIndexName(index);
            return phrase;
        }
        return item;
    }

    private CompositeItem createType(TermType termType) {
        if (termType == TermType.DEFAULT) {
            if (this.query.getModel().getType() == Query.Type.ANY) {
                return new OrItem();
            }
            return new AndItem();
        }
        return (CompositeItem)termType.createItemClass();
    }

    private void flatten(Item item, int position, List<FlattenedItem> toList) {
        if (item == null) {
            return;
        }
        if (item.isFilter()) {
            return;
        }
        if (item instanceof TermItem) {
            toList.add(new FlattenedItem((TermItem)item, position));
            return;
        }
        if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            int childPosition = 0;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                this.flatten((Item)i.next(), childPosition++, toList);
            }
        }
    }

    public void trace(int level, String message) {
        if (level > this.getTraceLevel()) {
            return;
        }
        this.query.trace(this.traceIndentation + message, false, 1);
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void indentTrace() {
        this.traceIndentation = this.traceIndentation + "   ";
    }

    public void unindentTrace() {
        this.traceIndentation = this.traceIndentation.length() < 3 ? "" : this.traceIndentation.substring(3);
    }

    public NameSpace getNameSpace(String nameSpaceName) {
        if (nameSpaceName.equals("parameter")) {
            if (this.parameterNameSpace == null) {
                this.parameterNameSpace = new ParameterNameSpace();
            }
            return this.parameterNameSpace;
        }
        throw new RuntimeException("Unknown namespace '" + nameSpaceName + "'");
    }
}

