/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import java.nio.ByteBuffer;
import java.util.Objects;

public class FuzzyItem
extends TermItem {
    private String term;
    private int maxEditDistance;
    private int prefixLength;
    public static int DEFAULT_MAX_EDIT_DISTANCE = 2;
    public static int DEFAULT_PREFIX_LENGTH = 0;

    public FuzzyItem(String indexName, boolean isFromQuery, String term, int maxEditDistance, int prefixLength) {
        super(indexName, isFromQuery, null);
        this.setValue(term);
        this.setMaxEditDistance(maxEditDistance);
        this.setPrefixLength(prefixLength);
    }

    public void setMaxEditDistance(int maxEditDistance) {
        this.maxEditDistance = maxEditDistance;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getMaxEditDistance() {
        return this.maxEditDistance;
    }

    @Override
    public void setValue(String value) {
        this.term = value;
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public boolean isWords() {
        return false;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.FUZZY;
    }

    @Override
    public String getName() {
        return "FUZZY";
    }

    @Override
    public String stringValue() {
        return this.term;
    }

    @Override
    public boolean isStemmed() {
        return false;
    }

    @Override
    public String getIndexedString() {
        return this.stringValue();
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyItem other = (FuzzyItem)obj;
        if (!this.term.equals(other.term)) {
            return false;
        }
        if (this.maxEditDistance != other.maxEditDistance) {
            return false;
        }
        return this.prefixLength == other.prefixLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term, this.maxEditDistance, this.prefixLength);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.term);
        buffer.append(",");
        buffer.append(this.maxEditDistance);
        buffer.append(",");
        buffer.append(this.prefixLength);
        buffer.append(")");
        buffer.append(" ");
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        FuzzyItem.putString(this.getIndexedString(), buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.maxEditDistance, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.prefixLength, (ByteBuffer)buffer);
    }
}

