/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.search.schema.DocumentSummary;
import java.util.Map;
import java.util.stream.Collectors;

public class DocsumDefinition {
    private final String name;
    private final Map<String, DocsumField> fields;
    private final boolean dynamic;

    public DocsumDefinition(DocumentSummary documentSummary) {
        this.name = documentSummary.name();
        this.dynamic = documentSummary.isDynamic();
        this.fields = documentSummary.fields().values().stream().map(field -> DocsumField.create(field.name(), field.type().asString())).collect(Collectors.toUnmodifiableMap(field -> field.getName(), field -> field));
    }

    public String name() {
        return this.name;
    }

    public Map<String, DocsumField> fields() {
        return this.fields;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Object convert(String fieldName, Inspector value) {
        DocsumField field = this.fields.get(fieldName);
        if (field == null || !value.valid()) {
            return null;
        }
        return field.convert(value);
    }

    public String toString() {
        return "docsum definition '" + this.name() + "'";
    }
}

