/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.Optional;

public class Pong {
    private final ElapsedTime elapsed = new ElapsedTime();
    private final Optional<Long> activeDocuments;
    private final boolean isBlockingWrites;
    private final Optional<ErrorMessage> error;

    public Pong() {
        this(Optional.empty(), false, Optional.empty());
    }

    public Pong(ErrorMessage error) {
        this(Optional.empty(), false, Optional.of(error));
    }

    public Pong(long activeDocuments) {
        this(Optional.of(activeDocuments), false, Optional.empty());
    }

    public Pong(long activeDocuments, boolean isBlockingWrites) {
        this(Optional.of(activeDocuments), isBlockingWrites, Optional.empty());
    }

    private Pong(Optional<Long> activeDocuments, boolean isBlockingWrites, Optional<ErrorMessage> error) {
        this.activeDocuments = activeDocuments;
        this.isBlockingWrites = isBlockingWrites;
        this.error = error;
    }

    public Optional<ErrorMessage> error() {
        return this.error;
    }

    public Optional<Long> activeDocuments() {
        return this.activeDocuments;
    }

    public boolean isBlockingWrites() {
        return this.isBlockingWrites;
    }

    public boolean badResponse() {
        return this.error.isPresent();
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsed;
    }

    public String toString() {
        StringBuilder m = new StringBuilder("Ping result");
        this.activeDocuments.ifPresent(docCount -> m.append(" active docs: ").append(docCount));
        if (this.isBlockingWrites) {
            m.append(" blocking writes: true");
        }
        this.error.ifPresent(e -> m.append(" error: ").append(this.error));
        return m.toString();
    }
}

