/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.log.event.Event;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vdslib.VisitorStatistics;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class MetricsSearcher
extends Searcher {
    private static final CompoundName metricsearcherId = CompoundName.from((String)"metricsearcher.id");
    private static final CompoundName streamingLoadtype = CompoundName.from((String)"streaming.loadtype");
    private static final Logger log = Logger.getLogger(MetricsSearcher.class.getName());
    Map<String, Stats> statMap = new TreeMap<String, Stats>();
    private long lastMetricLog = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result search(Query query, Execution execution) {
        long timeMs = System.currentTimeMillis();
        String metricName = query.properties().getString(metricsearcherId);
        if (metricName != null) {
            query.properties().set(streamingLoadtype, metricName);
        }
        Result result = execution.search(query);
        long latency = System.currentTimeMillis() - timeMs;
        metricName = query.properties().getString(streamingLoadtype);
        if (metricName == null) {
            return result;
        }
        MetricsSearcher metricsSearcher = this;
        synchronized (metricsSearcher) {
            Stats stats = this.statMap.get(metricName);
            if (stats == null) {
                stats = new Stats();
                this.statMap.put(metricName, stats);
            }
            ++stats.count;
            stats.latency += latency;
            if (result.hits().getError() != null && !result.hits().getErrorHit().hasOnlyErrorCode(ErrorMessage.NULL_QUERY) && !result.hits().getErrorHit().hasOnlyErrorCode(3)) {
                ++stats.failed;
            } else {
                ++stats.ok;
            }
            VisitorStatistics visitorstats = null;
            QueryContext queryContext = query.getContext(false);
            if (queryContext != null) {
                visitorstats = (VisitorStatistics)queryContext.getProperty("streaming.statistics");
            }
            if (visitorstats != null) {
                stats.dataStreamed += visitorstats.getBytesVisited();
                stats.documentsStreamed += visitorstats.getDocumentsVisited();
            } else {
                log.fine("No visitor statistics set in query! - don't use metrics searcher without streaming search");
            }
            if (timeMs - this.lastMetricLog > 60000L) {
                for (Map.Entry<String, Stats> entry : this.statMap.entrySet()) {
                    stats = entry.getValue();
                    Event.value((String)(entry.getKey() + "_latency"), (double)(stats.count > 0 ? (double)stats.latency / (double)stats.count : 0.0));
                    Event.value((String)(entry.getKey() + "_ok"), (double)stats.ok);
                    Event.value((String)(entry.getKey() + "_failed"), (double)stats.failed);
                    Event.value((String)(entry.getKey() + "_bytesstreamed"), (double)stats.dataStreamed);
                    Event.value((String)(entry.getKey() + "_documentsstreamed"), (double)stats.documentsStreamed);
                    stats.latency = 0L;
                    stats.count = 0;
                }
                this.lastMetricLog = timeMs;
            }
        }
        return result;
    }

    static class Stats {
        long latency = 0L;
        int count = 0;
        int ok = 0;
        int failed = 0;
        long dataStreamed = 0L;
        long documentsStreamed = 0L;

        Stats() {
        }
    }
}

