/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.collect.ImmutableMap;
import com.yahoo.prelude.Location;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BoolItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.ExactStringItem;
import com.yahoo.prelude.query.FalseItem;
import com.yahoo.prelude.query.FuzzyItem;
import com.yahoo.prelude.query.GeoLocationItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MarkerWordItem;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NearestNeighborItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.NumericInItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.RangeItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.RegExpItem;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.StringInItem;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.prelude.query.SuffixItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.prelude.query.TrueItem;
import com.yahoo.prelude.query.UriItem;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.yql.NullItemException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class VespaSerializer {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Map<Class<?>, Serializer> dispatch;
    private static final Comparator<? super Map.Entry<Object, Integer>> tokenComparator;

    private static StringBuilder escape(String in, StringBuilder escaped) {
        block11: for (char c : in.toCharArray()) {
            switch (c) {
                case '\b': {
                    escaped.append("\\b");
                    continue block11;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block11;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block11;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block11;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block11;
                }
                case '\"': {
                    escaped.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    escaped.append("\\'");
                    continue block11;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block11;
                }
                case '/': {
                    escaped.append("\\/");
                    continue block11;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        escaped.append("\\u").append(VespaSerializer.fourDigitHexString(c));
                        continue block11;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped;
    }

    private static char[] fourDigitHexString(char c) {
        char[] hex = new char[4];
        int in = c & 0xFFFF;
        for (int i = 3; i >= 0; --i) {
            hex[i] = DIGITS[in & 0xF];
            in >>>= 4;
        }
        return hex;
    }

    static String getIndexName(Item item) {
        if (!(item instanceof IndexedItem)) {
            throw new IllegalArgumentException("Expected IndexedItem, got " + item.getClass());
        }
        return VespaSerializer.normalizeIndexName(((IndexedItem)((Object)item)).getIndexName());
    }

    public static String serialize(Query query) {
        return VespaSerializer.serialize(query, "");
    }

    public static String serialize(Query query, String insertBeforeGrouping) {
        StringBuilder out = new StringBuilder();
        VespaSerializer.serialize(query.getModel().getQueryTree().getRoot(), out);
        out.append(insertBeforeGrouping);
        for (GroupingRequest request : query.getSelect().getGrouping()) {
            out.append(" | ");
            VespaSerializer.serialize(request, out);
        }
        return out.toString();
    }

    private static void serialize(GroupingRequest request, StringBuilder out) {
        Iterator<Continuation> it = request.continuations().iterator();
        if (it.hasNext()) {
            out.append("{ continuations:[");
            while (it.hasNext()) {
                out.append('\'').append(it.next()).append('\'');
                if (!it.hasNext()) continue;
                out.append(", ");
            }
            out.append("] }");
        }
        out.append(request.getRootOperation());
    }

    private static void serialize(Item item, StringBuilder out) {
        VespaVisitor visitor = new VespaVisitor(out);
        ToolBox.visit(visitor, item);
    }

    static String serialize(QueryTree item) {
        StringBuilder out = new StringBuilder();
        VespaSerializer.serialize(item.getRoot(), out);
        return out.toString();
    }

    static String serialize(Item item) {
        StringBuilder out = new StringBuilder();
        VespaSerializer.serialize(item, out);
        return out.toString();
    }

    private static void serializeWeightedSetContents(StringBuilder destination, String opName, WeightedSetItem weightedSet) {
        VespaSerializer.serializeWeightedSetContents(destination, opName, weightedSet, "");
    }

    private static void serializeWeightedSetContents(StringBuilder destination, String opName, WeightedSetItem weightedSet, String optionalAnnotations) {
        boolean addedAnnotations = VespaSerializer.addAnnotations(destination, weightedSet, optionalAnnotations);
        destination.append(opName).append('(').append(VespaSerializer.normalizeIndexName(weightedSet.getIndexName())).append(", {");
        int initLen = destination.length();
        ArrayList<Map.Entry<Object, Integer>> tokens = new ArrayList<Map.Entry<Object, Integer>>(weightedSet.getNumTokens());
        Iterator<Map.Entry<Object, Integer>> i = weightedSet.getTokens();
        while (i.hasNext()) {
            tokens.add(i.next());
        }
        Collections.sort(tokens, tokenComparator);
        for (Map.Entry entry : tokens) {
            VespaSerializer.comma(destination, initLen);
            destination.append('\"');
            VespaSerializer.escape(entry.getKey().toString(), destination);
            destination.append("\": ").append(((Integer)entry.getValue()).toString());
        }
        destination.append("})");
        if (addedAnnotations) {
            destination.append(")");
        }
    }

    private static boolean addAnnotations(StringBuilder destination, WeightedSetItem weightedSet, String optionalAnnotations) {
        int incomingLen = destination.length();
        String annotations = VespaSerializer.leafAnnotations(weightedSet);
        if (optionalAnnotations.length() > 0 || annotations.length() > 0) {
            destination.append("({");
        }
        int preAnnotationValueLen = destination.length();
        if (annotations.length() > 0) {
            destination.append(annotations);
        }
        if (optionalAnnotations.length() > 0) {
            VespaSerializer.comma(destination, preAnnotationValueLen);
            destination.append(optionalAnnotations);
        }
        if (destination.length() > incomingLen) {
            destination.append("}");
            return true;
        }
        return false;
    }

    private static StringBuilder annotationKey(StringBuilder annotation, String val) {
        annotation.append(val).append(": ");
        return annotation;
    }

    private static void comma(StringBuilder annotation, int initLen) {
        if (annotation.length() > initLen) {
            annotation.append(", ");
        }
    }

    private static String leafAnnotations(TaggableItem item) {
        int hitLimit;
        StringBuilder annotation = new StringBuilder();
        int initLen = annotation.length();
        int uniqueId = item.getUniqueID();
        double connectivity = item.getConnectivity();
        TaggableItem connectedTo = (TaggableItem)((Object)item.getConnectedItem());
        double significance = item.getSignificance();
        if (connectedTo != null && connectedTo.getUniqueID() != 0) {
            annotation.append("connectivity").append(": {").append("id").append(": ").append(connectedTo.getUniqueID()).append(", ").append("weight").append(": ").append(connectivity).append("}");
        }
        if (item.hasExplicitSignificance()) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("significance").append(": ").append(significance);
        }
        if (uniqueId != 0) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("id").append(": ").append(uniqueId);
        }
        Item leaf = (Item)((Object)item);
        boolean filter = leaf.isFilter();
        boolean isRanked = leaf.isRanked();
        String label = leaf.getLabel();
        int weight = leaf.getWeight();
        if (filter) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("filter").append(": true");
        }
        if (!isRanked) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("ranked").append(": false");
        }
        if (label != null) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("label").append(": \"");
            VespaSerializer.escape(label, annotation);
            annotation.append("\"");
        }
        if (weight != 100) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("weight").append(": ").append(weight);
        }
        if (item instanceof IntItem && (hitLimit = ((IntItem)item).getHitLimit()) != 0) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("hitLimit").append(": ").append(hitLimit);
        }
        return annotation.toString();
    }

    private static void serializeOrigin(StringBuilder destination, String image, int offset, int length) {
        destination.append("origin").append(": {").append("original").append(": \"");
        VespaSerializer.escape(image, destination);
        destination.append("\", ").append("offset").append(": ").append(offset).append(", ").append("length").append(": ").append(length).append("}");
    }

    private static String normalizeIndexName(String indexName) {
        if (indexName.length() == 0) {
            return "default";
        }
        return indexName;
    }

    private static void annotatedTerm(StringBuilder destination, IndexedItem w, String annotations) {
        if (annotations.length() > 0) {
            destination.append("({").append(annotations).append("}");
        }
        destination.append('\"');
        VespaSerializer.escape(w.getIndexedString(), destination).append('\"');
        if (annotations.length() > 0) {
            destination.append(')');
        }
    }

    static {
        tokenComparator = new TokenComparator();
        HashMap<Class, Serializer> dispatchBuilder = new HashMap<Class, Serializer>();
        dispatchBuilder.put(AndItem.class, new AndSerializer());
        dispatchBuilder.put(AndSegmentItem.class, new AndSegmentSerializer());
        dispatchBuilder.put(DotProductItem.class, new DotProductSerializer());
        dispatchBuilder.put(EquivItem.class, new EquivSerializer());
        dispatchBuilder.put(ExactStringItem.class, new WordSerializer());
        dispatchBuilder.put(IntItem.class, new NumberSerializer());
        dispatchBuilder.put(GeoLocationItem.class, new GeoLocationSerializer());
        dispatchBuilder.put(BoolItem.class, new BoolSerializer());
        dispatchBuilder.put(TrueItem.class, new TrueSerializer());
        dispatchBuilder.put(FalseItem.class, new FalseSerializer());
        dispatchBuilder.put(MarkerWordItem.class, new WordSerializer());
        dispatchBuilder.put(NearItem.class, new NearSerializer());
        dispatchBuilder.put(NearestNeighborItem.class, new NearestNeighborSerializer());
        dispatchBuilder.put(NotItem.class, new NotSerializer());
        dispatchBuilder.put(NullItem.class, new NullSerializer());
        dispatchBuilder.put(ONearItem.class, new ONearSerializer());
        dispatchBuilder.put(OrItem.class, new OrSerializer());
        dispatchBuilder.put(PhraseItem.class, new PhraseSerializer());
        dispatchBuilder.put(SameElementItem.class, new SameElementSerializer());
        dispatchBuilder.put(PhraseSegmentItem.class, new PhraseSegmentSerializer());
        dispatchBuilder.put(PredicateQueryItem.class, new PredicateQuerySerializer());
        dispatchBuilder.put(PrefixItem.class, new WordSerializer());
        dispatchBuilder.put(WordAlternativesItem.class, new WordAlternativesSerializer());
        dispatchBuilder.put(RangeItem.class, new RangeSerializer());
        dispatchBuilder.put(RankItem.class, new RankSerializer());
        dispatchBuilder.put(SubstringItem.class, new WordSerializer());
        dispatchBuilder.put(SuffixItem.class, new WordSerializer());
        dispatchBuilder.put(WandItem.class, new WandSerializer());
        dispatchBuilder.put(WeakAndItem.class, new WeakAndSerializer());
        dispatchBuilder.put(WeightedSetItem.class, new WeightedSetSerializer());
        dispatchBuilder.put(WordItem.class, new WordSerializer());
        dispatchBuilder.put(RegExpItem.class, new RegExpSerializer());
        dispatchBuilder.put(UriItem.class, new UriSerializer());
        dispatchBuilder.put(FuzzyItem.class, new FuzzySerializer());
        dispatchBuilder.put(StringInItem.class, new StringInSerializer());
        dispatchBuilder.put(NumericInItem.class, new NumericInSerializer());
        dispatch = ImmutableMap.copyOf(dispatchBuilder);
    }

    private static class VespaVisitor
    extends ToolBox.QueryVisitor {
        final StringBuilder destination;
        final Deque<SerializerWrapper> state = new ArrayDeque<SerializerWrapper>();

        VespaVisitor(StringBuilder destination) {
            this.destination = destination;
        }

        @Override
        public void onExit() {
            SerializerWrapper w = this.state.removeFirst();
            w.type.onExit(this.destination, w.item);
            w = this.state.peekFirst();
            if (w != null) {
                ++w.subItems;
            }
        }

        @Override
        public boolean visit(Item item) {
            Serializer doIt = dispatch.get(item.getClass());
            if (doIt == null) {
                throw new IllegalArgumentException(item.getClass() + " not supported for YQL marshalling.");
            }
            if (this.state.peekFirst() != null && this.state.peekFirst().subItems > 0) {
                this.destination.append(this.state.peekFirst().type.separator(this.state));
            }
            this.state.addFirst(new SerializerWrapper(doIt, item));
            return doIt.serialize(this.destination, item);
        }
    }

    private static final class TokenComparator
    implements Comparator<Map.Entry<Object, Integer>> {
        private TokenComparator() {
        }

        @Override
        public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
            Comparable c1 = (Comparable)o1.getKey();
            Comparable c2 = (Comparable)o2.getKey();
            return c1.compareTo(c2);
        }
    }

    private static class AndSerializer
    extends Serializer<AndItem> {
        private AndSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, AndItem item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return " AND ";
        }

        @Override
        boolean serialize(StringBuilder destination, AndItem item) {
            destination.append("(");
            return true;
        }
    }

    private static class AndSegmentSerializer
    extends Serializer<AndSegmentItem> {
        private AndSegmentSerializer() {
        }

        private static void serializeWords(StringBuilder destination, AndSegmentItem segment) {
            for (int i = 0; i < segment.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if (!((current = segment.getItem(i)) instanceof WordItem)) {
                    throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in segment AND expressions not implemented, please report this as a bug.");
                }
                destination.append('\"');
                VespaSerializer.escape(((WordItem)current).getIndexedString(), destination).append('\"');
            }
        }

        @Override
        void onExit(StringBuilder destination, AndSegmentItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, AndSegmentItem item) {
            return AndSegmentSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, AndSegmentItem item, boolean includeField) {
            int length;
            int offset;
            String image;
            Substring origin = item.getOrigin();
            if (origin == null) {
                image = item.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(item.getIndexName())).append(" contains ");
            }
            destination.append("({");
            VespaSerializer.serializeOrigin(destination, image, offset, length);
            destination.append(", ").append("andSegmenting").append(": true");
            destination.append("}");
            destination.append("phrase").append('(');
            AndSegmentSerializer.serializeWords(destination, item);
            destination.append("))");
            return false;
        }
    }

    private static class DotProductSerializer
    extends Serializer<WeightedSetItem> {
        private DotProductSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WeightedSetItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, WeightedSetItem item) {
            VespaSerializer.serializeWeightedSetContents(destination, "dotProduct", item);
            return false;
        }
    }

    private static class EquivSerializer
    extends Serializer<EquivItem> {
        private EquivSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, EquivItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, EquivItem item) {
            String annotations = VespaSerializer.leafAnnotations(item);
            destination.append(VespaSerializer.getIndexName(item.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append("({").append(annotations).append("}");
            }
            destination.append("equiv").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = item.getItemIterator();
            while (i.hasNext()) {
                Item x = (Item)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                if (x instanceof PhraseItem) {
                    PhraseSerializer.serialize(destination, (PhraseItem)x, false);
                    continue;
                }
                destination.append('\"');
                VespaSerializer.escape(((IndexedItem)((Object)x)).getIndexedString(), destination);
                destination.append('\"');
            }
            if (annotations.length() > 0) {
                destination.append(')');
            }
            destination.append(')');
            return false;
        }
    }

    private static class WordSerializer
    extends Serializer<WordItem> {
        private WordSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WordItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, WordItem item) {
            StringBuilder wordAnnotations = WordSerializer.getAllAnnotations(item);
            destination.append(VespaSerializer.normalizeIndexName(item.getIndexName())).append(" contains ");
            VespaSerializer.annotatedTerm(destination, item, wordAnnotations.toString());
            return false;
        }

        static void serializeWordWithoutIndex(StringBuilder destination, Item item) {
            WordItem w = (WordItem)item;
            StringBuilder wordAnnotations = WordSerializer.getAllAnnotations(w);
            VespaSerializer.annotatedTerm(destination, w, wordAnnotations.toString());
        }

        private static StringBuilder getAllAnnotations(WordItem w) {
            StringBuilder wordAnnotations = new StringBuilder(WordSerializer.wordAnnotations(w));
            String leafAnnotations = VespaSerializer.leafAnnotations(w);
            if (leafAnnotations.length() > 0) {
                VespaSerializer.comma(wordAnnotations, 0);
                wordAnnotations.append(VespaSerializer.leafAnnotations(w));
            }
            return wordAnnotations;
        }

        private static String wordAnnotations(WordItem item) {
            int length;
            int offset;
            String image;
            Substring origin = item.getOrigin();
            boolean usePositionData = item.usePositionData();
            boolean stemmed = item.isStemmed();
            boolean lowercased = item.isLowercased();
            boolean accentDrop = item.isNormalizable();
            SegmentingRule andSegmenting = item.getSegmentingRule();
            boolean isFromQuery = item.isFromQuery();
            StringBuilder annotation = new StringBuilder();
            boolean prefix = item instanceof PrefixItem;
            boolean suffix = item instanceof SuffixItem;
            boolean substring = item instanceof SubstringItem;
            int initLen = annotation.length();
            if (origin == null) {
                image = item.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            if (!image.substring(offset, offset + length).equals(item.getIndexedString())) {
                VespaSerializer.serializeOrigin(annotation, image, offset, length);
            }
            if (!usePositionData) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("usePositionData").append(": false");
            }
            if (stemmed) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("stem").append(": false");
            }
            if (lowercased) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("normalizeCase").append(": false");
            }
            if (!accentDrop) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("accentDrop").append(": false");
            }
            if (andSegmenting == SegmentingRule.BOOLEAN_AND) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("andSegmenting").append(": true");
            }
            if (!isFromQuery) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("implicitTransforms").append(": false");
            }
            if (prefix) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("prefix").append(": true");
            }
            if (suffix) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("suffix").append(": true");
            }
            if (substring) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append("substring").append(": true");
            }
            return annotation.toString();
        }
    }

    private static class NumberSerializer
    extends Serializer<IntItem> {
        private NumberSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, IntItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, IntItem intItem) {
            if (intItem.getFromLimit().number().equals(intItem.getToLimit().number())) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName())).append(" = ");
                this.annotatedNumberImage(intItem, intItem.getFromLimit().number().toString(), destination);
            } else if (intItem.getFromLimit().isInfinite()) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName()));
                destination.append(intItem.getToLimit().isInclusive() ? " <= " : " < ");
                this.annotatedNumberImage(intItem, intItem.getToLimit().number().toString(), destination);
            } else if (intItem.getToLimit().isInfinite()) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName()));
                destination.append(intItem.getFromLimit().isInclusive() ? " >= " : " > ");
                this.annotatedNumberImage(intItem, intItem.getFromLimit().number().toString(), destination);
            } else {
                this.serializeAsRange(destination, intItem);
            }
            return false;
        }

        private void serializeAsRange(StringBuilder destination, IntItem intItem) {
            String annotations = VespaSerializer.leafAnnotations(intItem);
            boolean leftOpen = !intItem.getFromLimit().isInclusive();
            boolean rightOpen = !intItem.getToLimit().isInclusive();
            String boundsAnnotation = "";
            if (leftOpen && rightOpen) {
                boundsAnnotation = "bounds: \"open\"";
            } else if (leftOpen) {
                boundsAnnotation = "bounds: \"leftOpen\"";
            } else if (rightOpen) {
                boundsAnnotation = "bounds: \"rightOpen\"";
            }
            if (annotations.length() > 0 || boundsAnnotation.length() > 0) {
                destination.append("({");
            }
            int initLen = destination.length();
            if (annotations.length() > 0) {
                destination.append(annotations);
            }
            VespaSerializer.comma(destination, initLen);
            if (boundsAnnotation.length() > 0) {
                destination.append(boundsAnnotation);
            }
            if (initLen != annotations.length()) {
                destination.append("}");
            }
            destination.append("range").append('(').append(VespaSerializer.normalizeIndexName(intItem.getIndexName())).append(", ").append(intItem.getFromLimit().number()).append(", ").append(intItem.getToLimit().number()).append(")");
            if (annotations.length() > 0 || boundsAnnotation.length() > 0) {
                destination.append(")");
            }
        }

        private void annotatedNumberImage(IntItem item, String rawNumber, StringBuilder image) {
            String annotations = VespaSerializer.leafAnnotations(item);
            if (annotations.length() > 0) {
                image.append("({").append(annotations).append("}");
            }
            if ('-' == rawNumber.charAt(0)) {
                image.append('(');
            }
            image.append(rawNumber);
            this.appendLongIfNecessary(rawNumber, image);
            if ('-' == rawNumber.charAt(0)) {
                image.append(')');
            }
            if (annotations.length() > 0) {
                image.append(')');
            }
        }

        private void appendLongIfNecessary(String rawNumber, StringBuilder image) {
            if (rawNumber.indexOf(46) >= 0) {
                return;
            }
            try {
                long l = Long.parseLong(rawNumber);
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    image.append('L');
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static class GeoLocationSerializer
    extends Serializer<GeoLocationItem> {
        private GeoLocationSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, GeoLocationItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, GeoLocationItem item) {
            String annotations = VespaSerializer.leafAnnotations(item);
            if (annotations.length() > 0) {
                destination.append("({").append(annotations).append("}");
            }
            destination.append("geoLocation").append('(');
            destination.append(item.getIndexName()).append(", ");
            Location loc = item.getLocation();
            destination.append(loc.degNS()).append(", ");
            destination.append(loc.degEW()).append(", ");
            destination.append('\"').append(loc.degRadius()).append(" deg").append('\"');
            destination.append(')');
            return false;
        }
    }

    private static class BoolSerializer
    extends Serializer<BoolItem> {
        private BoolSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, BoolItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, BoolItem item) {
            destination.append(VespaSerializer.normalizeIndexName(item.getIndexName())).append(" = ");
            destination.append(item.stringValue());
            return false;
        }
    }

    private static class TrueSerializer
    extends Serializer<TrueItem> {
        private TrueSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, TrueItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, TrueItem item) {
            destination.append("true");
            return false;
        }
    }

    private static class FalseSerializer
    extends Serializer<FalseItem> {
        private FalseSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, FalseItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, FalseItem item) {
            destination.append("false");
            return false;
        }
    }

    private static class NearSerializer
    extends Serializer<NearItem> {
        private NearSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, NearItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, NearItem item) {
            String annotations = NearSerializer.nearAnnotations(item);
            destination.append(VespaSerializer.getIndexName(item.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("near").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = item.getItemIterator();
            while (i.hasNext()) {
                WordItem close = (WordItem)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                destination.append('\"');
                VespaSerializer.escape(close.getIndexedString(), destination).append('\"');
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }

        static String nearAnnotations(NearItem n) {
            if (n.getDistance() != 2) {
                return "{distance: " + n.getDistance() + "}";
            }
            return "";
        }
    }

    private static class NearestNeighborSerializer
    extends Serializer<NearestNeighborItem> {
        private NearestNeighborSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, NearestNeighborItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, NearestNeighborItem item) {
            boolean allow_approx;
            int explore;
            destination.append("{");
            int initLen = destination.length();
            destination.append(VespaSerializer.leafAnnotations(item));
            VespaSerializer.comma(destination, initLen);
            int targetNumHits = item.getTargetNumHits();
            VespaSerializer.annotationKey(destination, "targetNumHits").append(targetNumHits);
            double distanceThreshold = item.getDistanceThreshold();
            if (distanceThreshold < Double.POSITIVE_INFINITY) {
                VespaSerializer.comma(destination, initLen);
                String key = "distanceThreshold";
                VespaSerializer.annotationKey(destination, key).append(distanceThreshold);
            }
            if ((explore = item.getHnswExploreAdditionalHits()) != 0) {
                VespaSerializer.comma(destination, initLen);
                String key = "hnsw.exploreAdditionalHits";
                VespaSerializer.annotationKey(destination, key).append(explore);
            }
            if (!(allow_approx = item.getAllowApproximate())) {
                VespaSerializer.comma(destination, initLen);
                VespaSerializer.annotationKey(destination, "approximate").append(allow_approx);
            }
            destination.append("}");
            destination.append("nearestNeighbor").append('(');
            destination.append(item.getIndexName()).append(", ");
            destination.append(item.getQueryTensorName()).append(')');
            return false;
        }
    }

    private static class NotSerializer
    extends Serializer<NotItem> {
        private NotSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, NotItem item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            if (state.peekFirst().subItems == 1) {
                return ") AND !(";
            }
            return " OR ";
        }

        @Override
        boolean serialize(StringBuilder destination, NotItem item) {
            destination.append("(");
            return true;
        }
    }

    private static class NullSerializer
    extends Serializer<NullItem> {
        private NullSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, NullItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, NullItem item) {
            throw new NullItemException("NullItem encountered in query tree. This is usually a symptom of an invalid query or an error in a query transformer.");
        }
    }

    private static class ONearSerializer
    extends Serializer<ONearItem> {
        private ONearSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, ONearItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, ONearItem item) {
            String annotations = NearSerializer.nearAnnotations(item);
            destination.append(VespaSerializer.getIndexName(item.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("onear").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = item.getItemIterator();
            while (i.hasNext()) {
                WordItem close = (WordItem)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                destination.append('\"');
                VespaSerializer.escape(close.getIndexedString(), destination).append('\"');
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class OrSerializer
    extends Serializer<OrItem> {
        private OrSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, OrItem item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return " OR ";
        }

        @Override
        boolean serialize(StringBuilder destination, OrItem item) {
            destination.append("(");
            return true;
        }
    }

    private static class PhraseSerializer
    extends Serializer<PhraseItem> {
        private PhraseSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, PhraseItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, PhraseItem item) {
            return PhraseSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, PhraseItem phrase, boolean includeField) {
            String annotations = VespaSerializer.leafAnnotations(phrase);
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(phrase.getIndexName())).append(" contains ");
            }
            if (annotations.length() > 0) {
                destination.append("({").append(annotations).append("}");
            }
            destination.append("phrase").append('(');
            for (int i = 0; i < phrase.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if ((current = phrase.getItem(i)) instanceof WordItem) {
                    WordSerializer.serializeWordWithoutIndex(destination, current);
                    continue;
                }
                if (current instanceof PhraseSegmentItem) {
                    PhraseSegmentSerializer.serialize(destination, current, false);
                    continue;
                }
                if (current instanceof WordAlternativesItem) {
                    WordAlternativesSerializer.serialize(destination, (WordAlternativesItem)current, false);
                    continue;
                }
                throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in phrases not implemented, please report this as a bug.");
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class SameElementSerializer
    extends Serializer<SameElementItem> {
        private SameElementSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, SameElementItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, SameElementItem item) {
            return SameElementSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, SameElementItem item, boolean includeField) {
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(item.getFieldName())).append(" contains ");
            }
            destination.append("sameElement").append('(');
            for (int i = 0; i < item.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if ((current = item.getItem(i)) instanceof WordItem) {
                    new WordSerializer().serialize(destination, (WordItem)current);
                    continue;
                }
                if (current instanceof IntItem) {
                    new NumberSerializer().serialize(destination, (IntItem)current);
                    continue;
                }
                throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in same_element is not implemented, please report this as a bug.");
            }
            destination.append(')');
            return false;
        }
    }

    private static class PhraseSegmentSerializer
    extends Serializer<PhraseSegmentItem> {
        private PhraseSegmentSerializer() {
        }

        private static void serializeWords(StringBuilder destination, PhraseSegmentItem segment) {
            for (int i = 0; i < segment.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if (!((current = segment.getItem(i)) instanceof WordItem)) {
                    throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in phrases not implemented, please report this as a bug.");
                }
                destination.append('\"');
                VespaSerializer.escape(((WordItem)current).getIndexedString(), destination).append('\"');
            }
        }

        @Override
        void onExit(StringBuilder destination, PhraseSegmentItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, PhraseSegmentItem item) {
            return PhraseSegmentSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, Item item, boolean includeField) {
            int length;
            int offset;
            String image;
            PhraseSegmentItem phrase = (PhraseSegmentItem)item;
            Substring origin = phrase.getOrigin();
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(phrase.getIndexName())).append(" contains ");
            }
            if (origin == null) {
                image = phrase.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            destination.append("({");
            VespaSerializer.serializeOrigin(destination, image, offset, length);
            String annotations = VespaSerializer.leafAnnotations(phrase);
            if (annotations.length() > 0) {
                destination.append(", ").append(annotations);
            }
            if (phrase.getSegmentingRule() == SegmentingRule.BOOLEAN_AND) {
                destination.append(", ").append('\"').append("andSegmenting").append("\": true");
            }
            destination.append("}");
            destination.append("phrase").append('(');
            PhraseSegmentSerializer.serializeWords(destination, phrase);
            destination.append("))");
            return false;
        }
    }

    private static class PredicateQuerySerializer
    extends Serializer<PredicateQueryItem> {
        private PredicateQuerySerializer() {
        }

        @Override
        void onExit(StringBuilder destination, PredicateQueryItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, PredicateQueryItem item) {
            destination.append("predicate(").append(item.getIndexName()).append(',');
            this.appendFeatures(destination, item.getFeatures());
            destination.append(',');
            this.appendFeatures(destination, item.getRangeFeatures());
            destination.append(')');
            return false;
        }

        private void appendFeatures(StringBuilder destination, Collection<? extends PredicateQueryItem.EntryBase> features) {
            if (features.isEmpty()) {
                destination.append('0');
                return;
            }
            destination.append('{');
            boolean first = true;
            for (PredicateQueryItem.EntryBase entryBase : features) {
                if (!first) {
                    destination.append(',');
                }
                if (entryBase.getSubQueryBitmap() != -1L) {
                    destination.append("\"0x").append(Long.toHexString(entryBase.getSubQueryBitmap()));
                    destination.append("\":{");
                    this.appendKeyValue(destination, entryBase);
                    destination.append('}');
                } else {
                    this.appendKeyValue(destination, entryBase);
                }
                first = false;
            }
            destination.append('}');
        }

        private void appendKeyValue(StringBuilder destination, PredicateQueryItem.EntryBase entry) {
            destination.append('\"');
            VespaSerializer.escape(entry.getKey(), destination);
            destination.append("\":");
            if (entry instanceof PredicateQueryItem.Entry) {
                destination.append('\"');
                VespaSerializer.escape(((PredicateQueryItem.Entry)entry).getValue(), destination);
                destination.append('\"');
            } else {
                destination.append(((PredicateQueryItem.RangeEntry)entry).getValue());
                destination.append('L');
            }
        }
    }

    private static class WordAlternativesSerializer
    extends Serializer<WordAlternativesItem> {
        private WordAlternativesSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WordAlternativesItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, WordAlternativesItem item) {
            return WordAlternativesSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, WordAlternativesItem alternatives, boolean includeField) {
            int initLen;
            boolean needsAnnotations;
            String annotations = VespaSerializer.leafAnnotations(alternatives);
            Substring origin = alternatives.getOrigin();
            boolean isFromQuery = alternatives.isFromQuery();
            boolean bl = needsAnnotations = annotations.length() > 0 || origin != null || !isFromQuery;
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(alternatives.getIndexName())).append(" contains ");
            }
            if (needsAnnotations) {
                destination.append("({");
                initLen = destination.length();
                if (origin != null) {
                    String image = origin.getSuperstring();
                    int offset = origin.start;
                    int length = origin.end - origin.start;
                    VespaSerializer.serializeOrigin(destination, image, offset, length);
                }
                if (!isFromQuery) {
                    VespaSerializer.comma(destination, initLen);
                    destination.append("implicitTransforms").append(": false");
                }
                if (annotations.length() > 0) {
                    VespaSerializer.comma(destination, initLen);
                    destination.append(annotations);
                }
                destination.append("}");
            }
            destination.append("alternatives").append("({");
            initLen = destination.length();
            ArrayList<WordAlternativesItem.Alternative> sortedAlternatives = new ArrayList<WordAlternativesItem.Alternative>(alternatives.getAlternatives());
            Collections.sort(sortedAlternatives, (x, y) -> Double.compare(y.exactness, x.exactness));
            for (WordAlternativesItem.Alternative alternative : sortedAlternatives) {
                VespaSerializer.comma(destination, initLen);
                destination.append('\"');
                VespaSerializer.escape(alternative.word, destination);
                destination.append("\": ").append(alternative.exactness);
            }
            destination.append("})");
            if (needsAnnotations) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class RangeSerializer
    extends Serializer<RangeItem> {
        private RangeSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, RangeItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, RangeItem range) {
            String annotations = VespaSerializer.leafAnnotations(range);
            if (annotations.length() > 0) {
                destination.append("{").append(annotations).append("}");
            }
            destination.append("range").append('(').append(VespaSerializer.normalizeIndexName(range.getIndexName())).append(", ");
            this.appendNumberImage(destination, range.getFrom());
            destination.append(", ");
            this.appendNumberImage(destination, range.getTo());
            destination.append(')');
            return false;
        }

        private void appendNumberImage(StringBuilder destination, Number number) {
            destination.append(number.toString());
            if (number instanceof Long) {
                destination.append('L');
            }
        }
    }

    private static class RankSerializer
    extends Serializer<RankItem> {
        private RankSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, RankItem item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return ", ";
        }

        @Override
        boolean serialize(StringBuilder destination, RankItem item) {
            destination.append("rank").append('(');
            return true;
        }
    }

    private static class WandSerializer
    extends Serializer<WandItem> {
        private WandSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WandItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, WandItem item) {
            VespaSerializer.serializeWeightedSetContents(destination, "wand", item, this.specificAnnotations(item));
            return false;
        }

        private String specificAnnotations(WandItem w) {
            StringBuilder annotations = new StringBuilder();
            int targetNumHits = w.getTargetNumHits();
            double scoreThreshold = w.getScoreThreshold();
            double thresholdBoostFactor = w.getThresholdBoostFactor();
            if (targetNumHits != 10) {
                annotations.append("targetNumHits").append(": ").append(targetNumHits);
            }
            if (scoreThreshold != 0.0) {
                VespaSerializer.comma(annotations, 0);
                annotations.append("scoreThreshold").append(": ").append(scoreThreshold);
            }
            if (thresholdBoostFactor != 1.0) {
                VespaSerializer.comma(annotations, 0);
                annotations.append("thresholdBoostFactor").append(": ").append(thresholdBoostFactor);
            }
            return annotations.toString();
        }
    }

    private static class WeakAndSerializer
    extends Serializer<WeakAndItem> {
        private WeakAndSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WeakAndItem item) {
            destination.append(')');
            if (this.needsAnnotationBlock(item)) {
                destination.append(')');
            }
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return ", ";
        }

        private boolean needsAnnotationBlock(WeakAndItem item) {
            return this.nonDefaultTargetNumHits(item);
        }

        @Override
        boolean serialize(StringBuilder destination, WeakAndItem item) {
            if (this.needsAnnotationBlock(item)) {
                destination.append("({");
            }
            if (this.nonDefaultTargetNumHits(item)) {
                destination.append("targetNumHits").append(": ").append(item.getN());
            }
            if (this.needsAnnotationBlock(item)) {
                destination.append("}");
            }
            destination.append("weakAnd").append('(');
            return true;
        }

        private boolean nonDefaultTargetNumHits(WeakAndItem w) {
            return w.getN() != 100;
        }
    }

    private static class WeightedSetSerializer
    extends Serializer<WeightedSetItem> {
        private WeightedSetSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, WeightedSetItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, WeightedSetItem item) {
            VespaSerializer.serializeWeightedSetContents(destination, "weightedSet", item);
            return false;
        }
    }

    private static class RegExpSerializer
    extends Serializer<RegExpItem> {
        private RegExpSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, RegExpItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, RegExpItem regexp) {
            String annotations = VespaSerializer.leafAnnotations(regexp);
            destination.append(VespaSerializer.normalizeIndexName(regexp.getIndexName())).append(" matches ");
            VespaSerializer.annotatedTerm(destination, regexp, annotations);
            return false;
        }
    }

    private static class UriSerializer
    extends Serializer<UriItem> {
        private UriSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, UriItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, UriItem uriItem) {
            String annotations = UriSerializer.uriAnnotations(uriItem);
            destination.append(uriItem.getIndexName()).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("uri").append("(\"");
            destination.append(uriItem.getArgumentString());
            destination.append("\")");
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }

        static String uriAnnotations(UriItem item) {
            if (item.hasStartAnchor() == item.isStartAnchorDefault() && item.hasEndAnchor() == item.isEndAnchorDefault()) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            b.append("{");
            if (item.hasStartAnchor() != item.isStartAnchorDefault()) {
                b.append("startAnchor: " + item.hasStartAnchor());
            }
            if (item.hasEndAnchor() != item.isEndAnchorDefault()) {
                if (b.length() > 2) {
                    b.append(", ");
                }
                b.append("endAnchor: " + item.hasEndAnchor());
            }
            b.append("}");
            return b.toString();
        }
    }

    private static class FuzzySerializer
    extends Serializer<FuzzyItem> {
        private FuzzySerializer() {
        }

        @Override
        void onExit(StringBuilder destination, FuzzyItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, FuzzyItem fuzzy) {
            String annotations = FuzzySerializer.fuzzyAnnotations(fuzzy);
            destination.append(VespaSerializer.normalizeIndexName(fuzzy.getIndexName())).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("fuzzy").append('(');
            destination.append('\"');
            VespaSerializer.escape(fuzzy.getIndexedString(), destination).append('\"');
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }

        static String fuzzyAnnotations(FuzzyItem fuzzyItem) {
            boolean anyAnnotationSet;
            boolean isMaxEditDistanceSet = fuzzyItem.getMaxEditDistance() != FuzzyItem.DEFAULT_MAX_EDIT_DISTANCE;
            boolean isPrefixLengthSet = fuzzyItem.getPrefixLength() != FuzzyItem.DEFAULT_PREFIX_LENGTH;
            boolean isPrefixMatch = fuzzyItem.isPrefixMatch();
            boolean bl = anyAnnotationSet = isMaxEditDistanceSet || isPrefixLengthSet || isPrefixMatch;
            if (!anyAnnotationSet) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            if (isMaxEditDistanceSet) {
                builder.append("maxEditDistance:").append(fuzzyItem.getMaxEditDistance());
                if (isPrefixLengthSet || isPrefixMatch) {
                    builder.append(",");
                }
            }
            if (isPrefixLengthSet) {
                builder.append("prefixLength:").append(fuzzyItem.getPrefixLength());
                if (isPrefixMatch) {
                    builder.append(",");
                }
            }
            if (isPrefixMatch) {
                builder.append("prefix").append(':').append(fuzzyItem.isPrefixMatch());
            }
            builder.append("}");
            return builder.toString();
        }
    }

    private static class StringInSerializer
    extends Serializer<StringInItem> {
        private StringInSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, StringInItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, StringInItem item) {
            destination.append(item.getIndexName()).append(" in (");
            int initLen = destination.length();
            ArrayList<String> tokens = new ArrayList<String>(item.getTokens());
            Collections.sort(tokens);
            for (String token : tokens) {
                VespaSerializer.comma(destination, initLen);
                destination.append('\"');
                VespaSerializer.escape(token, destination);
                destination.append("\"");
            }
            destination.append(")");
            return false;
        }
    }

    private static class NumericInSerializer
    extends Serializer<NumericInItem> {
        private NumericInSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, NumericInItem item) {
        }

        @Override
        boolean serialize(StringBuilder destination, NumericInItem item) {
            destination.append(item.getIndexName()).append(" in (");
            int initLen = destination.length();
            ArrayList<Long> tokens = new ArrayList<Long>(item.getTokens());
            Collections.sort(tokens);
            for (Long token : tokens) {
                VespaSerializer.comma(destination, initLen);
                destination.append(token.toString());
                if (token >= Integer.MIN_VALUE && token <= Integer.MAX_VALUE) continue;
                destination.append("L");
            }
            destination.append(")");
            return false;
        }
    }

    private static final class SerializerWrapper {
        int subItems = 0;
        final Serializer type;
        final Item item;

        SerializerWrapper(Serializer type, Item item) {
            this.type = type;
            this.item = item;
        }
    }

    private static abstract class Serializer<ITEM extends Item> {
        private Serializer() {
        }

        abstract void onExit(StringBuilder var1, ITEM var2);

        String separator(Deque<SerializerWrapper> state) {
            throw new UnsupportedOperationException("Having several items for this query operator serializer, " + this.getClass().getSimpleName() + ", not yet implemented.");
        }

        abstract boolean serialize(StringBuilder var1, ITEM var2);
    }
}

