/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.significance;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.language.significance.DocumentFrequency;
import com.yahoo.language.significance.SignificanceModel;
import com.yahoo.language.significance.SignificanceModelRegistry;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.Schema;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Provides(value={"Significance"})
@Before(value={"Stemming"})
public class SignificanceSearcher
extends Searcher {
    public static final String SIGNIFICANCE = "Significance";
    private static final Logger log = Logger.getLogger(SignificanceSearcher.class.getName());
    private final SignificanceModelRegistry significanceModelRegistry;
    private final SchemaInfo schemaInfo;

    @Inject
    public SignificanceSearcher(SignificanceModelRegistry significanceModelRegistry, SchemaInfo schemaInfo) {
        this.significanceModelRegistry = significanceModelRegistry;
        this.schemaInfo = schemaInfo;
    }

    @Override
    public Result search(Query query, Execution execution) {
        String rankProfileName = query.getRanking().getProfile();
        Map<String, Boolean> perSchemaSetup = this.schemaInfo.newSession(query).schemas().stream().collect(Collectors.toMap(Schema::name, schema -> Optional.ofNullable(schema.rankProfiles().get(rankProfileName)).map(RankProfile::useSignificanceModel).orElse(false)));
        HashSet<Boolean> uniqueSetups = new HashSet<Boolean>(perSchemaSetup.values());
        if (uniqueSetups.size() > 1) {
            Result result = new Result(query);
            result.hits().addError(ErrorMessage.createIllegalQuery("Inconsistent 'significance' configuration for the rank profile '%s' in the schemas %s. Use 'restrict' to limit the query to a subset of schemas (https://docs.vespa.ai/en/schemas.html#multiple-schemas). Specify same 'significance' configuration for all selected schemas (https://docs.vespa.ai/en/reference/schema-reference.html#significance).".formatted(rankProfileName, perSchemaSetup.keySet())));
            return result;
        }
        if (perSchemaSetup.isEmpty()) {
            return execution.search(query);
        }
        Boolean useSignificanceModel = uniqueSetups.iterator().next();
        if (!useSignificanceModel.booleanValue()) {
            return execution.search(query);
        }
        Language language = query.getModel().getParsingLanguage();
        Optional model = this.significanceModelRegistry.getModel(language);
        if (model.isEmpty()) {
            return execution.search(query);
        }
        this.setIDF(query.getModel().getQueryTree().getRoot(), (SignificanceModel)model.get());
        return execution.search(query);
    }

    private void setIDF(Item root, SignificanceModel significanceModel) {
        if (root == null || root instanceof NullItem) {
            return;
        }
        if (root instanceof WordItem) {
            DocumentFrequency documentFrequency = significanceModel.documentFrequency(((WordItem)root).getWord());
            long N = documentFrequency.corpusSize();
            long nq_i = documentFrequency.frequency();
            double idf = SignificanceSearcher.calculateIDF(N, nq_i);
            ((WordItem)root).setSignificance(idf);
        } else if (root instanceof CompositeItem) {
            for (int i = 0; i < ((CompositeItem)root).getItemCount(); ++i) {
                this.setIDF(((CompositeItem)root).getItem(i), significanceModel);
            }
        }
    }

    public static double calculateIDF(long N, long nq_i) {
        return Math.log(1.0 + ((double)(N - nq_i) + 0.5) / ((double)nq_i + 0.5));
    }
}

