/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;

public class CacheControlSearcher
extends Searcher {
    private static final CompoundName cachecontrolNocache = CompoundName.from((String)"cachecontrol.nocache");
    private static final CompoundName cachecontrolMaxage = CompoundName.from((String)"cachecontrol.maxage");
    private static final CompoundName cachecontrolStaleage = CompoundName.from((String)"cachecontrol.staleage");
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";

    @Override
    public Result search(Query query, Execution execution) {
        int staleage;
        query.trace("CacheControlSearcher: Running version $Revision$", false, 6);
        Result result = execution.search(query);
        query = result.getQuery();
        if (result.getHeaders(true) == null) {
            query.trace("CacheControlSearcher: No HTTP header map available - skipping searcher.", false, 5);
            return result;
        }
        if (query.properties().getBoolean(cachecontrolNocache, false) || query.getNoCache()) {
            result.getHeaders(true).put((Object)CACHE_CONTROL_HEADER, (Object)"no-cache");
            query.trace("CacheControlSearcher: Added no-cache header", false, 4);
            return result;
        }
        int maxage = query.properties().getInteger(cachecontrolMaxage, -1);
        if (maxage > 0) {
            result.getHeaders(true).put((Object)CACHE_CONTROL_HEADER, (Object)("max-age=" + maxage));
            query.trace("CacheControlSearcher: Set max-age header to " + maxage, false, 4);
        }
        if ((staleage = query.properties().getInteger(cachecontrolStaleage, -1).intValue()) > 0) {
            result.getHeaders(true).put((Object)CACHE_CONTROL_HEADER, (Object)("stale-while-revalidate=" + staleage));
            query.trace("CacheControlSearcher: Set stale-while-revalidate header to " + staleage, false, 4);
        }
        return result;
    }
}

