/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.api.annotations.Beta;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public class DocumentSummary {
    private final String name;
    private final Map<String, Field> fields;
    private final boolean dynamic;

    private DocumentSummary(Builder builder) {
        this.name = builder.name;
        this.fields = Collections.unmodifiableMap(builder.fields);
        this.dynamic = builder.dynamic;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Field> fields() {
        return this.fields;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentSummary)) {
            return false;
        }
        DocumentSummary other = (DocumentSummary)o;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (other.dynamic != this.dynamic) {
            return false;
        }
        return other.fields.equals(this.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dynamic, this.fields);
    }

    public String toString() {
        return "document summary '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private final Map<String, Field> fields = new LinkedHashMap<String, Field>();
        private boolean dynamic;

        public Builder(String name) {
            this.name = name;
        }

        public Builder addField(String name, String type) {
            this.fields.put(name, new Field(name, type));
            return this;
        }

        public Builder add(Field field) {
            this.fields.put(field.name(), field);
            return this;
        }

        public Builder setDynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public DocumentSummary build() {
            return new DocumentSummary(this);
        }
    }

    public static class Field {
        private final String name;
        private final Type type;

        public Field(String name, String type) {
            this(name, Type.fromString(type));
        }

        public Field(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.name.equals(this.name)) {
                return false;
            }
            return other.type == this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public String toString() {
            return "summary field '" + this.name + "' " + this.type;
        }

        public static enum Type {
            bool,
            byteType("byte"),
            shortType("short"),
            integer,
            int64,
            float16,
            floatType("float"),
            doubleType("double"),
            string,
            data,
            raw,
            longstring,
            longdata,
            jsonstring,
            featuredata,
            xmlstring,
            tensor;

            private final String name;

            private Type() {
                this(null);
            }

            private Type(String name) {
                this.name = name;
            }

            public String asString() {
                return this.name != null ? this.name : this.name();
            }

            public String toString() {
                return this.asString();
            }

            public static Type fromString(String name) {
                return Arrays.stream(Type.values()).filter(t -> name.equals(t.asString())).findAny().orElseThrow();
            }
        }
    }
}

