/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.ranking.Normalizer;
import java.util.Arrays;

class ReciprocalRankNormalizer
extends Normalizer {
    private final double k;

    ReciprocalRankNormalizer(int maxSize, double k) {
        super(maxSize);
        this.k = k;
    }

    @Override
    void normalize() {
        int i;
        if (this.size < 1) {
            return;
        }
        IdxScore[] temp = new IdxScore[this.size];
        for (i = 0; i < this.size; ++i) {
            double val = this.data[i];
            if (Double.isNaN(val)) {
                val = Double.NEGATIVE_INFINITY;
            }
            temp[i] = new IdxScore(i, val);
        }
        Arrays.sort(temp, (a, b) -> Double.compare(b.score, a.score));
        for (i = 0; i < this.size; ++i) {
            int idx = temp[i].index;
            double old = this.data[idx];
            this.data[idx] = 1.0 / (this.k + 1.0 + (double)i);
        }
    }

    @Override
    String normalizing() {
        return "reciprocal-rank{k:" + this.k + "}";
    }

    record IdxScore(int index, double score) {
    }
}

