/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.ranking.Evaluator;
import com.yahoo.search.ranking.MatchFeatureInput;
import com.yahoo.search.ranking.NormalizerContext;
import com.yahoo.search.ranking.WrappedHit;
import com.yahoo.tensor.Tensor;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;

class HitRescorer {
    private static final Logger logger = Logger.getLogger(HitRescorer.class.getName());
    private final Supplier<Evaluator> mainEvalSrc;
    private final List<MatchFeatureInput> mainFromMF;
    private final List<NormalizerContext> normalizers;

    public HitRescorer(Supplier<Evaluator> mainEvalSrc, List<MatchFeatureInput> mainFromMF, List<NormalizerContext> normalizers) {
        this.mainEvalSrc = mainEvalSrc;
        this.mainFromMF = mainFromMF;
        this.normalizers = normalizers;
    }

    void preprocess(WrappedHit wrapped) {
        for (NormalizerContext n : this.normalizers) {
            Evaluator scorer = n.evalSource().get();
            double val = HitRescorer.evalScorer(wrapped, scorer, n.fromMF());
            wrapped.setIdx(n.normalizer().addInput(val));
        }
    }

    void runNormalizers() {
        for (NormalizerContext n : this.normalizers) {
            n.normalizer().normalize();
        }
    }

    double rescoreHit(WrappedHit wrapped) {
        Evaluator scorer = this.mainEvalSrc.get();
        for (NormalizerContext n : this.normalizers) {
            double normalizedValue = n.normalizer().getOutput(wrapped.getIdx());
            scorer.bind(n.name(), Tensor.from((double)normalizedValue));
        }
        double newScore = HitRescorer.evalScorer(wrapped, scorer, this.mainFromMF);
        wrapped.setScore(newScore);
        return newScore;
    }

    private static double evalScorer(WrappedHit wrapped, Evaluator scorer, List<MatchFeatureInput> fromMF) {
        for (MatchFeatureInput argSpec : fromMF) {
            Tensor asTensor = wrapped.getTensor(argSpec.matchFeatureName());
            if (asTensor != null) {
                scorer.bind(argSpec.inputName(), asTensor);
                continue;
            }
            logger.warning("Missing match-feature for Evaluator argument: " + argSpec.inputName());
            return 0.0;
        }
        return scorer.evaluateScore();
    }
}

