/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import ai.vespa.cloud.ZoneInfo;
import com.yahoo.collections.Pair;
import com.yahoo.language.process.Embedder;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.properties.PropertyMap;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.profile.ChainedMap;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.DimensionalValue;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.tensor.Tensor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProfileProperties
extends Properties {
    private static final String ENVIRONMENT = "environment";
    private static final String REGION = "region";
    private static final String INSTANCE = "instance";
    private final CompiledQueryProfile profile;
    private final Map<String, Embedder> embedders;
    private final ZoneInfo zoneInfo;
    private final Map<String, String> zoneContext;
    private Map<CompoundName, Object> values = null;
    private List<Pair<CompoundName, CompiledQueryProfile>> references = null;

    public QueryProfileProperties(CompiledQueryProfile profile) {
        this(profile, Embedder.throwsOnUse.asMap(), ZoneInfo.defaultInfo());
    }

    @Deprecated
    public QueryProfileProperties(CompiledQueryProfile profile, Embedder embedder) {
        this(profile, Map.of("default", embedder), ZoneInfo.defaultInfo());
    }

    @Deprecated
    public QueryProfileProperties(CompiledQueryProfile profile, Map<String, Embedder> embedders) {
        this(profile, embedders, ZoneInfo.defaultInfo());
    }

    public QueryProfileProperties(CompiledQueryProfile profile, Map<String, Embedder> embedders, ZoneInfo zoneInfo) {
        Validator.ensureNotNull((String)"The profile wrapped by this cannot be null", (Object)profile);
        this.profile = profile;
        this.embedders = embedders;
        this.zoneInfo = zoneInfo;
        this.zoneContext = Map.of(ENVIRONMENT, zoneInfo.zone().environment().name(), REGION, zoneInfo.zone().region(), INSTANCE, zoneInfo.application().instance());
    }

    public CompiledQueryProfile getQueryProfile() {
        return this.profile;
    }

    public Object get(CompoundName name, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        context = this.contextWithZoneInfo(context);
        name = this.unalias(name, context);
        if (this.values != null && this.values.containsKey(name)) {
            return this.values.get(name);
        }
        Pair<CompoundName, CompiledQueryProfile> reference = this.findReference(name);
        if (reference != null) {
            if (reference.getSecond() == null) {
                return null;
            }
            return ((CompiledQueryProfile)reference.getSecond()).get(name.rest(((CompoundName)reference.getFirst()).size()), context, substitution);
        }
        Object value = this.profile.get(name, context, substitution);
        if (value != null) {
            return value;
        }
        return super.get(name, context, substitution);
    }

    public void set(CompoundName name, Object value, Map<String, String> context) {
        context = this.contextWithZoneInfo(context);
        this.setOrCheckSettable(name, value, context, true);
    }

    @Override
    public void requireSettable(CompoundName name, Object value, Map<String, String> context) {
        context = this.contextWithZoneInfo(context);
        this.setOrCheckSettable(name, value, context, false);
    }

    private void setOrCheckSettable(CompoundName name, Object value, Map<String, String> context, boolean set) {
        try {
            name = this.unalias(name, context);
            if (context == null) {
                context = Map.of();
            }
            if (!this.profile.isOverridable(name, context)) {
                return;
            }
            Pair<CompoundName, CompiledQueryProfile> runtimeReference = this.findReference(name);
            if (runtimeReference != null && !((CompiledQueryProfile)runtimeReference.getSecond()).isOverridable(name.rest(((CompoundName)runtimeReference.getFirst()).size()), context)) {
                return;
            }
            if (!this.profile.getTypes().isEmpty()) {
                value = this.convertByType(name, value, context);
            }
            if (value instanceof String && value.toString().startsWith("ref:")) {
                if (this.profile.getRegistry() == null) {
                    throw new IllegalInputException("Runtime query profile references does not work when the QueryProfileProperties are constructed without a registry");
                }
                String queryProfileId = value.toString().substring(4);
                CompiledQueryProfile referencedProfile = this.profile.getRegistry().findQueryProfile(queryProfileId);
                if (referencedProfile != null) {
                    value = referencedProfile;
                }
            }
            if (set) {
                if (value instanceof CompiledQueryProfile) {
                    if (this.references == null) {
                        this.references = new ArrayList<Pair<CompoundName, CompiledQueryProfile>>();
                    }
                    this.references.add(0, (Pair<CompoundName, CompiledQueryProfile>)new Pair((Object)name, (Object)((CompiledQueryProfile)value)));
                } else {
                    if (this.values == null) {
                        this.values = new HashMap<CompoundName, Object>();
                    }
                    this.values.put(name, value);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException("Could not set '" + name + "' to '" + this.toShortString(value) + "'", (Throwable)e);
        }
    }

    private String toShortString(Object value) {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof Tensor)) {
            return value.toString();
        }
        return ((Tensor)value).toAbbreviatedString();
    }

    private Object convertByType(CompoundName name, Object value, Map<String, String> context) {
        QueryProfileType explicitTypeFromField = null;
        for (int i = 0; i < name.size(); ++i) {
            QueryProfileType type = explicitTypeFromField != null ? explicitTypeFromField : this.profile.getType(name.first(i), context);
            if (type == null) continue;
            String localName = name.get(i);
            FieldDescription fieldDescription = type.getField(localName);
            if (fieldDescription == null && type.isStrict()) {
                throw new IllegalInputException("'" + localName + "' is not declared in " + type + ", and the type is strict");
            }
            if (fieldDescription == null) continue;
            if (i == name.size() - 1) {
                ConversionContext conversionContext = new ConversionContext(localName, this.profile.getRegistry(), this.embedders, context, (Properties)this);
                Object convertedValue = fieldDescription.getType().convertFrom(value, conversionContext);
                if (convertedValue == null && fieldDescription.getType() instanceof QueryProfileFieldType && ((QueryProfileFieldType)fieldDescription.getType()).getQueryProfileType() != null) {
                    FieldDescription queryProfileValueDescription = ((QueryProfileFieldType)fieldDescription.getType()).getQueryProfileType().getField("");
                    if (queryProfileValueDescription != null && (convertedValue = queryProfileValueDescription.getType().convertFrom(value, conversionContext)) == null) {
                        throw new IllegalInputException("'" + value + "' is neither a " + fieldDescription.getType().toInstanceDescription() + " nor a " + queryProfileValueDescription.getType().toInstanceDescription());
                    }
                } else if (convertedValue == null) {
                    throw new IllegalInputException("'" + value + "' is not a " + fieldDescription.getType().toInstanceDescription());
                }
                value = convertedValue;
                continue;
            }
            if (!(fieldDescription.getType() instanceof QueryProfileFieldType)) continue;
            explicitTypeFromField = ((QueryProfileFieldType)fieldDescription.getType()).getQueryProfileType();
        }
        return value;
    }

    public void clearAll(CompoundName name, Map<String, String> context) {
        if (this.references == null) {
            this.references = new ArrayList<Pair<CompoundName, CompiledQueryProfile>>();
        }
        this.references.add((Pair<CompoundName, CompiledQueryProfile>)new Pair((Object)name, null));
        if (this.values != null) {
            this.values.keySet().removeIf(key -> key.hasPrefix(name));
        }
    }

    public Map<String, Object> listProperties(CompoundName path, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        context = this.contextWithZoneInfo(context);
        path = this.unalias(path, context);
        if (context == null) {
            context = Map.of();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.profile.listValues(path, context, substitution).entrySet()) {
            if (this.references != null && this.containsNullParentOf(path, this.references)) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.putAll(super.listProperties(path, context, substitution));
        if (this.references != null) {
            for (Pair pair : this.references) {
                CompoundName prefixToReferenceKeys;
                CompoundName pathInReference;
                if (!((CompoundName)pair.getFirst()).hasPrefix(path.first(Math.min(((CompoundName)pair.getFirst()).size(), path.size())))) continue;
                if (((CompoundName)pair.getFirst()).size() > path.size()) {
                    pathInReference = CompoundName.empty;
                    prefixToReferenceKeys = ((CompoundName)pair.getFirst()).rest(path.size());
                } else {
                    pathInReference = path.rest(((CompoundName)pair.getFirst()).size());
                    prefixToReferenceKeys = CompoundName.empty;
                }
                if (pair.getSecond() == null) {
                    if (!((CompoundName)pair.getFirst()).hasPrefix(path)) continue;
                    properties.put(prefixToReferenceKeys.toString(), null);
                    continue;
                }
                for (Map.Entry<String, Object> valueEntry : ((CompiledQueryProfile)pair.getSecond()).listValues(pathInReference, context, substitution).entrySet()) {
                    properties.put(prefixToReferenceKeys.append(new CompoundName(valueEntry.getKey())).toString(), valueEntry.getValue());
                }
            }
        }
        if (this.values != null) {
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                if (!((CompoundName)entry.getKey()).hasPrefix(path)) continue;
                properties.put(((CompoundName)entry.getKey()).rest(path.size()).toString(), entry.getValue());
            }
        }
        return properties;
    }

    public boolean isComplete(StringBuilder firstMissingName, Map<String, String> context) {
        if (!this.reachableTypesAreComplete(CompoundName.empty, this.profile, firstMissingName, context)) {
            return false;
        }
        if (this.references == null) {
            return true;
        }
        for (Pair<CompoundName, CompiledQueryProfile> reference : this.references) {
            if (this.reachableTypesAreComplete((CompoundName)reference.getFirst(), (CompiledQueryProfile)reference.getSecond(), firstMissingName, context)) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> contextWithZoneInfo(Map<String, String> context) {
        if (this.zoneInfo == ZoneInfo.defaultInfo()) {
            return context;
        }
        if (context == null || context.isEmpty()) {
            return this.zoneContext;
        }
        if (context == this.zoneContext) {
            return context;
        }
        return new ChainedMap<String, String>(context, this.zoneContext);
    }

    private boolean reachableTypesAreComplete(CompoundName prefix, CompiledQueryProfile profile, StringBuilder firstMissingName, Map<String, String> context) {
        for (Map.Entry<CompoundName, DimensionalValue<QueryProfileType>> typeEntry : profile.getTypes().entrySet()) {
            QueryProfileType type = typeEntry.getValue().get(context);
            if (type == null || this.typeIsComplete(prefix.append(typeEntry.getKey()), type, firstMissingName, context)) continue;
            return false;
        }
        return true;
    }

    private boolean typeIsComplete(CompoundName prefix, QueryProfileType type, StringBuilder firstMissingName, Map<String, String> context) {
        if (type == null) {
            return true;
        }
        for (FieldDescription field : type.fields().values()) {
            CompoundName fieldName;
            if (!field.isMandatory() || this.get(fieldName = prefix.append(field.getName()), null) != null || this.hasReference(fieldName) || this.profile.getReferences().get(fieldName, context) != null) continue;
            if (firstMissingName != null) {
                firstMissingName.append(fieldName);
            }
            return false;
        }
        return true;
    }

    private boolean hasReference(CompoundName name) {
        if (this.references == null) {
            return false;
        }
        for (Pair<CompoundName, CompiledQueryProfile> reference : this.references) {
            if (!((CompoundName)reference.getFirst()).equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    private Pair<CompoundName, CompiledQueryProfile> findReference(CompoundName name) {
        if (this.references == null) {
            return null;
        }
        for (Pair<CompoundName, CompiledQueryProfile> entry : this.references) {
            if (!name.hasPrefix((CompoundName)entry.getFirst())) continue;
            return entry;
        }
        return null;
    }

    private boolean containsNullParentOf(CompoundName path, List<Pair<CompoundName, CompiledQueryProfile>> properties) {
        if (properties.contains(new Pair((Object)path, (Object)null))) {
            return true;
        }
        return path.size() > 0 && this.containsNullParentOf(path.first(path.size() - 1), properties);
    }

    CompoundName unalias(CompoundName name, Map<String, String> context) {
        if (this.profile.getTypes().isEmpty()) {
            return name;
        }
        CompoundName unaliasedName = name;
        for (int i = 0; i < name.size(); ++i) {
            QueryProfileType type = this.profile.getType(name.first(i), context);
            if (type == null || type.aliases() == null || type.aliases().isEmpty()) continue;
            String localName = name.get(i);
            String unaliasedLocalName = type.unalias(localName);
            unaliasedName = unaliasedName.set(i, unaliasedLocalName);
        }
        return unaliasedName;
    }

    @Override
    public QueryProfileProperties clone() {
        QueryProfileProperties clone = (QueryProfileProperties)super.clone();
        if (this.values != null) {
            clone.values = PropertyMap.cloneMap(this.values);
        }
        return clone;
    }
}

