/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import com.yahoo.data.access.helpers.MatchFeatureData;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.fastsearch.VespaBackend;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.InvokerResult;
import com.yahoo.search.dispatch.LeanHit;
import com.yahoo.search.dispatch.rpc.MapConverter;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.query.profiling.Profiling;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ProtobufSerialization {
    private static final ThreadLocal<GrowableByteBuffer> threadLocalBuffer = ThreadLocal.withInitial(() -> new GrowableByteBuffer(4096));

    static byte[] serializeSearchRequest(Query query, int hits, String serverId, double requestTimeout) {
        return ProtobufSerialization.convertFromQuery(query, hits, serverId, requestTimeout).toByteArray();
    }

    private static void convertSearchReplyErrors(Result target, List<SearchProtocol.Error> errors) {
        for (SearchProtocol.Error error : errors) {
            target.hits().addError(ErrorMessage.createSearchReplyError(error.getMessage()));
        }
    }

    static SearchProtocol.SearchRequest convertFromQuery(Query query, int hits, String serverId, double requestTimeout) {
        SearchProtocol.SearchRequest.Builder builder = SearchProtocol.SearchRequest.newBuilder().setHits(hits).setOffset(query.getOffset()).setTimeout((int)(requestTimeout * 1000.0));
        String documentDb = query.getModel().getDocumentDb();
        if (documentDb != null) {
            builder.setDocumentType(documentDb);
        }
        GrowableByteBuffer scratchPad = threadLocalBuffer.get();
        builder.setQueryTreeBlob(ProtobufSerialization.serializeQueryTree(query.getModel().getQueryTree(), scratchPad));
        if (query.getGroupingSessionCache() || query.getRanking().getQueryCache()) {
            builder.setSessionKey(query.getSessionId(serverId).toString());
        }
        if (query.properties().getBoolean(Model.ESTIMATE)) {
            builder.setHits(0);
        }
        if (GroupingExecutor.hasGroupingList(query)) {
            List<Grouping> groupingList = GroupingExecutor.getGroupingList(query);
            scratchPad.clear();
            BufferSerializer gbuf = new BufferSerializer(scratchPad);
            gbuf.putInt(null, groupingList.size());
            for (Grouping g : groupingList) {
                g.serialize((Serializer)gbuf);
            }
            gbuf.getBuf().flip();
            builder.setGroupingBlob(ByteString.copyFrom((ByteBuffer)gbuf.getBuf().getByteBuffer()));
        }
        if (query.getGroupingSessionCache()) {
            builder.setCacheGrouping(true);
        }
        int traceLevel = ProtobufSerialization.getTraceLevelForBackend(query);
        builder.setTraceLevel(traceLevel);
        builder.setProfileDepth(query.getTrace().getProfileDepth());
        if (traceLevel > 0) {
            ProtobufSerialization.mergeToSearchRequestFromProfiling(query.getTrace().getProfiling(), builder);
        }
        ProtobufSerialization.mergeToSearchRequestFromRanking(query.getRanking(), scratchPad, builder);
        return builder.build();
    }

    public static int getTraceLevelForBackend(Query query) {
        int traceLevel = query.getTrace().getLevel();
        if (query.getModel().getExecution().trace().getForceTimestamps()) {
            traceLevel = Math.max(traceLevel, 5);
        }
        if (query.getTrace().getExplainLevel() > 0) {
            traceLevel = Math.max(traceLevel, query.getTrace().getExplainLevel() + 5);
        }
        return traceLevel;
    }

    private static void mergeToSearchRequestFromRanking(Ranking ranking, GrowableByteBuffer scratchPad, SearchProtocol.SearchRequest.Builder builder) {
        builder.setRankProfile(ranking.getProfile());
        if (ranking.getQueryCache()) {
            builder.setCacheQuery(true);
        }
        if (ranking.getSorting() != null) {
            ProtobufSerialization.mergeToSearchRequestFromSorting(ranking.getSorting(), builder);
        }
        if (ranking.getLocation() != null) {
            builder.setGeoLocation(ranking.getLocation().backendString());
        }
        Map<String, Object> featureMap = ranking.getFeatures().asMap();
        MapConverter.convertMapPrimitives(featureMap, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addFeatureOverrides(arg_0));
        MapConverter.convertMapTensors(scratchPad, featureMap, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addTensorFeatureOverrides(arg_0));
        ProtobufSerialization.mergeRankProperties(ranking, scratchPad, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addRankProperties(arg_0), arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addTensorRankProperties(arg_0));
    }

    private static void mergeToSearchRequestFromSorting(Sorting sorting, SearchProtocol.SearchRequest.Builder builder) {
        for (Sorting.FieldOrder field : sorting.fieldOrders()) {
            SearchProtocol.SortField sortField = SearchProtocol.SortField.newBuilder().setField(field.getSorter().toSerialForm()).setAscending(field.getSortOrder() == Sorting.Order.ASCENDING).build();
            builder.addSorting(sortField);
        }
    }

    private static void mergeToSearchRequestFromProfiling(Profiling prof, SearchProtocol.SearchRequest.Builder builder) {
        SearchProtocol.Profiling.Builder profBuilder = SearchProtocol.Profiling.newBuilder();
        if (prof.getMatching().getDepth() != 0) {
            profBuilder.setMatch(SearchProtocol.ProfilingParams.newBuilder().setDepth(prof.getMatching().getDepth()));
        }
        if (prof.getFirstPhaseRanking().getDepth() != 0) {
            profBuilder.setFirstPhase(SearchProtocol.ProfilingParams.newBuilder().setDepth(prof.getFirstPhaseRanking().getDepth()));
        }
        if (prof.getSecondPhaseRanking().getDepth() != 0) {
            profBuilder.setSecondPhase(SearchProtocol.ProfilingParams.newBuilder().setDepth(prof.getSecondPhaseRanking().getDepth()));
        }
        if (profBuilder.hasMatch() || profBuilder.hasFirstPhase() || profBuilder.hasSecondPhase()) {
            builder.setProfiling(profBuilder);
        }
    }

    static SearchProtocol.DocsumRequest.Builder createDocsumRequestBuilder(Query query, String serverId, String summaryClass, Set<String> fields, boolean includeQueryData, double requestTimeout) {
        Ranking ranking;
        String documentDb;
        SearchProtocol.DocsumRequest.Builder builder = SearchProtocol.DocsumRequest.newBuilder().setTimeout((int)(requestTimeout * 1000.0)).setDumpFeatures(query.properties().getBoolean(Ranking.RANKFEATURES, false));
        if (summaryClass != null) {
            builder.setSummaryClass(summaryClass);
        }
        if (fields != null) {
            builder.addAllFields(fields);
        }
        if ((documentDb = query.getModel().getDocumentDb()) != null) {
            builder.setDocumentType(documentDb);
        }
        if ((ranking = query.getRanking()).getQueryCache()) {
            builder.setCacheQuery(true);
            builder.setSessionKey(query.getSessionId(serverId).toString());
        }
        builder.setRankProfile(ranking.getProfile());
        if (ranking.getLocation() != null) {
            builder.setGeoLocation(ranking.getLocation().backendString());
        }
        GrowableByteBuffer scratchPad = threadLocalBuffer.get();
        if (includeQueryData) {
            ProtobufSerialization.mergeQueryDataToDocsumRequest(query, scratchPad, builder);
        }
        if (query.getTrace().getLevel() >= 3) {
            query.trace((includeQueryData ? "ProtoBuf: Resending " : "Not resending ") + "query during document summary fetching", 3);
        }
        return builder;
    }

    static byte[] serializeDocsumRequest(SearchProtocol.DocsumRequest.Builder builder, List<FastHit> documents) {
        builder.clearGlobalIds();
        for (FastHit hit : documents) {
            builder.addGlobalIds(ByteString.copyFrom((byte[])hit.getRawGlobalId()));
        }
        return builder.build().toByteArray();
    }

    private static void mergeQueryDataToDocsumRequest(Query query, GrowableByteBuffer scratchPad, SearchProtocol.DocsumRequest.Builder builder) {
        Ranking ranking = query.getRanking();
        Map<String, Object> featureMap = ranking.getFeatures().asMap();
        builder.setQueryTreeBlob(ProtobufSerialization.serializeQueryTree(query.getModel().getQueryTree(), scratchPad));
        MapConverter.convertMapPrimitives(featureMap, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addFeatureOverrides(arg_0));
        MapConverter.convertMapTensors(scratchPad, featureMap, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addTensorFeatureOverrides(arg_0));
        if (query.getPresentation().getHighlight() != null) {
            MapConverter.convertStringMultiMap(query.getPresentation().getHighlight().getHighlightTerms(), arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addHighlightTerms(arg_0));
        }
        ProtobufSerialization.mergeRankProperties(ranking, scratchPad, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addRankProperties(arg_0), arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addTensorRankProperties(arg_0));
    }

    static byte[] serializeResult(Result searchResult) {
        return ProtobufSerialization.convertFromResult(searchResult).toByteArray();
    }

    static InvokerResult deserializeToSearchResult(byte[] payload, Query query, VespaBackend searcher, int partId, int distKey) throws InvalidProtocolBufferException {
        SearchProtocol.SearchReply protobuf = SearchProtocol.SearchReply.parseFrom((byte[])payload);
        return ProtobufSerialization.convertToResult(query, protobuf, searcher.getDocumentDatabase(query), partId, distKey);
    }

    static InvokerResult convertToResult(Query query, SearchProtocol.SearchReply protobuf, DocumentDatabase documentDatabase, int partId, int distKey) {
        boolean haveGrouping;
        InvokerResult result = new InvokerResult(query, protobuf.getHitsCount());
        result.getResult().setTotalHitCount(protobuf.getTotalHitCount());
        result.getResult().setCoverage(ProtobufSerialization.convertToCoverage(protobuf));
        ProtobufSerialization.convertSearchReplyErrors(result.getResult(), protobuf.getErrorsList());
        ProtocolStringList featureNames = protobuf.getMatchFeatureNamesList();
        boolean haveMatchFeatures = !featureNames.isEmpty();
        MatchFeatureData matchFeatures = haveMatchFeatures ? new MatchFeatureData((List)featureNames) : null;
        boolean bl = haveGrouping = !protobuf.getGroupingBlob().isEmpty();
        if (haveGrouping) {
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(protobuf.getGroupingBlob().asReadOnlyByteBuffer()));
            int cnt = buf.getInt(null);
            ArrayList<Grouping> list = new ArrayList<Grouping>(cnt);
            for (int i = 0; i < cnt; ++i) {
                Grouping g = new Grouping();
                g.deserialize((Deserializer)buf);
                list.add(g);
            }
            GroupingListHit hit = new GroupingListHit(list, documentDatabase, query);
            result.getResult().hits().add(hit);
        }
        for (SearchProtocol.Hit replyHit : protobuf.getHitsList()) {
            LeanHit hit;
            LeanHit leanHit = hit = replyHit.getSortData().isEmpty() ? new LeanHit(replyHit.getGlobalId().toByteArray(), partId, distKey, replyHit.getRelevance()) : new LeanHit(replyHit.getGlobalId().toByteArray(), partId, distKey, replyHit.getRelevance(), replyHit.getSortData().toByteArray());
            if (haveMatchFeatures) {
                MatchFeatureData.HitValue hitFeatures = matchFeatures.addHit();
                List featureList = replyHit.getMatchFeaturesList();
                if (featureList.size() == featureNames.size()) {
                    int idx = 0;
                    for (SearchProtocol.Feature value : featureList) {
                        ByteString tensorBlob = value.getTensor();
                        if (tensorBlob.isEmpty()) {
                            hitFeatures.set(idx++, value.getNumber());
                            continue;
                        }
                        hitFeatures.set(idx++, tensorBlob.toByteArray());
                    }
                    hit.addMatchFeatures((com.yahoo.data.access.Inspector)hitFeatures);
                } else {
                    result.getResult().hits().addError(ErrorMessage.createBackendCommunicationError("mismatch in match feature sizes"));
                }
            }
            result.getLeanHits().add(hit);
        }
        ByteString slimeTrace = protobuf.getSlimeTrace();
        if (!slimeTrace.isEmpty()) {
            Value.ArrayValue traces = new Value.ArrayValue();
            traces.add((com.yahoo.data.access.Inspector)new SlimeAdapter((Inspector)BinaryFormat.decode((byte[])slimeTrace.toByteArray()).get()));
            query.trace(traces, query.getTrace().getLevel());
        }
        return result;
    }

    private static Coverage convertToCoverage(SearchProtocol.SearchReply protobuf) {
        Coverage coverage = new Coverage(protobuf.getCoverageDocs(), protobuf.getActiveDocs(), 1);
        coverage.setNodesTried(1).setTargetActive(protobuf.getTargetActiveDocs());
        int degradedReason = 0;
        if (protobuf.getDegradedByMatchPhase()) {
            degradedReason |= 1;
        }
        if (protobuf.getDegradedBySoftTimeout()) {
            degradedReason |= 2;
        }
        coverage.setDegradedReason(degradedReason);
        return coverage;
    }

    private static SearchProtocol.SearchReply convertFromResult(Result result) {
        SearchProtocol.SearchReply.Builder builder = SearchProtocol.SearchReply.newBuilder();
        Coverage coverage = result.getCoverage(false);
        if (coverage != null) {
            builder.setCoverageDocs(coverage.getDocs()).setActiveDocs(coverage.getActive()).setTargetActiveDocs(coverage.getTargetActive()).setDegradedBySoftTimeout(coverage.isDegradedByTimeout()).setDegradedByMatchPhase(coverage.isDegradedByMatchPhase());
        }
        result.hits().iterator().forEachRemaining(hit -> {
            SearchProtocol.Hit.Builder hitBuilder = SearchProtocol.Hit.newBuilder();
            if (hit.getRelevance() != null) {
                hitBuilder.setRelevance(hit.getRelevance().getScore());
            }
            if (hit instanceof FastHit) {
                FastHit fhit = (FastHit)hit;
                hitBuilder.setGlobalId(ByteString.copyFrom((byte[])fhit.getRawGlobalId()));
            }
            builder.addHits(hitBuilder);
        });
        return builder.build();
    }

    private static ByteString serializeQueryTree(QueryTree queryTree, GrowableByteBuffer scratchPad) {
        while (true) {
            try {
                scratchPad.clear();
                ByteBuffer treeBuffer = scratchPad.getByteBuffer();
                queryTree.encode(treeBuffer);
                return ByteString.copyFrom((ByteBuffer)treeBuffer.flip());
            }
            catch (BufferOverflowException e) {
                scratchPad.clear();
                scratchPad.grow(scratchPad.capacity() * 2);
                continue;
            }
            break;
        }
    }

    private static void mergeRankProperties(Ranking ranking, GrowableByteBuffer scratchPad, Consumer<SearchProtocol.StringProperty.Builder> stringProperties, Consumer<SearchProtocol.TensorProperty.Builder> tensorProperties) {
        MapConverter.convertMultiMap(scratchPad, ranking.getProperties().asMap(), propB -> {
            if (!"sessionId".equals(propB.getName())) {
                stringProperties.accept((SearchProtocol.StringProperty.Builder)propB);
            }
        }, tensorProperties);
    }
}

